/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.event.ActionEvent;
import java.util.List;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

class NewSummaryAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public NewSummaryAction() {
        super("NewSummaryAction");
    }

    public void actionPerformed(ActionEvent e) {
        this.addNewSummaryNodeStartEditing();
    }

    private void addNewSummaryNodeStartEditing() {
        ModeController modeController = Controller.getCurrentModeController();
        IMapSelection selection = modeController.getController().getSelection();
        List sortedSelection = selection.getSortedSelection(false);
        NodeModel firstNode = (NodeModel)sortedSelection.get(0);
        NodeModel lastNode = (NodeModel)sortedSelection.get(sortedSelection.size() - 1);
        NodeModel selectionRoot = selection.getSelectionRoot();
        boolean isTopOrLeft = firstNode.isTopOrLeft(selectionRoot);
        if (isTopOrLeft != lastNode.isTopOrLeft(selectionRoot)) {
            UITools.errorMessage((Object)TextUtils.getText((String)"summary_not_possible"));
            return;
        }
        NodeModel parentNode = firstNode.getParentNode();
        if (parentNode == null) {
            UITools.errorMessage((Object)TextUtils.getText((String)"summary_not_possible"));
            return;
        }
        NodeModel lastParent = lastNode.getParentNode();
        if (lastParent == null) {
            UITools.errorMessage((Object)TextUtils.getText((String)"summary_not_possible"));
            return;
        }
        if (parentNode.equals(lastParent)) {
            this.addNewSummaryNodeStartEditing(selectionRoot, firstNode, lastNode);
        } else {
            NodeRelativePath nodeRelativePath = new NodeRelativePath(firstNode, lastNode);
            NodeModel commonAncestor = nodeRelativePath.commonAncestor();
            if (commonAncestor == firstNode || commonAncestor == lastNode) {
                UITools.errorMessage((Object)TextUtils.getText((String)"summary_not_possible"));
                return;
            }
            NodeModel newFirstNode = nodeRelativePath.beginPathElement(1);
            NodeModel newLastNode = nodeRelativePath.endPathElement(1);
            this.addNewSummaryNodeStartEditing(selectionRoot, newFirstNode, newLastNode);
        }
    }

    private void addNewSummaryNodeStartEditing(NodeModel selectionRoot, NodeModel firstNode, NodeModel lastNode) {
        NodeModel parentNode = firstNode.getParentNode();
        ModeController modeController = Controller.getCurrentModeController();
        boolean isTopOrLeft = firstNode.isTopOrLeft(selectionRoot);
        int start = parentNode.getIndex(firstNode);
        int end = parentNode.getIndex(lastNode);
        if (end < start) {
            int temp = end;
            end = start;
            start = temp;
        }
        ((MMapController)modeController.getMapController()).addNewSummaryNodeStartEditing(selectionRoot, parentNode, start, end, isTopOrLeft);
    }
}

