#! @Chunk Groebner1

LoadPackage( "4ti2Interface" );

#! We want to compute the groebner basis of the ideal
#! defining the affine toric variety associated to the cone
#! generated by the inequalities [ [ 7, -1 ], [ 0, 1 ] ], 
#! i.e. a rational normal curve.

#! @Example
cone := [ [ 7, -1 ], [ 0, 1 ] ];
#! [ [ 7, -1 ], [ 0, 1 ] ]
basis := 4ti2Interface_hilbert_inequalities( cone );;
Sort( basis );
basis;
#! [ [ 1, 0 ], [ 1, 1 ], [ 1, 2 ], [ 1, 3 ],
#!   [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 1, 7 ] ]
groebner := 4ti2Interface_groebner_matrix( basis );;
Sort( groebner );
groebner;
#! [ [ -1, 0, 0, 1, 1, 0, 0, -1 ], [ -1, 0, 0, 2, 0, 0, -1, 0 ],
#!   [ -1, 0, 1, 0, 0, 1, 0, -1 ], [ -1, 0, 1, 0, 1, 0, -1, 0 ],
#!   [ -1, 0, 1, 1, 0, -1, 0, 0 ], [ -1, 0, 2, 0, -1, 0, 0, 0 ],
#!   [ -1, 1, 0, 0, 0, 0, 1, -1 ], [ -1, 1, 0, 0, 0, 1, -1, 0 ],
#!   [ -1, 1, 0, 0, 1, -1, 0, 0 ], [ -1, 1, 0, 1, -1, 0, 0, 0 ],
#!   [ -1, 1, 1, -1, 0, 0, 0, 0 ], [ -1, 2, -1, 0, 0, 0, 0, 0 ],
#!   [ 0, -1, 0, 0, 2, 0, 0, -1 ], [ 0, -1, 0, 1, 0, 1, 0, -1 ],
#!   [ 0, -1, 1, 0, 0, 0, 1, -1 ], [ 0, 0, -1, 0, 1, 1, 0, -1 ],
#!   [ 0, 0, -1, 1, 0, 0, 1, -1 ], [ 0, 0, 0, -1, 0, 2, 0, -1 ],
#!   [ 0, 0, 0, -1, 1, 0, 1, -1 ], [ 0, 0, 0, 0, -1, 1, 1, -1 ],
#!   [ 0, 0, 0, 0, 0, -1, 2, -1 ] ]
Length( groebner );
#! 21
#! @EndExample
