/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.info;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.config.TimezoneHelper;
import tim.prune.data.AltitudeRange;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.MediaObject;
import tim.prune.data.RangeStatsWithGradients;
import tim.prune.data.Selection;
import tim.prune.data.SpeedCalculator;
import tim.prune.data.SpeedValue;
import tim.prune.data.Track;
import tim.prune.data.Unit;
import tim.prune.data.UnitSet;
import tim.prune.gui.CoordDisplay;
import tim.prune.gui.DisplayUtils;

public class ShowFullDetails
extends GenericFunction {
    private JDialog _dialog = null;
    private JTabbedPane _tabs = null;
    private JButton _okButton = null;
    private JTextArea _pointTextArea = null;
    private JTextArea _rangeTextArea = null;

    public ShowFullDetails(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.viewfulldetails";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.updateDetails();
        this._dialog.setVisible(true);
        this._okButton.requestFocus();
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._tabs = new JTabbedPane();
        jPanel.add((Component)this._tabs, "Center");
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ShowFullDetails.this._dialog.dispose();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this._tabs.addKeyListener(keyListener);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this._pointTextArea = new JTextArea(I18nManager.getText("details.nopointselection"));
        this._pointTextArea.setEditable(false);
        this._pointTextArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this._pointTextArea);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(500, 230));
        jPanel2.add((Component)jScrollPane, "Center");
        this._tabs.add(I18nManager.getText("details.pointdetails"), jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this._rangeTextArea = new JTextArea(I18nManager.getText("details.norangeselection"));
        this._rangeTextArea.setEditable(false);
        this._rangeTextArea.setLineWrap(true);
        JScrollPane jScrollPane2 = new JScrollPane(this._rangeTextArea);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setPreferredSize(new Dimension(500, 230));
        jPanel3.add((Component)jScrollPane2, "Center");
        this._tabs.add(I18nManager.getText("details.rangedetails"), jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(actionEvent -> this._dialog.dispose());
        this._okButton.addKeyListener(keyListener);
        jPanel4.add(this._okButton);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private void updateDetails() {
        Object object;
        if (this._app.getTrackInfo().getCurrentPoint() != null) {
            object = ShowFullDetails.makePointDescription(this._app.getTrackInfo().getTrack(), this._app.getTrackInfo().getSelection().getCurrentPointIndex());
            this._pointTextArea.setText((String)object);
            this._tabs.setSelectedIndex(0);
        } else {
            this._pointTextArea.setText(I18nManager.getText("details.nopointselection"));
            this._tabs.setSelectedIndex(1);
        }
        object = this._app.getTrackInfo().getSelection();
        if (((Selection)object).hasRangeSelected()) {
            int n = Config.getConfigInt("prune.altitudetolerance") / 100;
            RangeStatsWithGradients rangeStatsWithGradients = new RangeStatsWithGradients(this._app.getTrackInfo().getTrack(), ((Selection)object).getStart(), ((Selection)object).getEnd(), n);
            SpeedValue speedValue = ShowFullDetails.calculateMaxSpeed(this._app.getTrackInfo().getTrack(), ((Selection)object).getStart(), ((Selection)object).getEnd());
            this._rangeTextArea.setText(ShowFullDetails.makeRangeDescription(rangeStatsWithGradients, speedValue));
        } else {
            this._rangeTextArea.setText(I18nManager.getText("details.norangeselection"));
        }
    }

    private static SpeedValue calculateMaxSpeed(Track track, int n, int n2) {
        SpeedValue speedValue = new SpeedValue();
        SpeedValue speedValue2 = new SpeedValue();
        int n3 = n;
        while (n3 <= n2) {
            SpeedCalculator.calculateSpeed(track, n3, speedValue2);
            if (speedValue2.isValid() && (!speedValue.isValid() || speedValue2.getValue() > speedValue.getValue())) {
                speedValue.setValue(speedValue2.getValue());
            }
            ++n3;
        }
        return speedValue;
    }

    private static String makePointDescription(Track track, int n) {
        Object object;
        Object object2;
        Object object3;
        DataPoint dataPoint = track.getPoint(n);
        if (dataPoint == null) {
            return "";
        }
        int n2 = Coordinate.getCoordinateFormatForDisplay(Config.getConfigInt("prune.coorddisplay"));
        StringBuffer stringBuffer = new StringBuffer();
        String string = CoordDisplay.makeCoordinateLabel(dataPoint.getLatitude(), n2);
        String string2 = CoordDisplay.makeCoordinateLabel(dataPoint.getLongitude(), n2);
        ShowFullDetails.addTextPair(stringBuffer, "fieldname.latitude", string);
        ShowFullDetails.addTextPair(stringBuffer, "fieldname.longitude", string2);
        ShowFullDetails.addTextPair(stringBuffer, "fieldname.coordinates", String.valueOf(string) + ", " + string2);
        if (dataPoint.hasAltitude()) {
            object3 = Config.getUnitSet().getAltitudeUnit();
            ShowFullDetails.addTextPair(stringBuffer, "fieldname.altitude", "" + dataPoint.getAltitude().getValue((Unit)object3), I18nManager.getText(((Unit)object3).getShortnameKey()));
        }
        if (dataPoint.hasTimestamp()) {
            object3 = TimezoneHelper.getSelectedTimezone();
            ShowFullDetails.addTextPair(stringBuffer, "fieldname.date", dataPoint.getTimestamp().getDateText((TimeZone)object3));
            ShowFullDetails.addTextPair(stringBuffer, "fieldname.timestamp", dataPoint.getTimestamp().getTimeText((TimeZone)object3));
        }
        ShowFullDetails.addTextPair(stringBuffer, "fieldname.waypointname", dataPoint.getWaypointName());
        ShowFullDetails.addTextPair(stringBuffer, "fieldname.description", dataPoint.getFieldValue(Field.DESCRIPTION));
        ShowFullDetails.addTextPair(stringBuffer, "fieldname.comment", dataPoint.getFieldValue(Field.COMMENT));
        ShowFullDetails.addTextPair(stringBuffer, "fieldname.symbol", dataPoint.getFieldValue(Field.SYMBOL));
        ShowFullDetails.addTextPair(stringBuffer, "fieldname.waypointtype", dataPoint.getFieldValue(Field.WAYPT_TYPE));
        object3 = new SpeedValue();
        SpeedCalculator.calculateSpeed(track, n, (SpeedValue)object3);
        UnitSet unitSet = Config.getUnitSet();
        if (((SpeedValue)object3).isValid()) {
            object2 = I18nManager.getText(unitSet.getSpeedUnit().getShortnameKey());
            object = DisplayUtils.roundedNumber(((SpeedValue)object3).getValue());
            ShowFullDetails.addTextPair(stringBuffer, "fieldname.speed", (String)object, (String)object2);
        }
        SpeedCalculator.calculateVerticalSpeed(track, n, (SpeedValue)object3);
        if (((SpeedValue)object3).isValid()) {
            object2 = I18nManager.getText(unitSet.getVerticalSpeedUnit().getShortnameKey());
            object = DisplayUtils.roundedNumber(((SpeedValue)object3).getValue());
            ShowFullDetails.addTextPair(stringBuffer, "fieldname.verticalspeed", (String)object, (String)object2);
        }
        if ((object2 = dataPoint.getPhoto()) != null) {
            ShowFullDetails.addTextPair(stringBuffer, "details.photofile", ((MediaObject)object2).getName());
            ShowFullDetails.addTextPair(stringBuffer, "details.media.fullpath", ((MediaObject)object2).getFullPath());
        }
        if ((object = dataPoint.getAudio()) != null) {
            ShowFullDetails.addTextPair(stringBuffer, "details.audio.file", ((MediaObject)object).getName());
            ShowFullDetails.addTextPair(stringBuffer, "details.media.fullpath", ((MediaObject)object).getFullPath());
        }
        return stringBuffer.toString();
    }

    private static String makeRangeDescription(RangeStatsWithGradients rangeStatsWithGradients, SpeedValue speedValue) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        ShowFullDetails.addTextPair(stringBuffer, "details.track.points", "" + rangeStatsWithGradients.getNumPoints());
        ShowFullDetails.addTextPair(stringBuffer, "details.range.numsegments", "" + rangeStatsWithGradients.getNumSegments());
        boolean bl = rangeStatsWithGradients.getNumSegments() > 1;
        UnitSet unitSet = Config.getUnitSet();
        String string = I18nManager.getText(unitSet.getSpeedUnit().getShortnameKey());
        if (speedValue.isValid()) {
            object = String.valueOf(DisplayUtils.roundedNumber(speedValue.getValue())) + " " + string;
            ShowFullDetails.addTextPair(stringBuffer, "details.range.maxspeed", (String)object);
        }
        ShowFullDetails.addHeading(stringBuffer, "dialog.fullrangedetails.colsegments");
        object = Config.getUnitSet().getDistanceUnit();
        String string2 = I18nManager.getText(((Unit)object).getShortnameKey());
        double d = rangeStatsWithGradients.getMovingDistance();
        ShowFullDetails.addTextPair(stringBuffer, "fieldname.distance", DisplayUtils.roundedNumber(d), string2);
        long l = rangeStatsWithGradients.getMovingDurationInSeconds();
        ShowFullDetails.addTextPair(stringBuffer, "fieldname.duration", DisplayUtils.buildDurationString(l));
        if (l > 0L && d > 0.0) {
            ShowFullDetails.addTextPair(stringBuffer, "details.range.avespeed", DisplayUtils.roundedNumber(d / (double)l * 3600.0), string);
            ShowFullDetails.addTextPair(stringBuffer, "details.range.pace", DisplayUtils.buildDurationString((long)((double)l / d)), "/ " + string2);
        }
        Unit unit = unitSet.getAltitudeUnit();
        String string3 = I18nManager.getText(unit.getShortnameKey());
        if (rangeStatsWithGradients.getMovingAltitudeRange().hasRange()) {
            AltitudeRange altitudeRange = rangeStatsWithGradients.getMovingAltitudeRange();
            ShowFullDetails.addTextPair(stringBuffer, "fieldname.altitude", altitudeRange.getMinimum(unit) + string3 + " " + I18nManager.getText("details.altitude.to") + " " + altitudeRange.getMaximum(unit) + string3);
            ShowFullDetails.addTextPair(stringBuffer, "details.range.climb", "" + altitudeRange.getClimb(unit), string3);
            ShowFullDetails.addTextPair(stringBuffer, "details.range.descent", "" + altitudeRange.getDescent(unit), string3);
            ShowFullDetails.addTextPair(stringBuffer, "details.range.gradient", DisplayUtils.formatOneDp(rangeStatsWithGradients.getMovingGradient()), "%");
            if (l > 0L) {
                String string4 = I18nManager.getText(unitSet.getVerticalSpeedUnit().getShortnameKey());
                String string5 = DisplayUtils.roundedNumber(rangeStatsWithGradients.getMovingVerticalSpeed());
                ShowFullDetails.addTextPair(stringBuffer, "fieldname.verticalspeed", string5, string4);
            }
        }
        if (bl) {
            ShowFullDetails.addHeading(stringBuffer, "dialog.fullrangedetails.coltotal");
            double d2 = rangeStatsWithGradients.getTotalDistance();
            ShowFullDetails.addTextPair(stringBuffer, "fieldname.distance", DisplayUtils.roundedNumber(d2), string2);
            long l2 = rangeStatsWithGradients.getTotalDurationInSeconds();
            ShowFullDetails.addTextPair(stringBuffer, "fieldname.duration", DisplayUtils.buildDurationString(l2));
            if (l2 > 0L && d2 > 0.0) {
                ShowFullDetails.addTextPair(stringBuffer, "details.range.avespeed", DisplayUtils.roundedNumber(d2 / (double)l2 * 3600.0), string);
                ShowFullDetails.addTextPair(stringBuffer, "details.range.pace", DisplayUtils.buildDurationString((long)((double)l2 / d2)), "/ " + string2);
            }
            if (rangeStatsWithGradients.getTotalAltitudeRange().hasRange()) {
                AltitudeRange altitudeRange = rangeStatsWithGradients.getTotalAltitudeRange();
                ShowFullDetails.addTextPair(stringBuffer, "details.range.climb", "" + altitudeRange.getClimb(unit), string3);
                ShowFullDetails.addTextPair(stringBuffer, "details.range.descent", "" + altitudeRange.getDescent(unit), string3);
                ShowFullDetails.addTextPair(stringBuffer, "details.range.gradient", DisplayUtils.formatOneDp(rangeStatsWithGradients.getTotalGradient()), "%");
                if (l2 > 0L) {
                    String string6 = I18nManager.getText(unitSet.getVerticalSpeedUnit().getShortnameKey());
                    String string7 = DisplayUtils.roundedNumber(rangeStatsWithGradients.getTotalVerticalSpeed());
                    ShowFullDetails.addTextPair(stringBuffer, "fieldname.verticalspeed", string7, string6);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static void addTextPair(StringBuffer stringBuffer, String string, String string2) {
        ShowFullDetails.addTextPair(stringBuffer, string, string2, null);
    }

    private static void addTextPair(StringBuffer stringBuffer, String string, String string2, String string3) {
        if (string2 != null && !string2.equals("")) {
            stringBuffer.append(I18nManager.getText(string));
            stringBuffer.append(": ");
            stringBuffer.append(string2);
            if (string3 != null && !string3.equals("")) {
                stringBuffer.append(' ');
                stringBuffer.append(string3);
            }
            stringBuffer.append("\n");
        }
    }

    private static void addHeading(StringBuffer stringBuffer, String string) {
        String string2 = I18nManager.getText(string);
        stringBuffer.append('\n').append(string2).append('\n');
        int n = 0;
        while (n < string2.length()) {
            stringBuffer.append('=');
            ++n;
        }
        stringBuffer.append('\n');
    }
}

