/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.api.Transformer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.internal.serialize.ExceptionPlaceholder;
import org.gradle.internal.serialize.TopLevelExceptionPlaceholder;

public class ExceptionReplacingObjectInputStream
extends ClassLoaderObjectInputStream {
    private Transformer<Object, Object> objectTransformer = new Transformer<Object, Object>(){

        public Object transform(Object o) {
            try {
                return ExceptionReplacingObjectInputStream.this.doResolveObject(o);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    };

    public ExceptionReplacingObjectInputStream(InputStream inputSteam, ClassLoader classLoader) throws IOException {
        super(inputSteam, classLoader);
        this.enableResolveObject(true);
    }

    public final Transformer<ExceptionReplacingObjectInputStream, InputStream> getObjectInputStreamCreator() {
        return new Transformer<ExceptionReplacingObjectInputStream, InputStream>(){

            public ExceptionReplacingObjectInputStream transform(InputStream inputStream) {
                try {
                    return ExceptionReplacingObjectInputStream.this.createNewInstance(inputStream);
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        };
    }

    protected ExceptionReplacingObjectInputStream createNewInstance(InputStream inputStream) throws IOException {
        return new ExceptionReplacingObjectInputStream(inputStream, this.getClassLoader());
    }

    protected final Object resolveObject(Object obj) throws IOException {
        return this.getObjectTransformer().transform(obj);
    }

    protected Object doResolveObject(Object obj) throws IOException {
        if (obj instanceof TopLevelExceptionPlaceholder) {
            return ((ExceptionPlaceholder)obj).read(this.getClassNameTransformer(), this.getObjectInputStreamCreator());
        }
        return obj;
    }

    protected final Transformer<Class<?>, String> getClassNameTransformer() {
        return new Transformer<Class<?>, String>(){

            public Class<?> transform(String type) {
                try {
                    return ExceptionReplacingObjectInputStream.this.lookupClass(type);
                }
                catch (ClassNotFoundException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        };
    }

    protected Class<?> lookupClass(String type) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(type);
    }

    public Transformer<Object, Object> getObjectTransformer() {
        return this.objectTransformer;
    }

    public void setObjectTransformer(Transformer<Object, Object> objectTransformer) {
        this.objectTransformer = objectTransformer;
    }
}

