/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.ExecutionResult;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.OutputExecutionState;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.steps.ChangingOutputsContext;
import org.gradle.internal.execution.steps.InputChangesContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.work.InputChanges;

public class ExecuteStep<C extends ChangingOutputsContext>
implements Step<C, Result> {
    private final BuildOperationExecutor buildOperationExecutor;

    public ExecuteStep(BuildOperationExecutor buildOperationExecutor) {
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public Result execute(final UnitOfWork work, final C context) {
        return (Result)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<Result>(){

            public Result call(BuildOperationContext operationContext) {
                Result result = ExecuteStep.executeInternal(work, context);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return result;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Executing " + work.getDisplayName())).details((Object)Operation.Details.INSTANCE);
            }
        });
    }

    private static Result executeInternal(UnitOfWork work, final InputChangesContext context) {
        UnitOfWork.WorkOutput workOutput;
        UnitOfWork.ExecutionRequest executionRequest = new UnitOfWork.ExecutionRequest(){

            @Override
            public File getWorkspace() {
                return context.getWorkspace();
            }

            @Override
            public Optional<InputChangesInternal> getInputChanges() {
                return context.getInputChanges();
            }

            @Override
            public Optional<ImmutableSortedMap<String, FileSystemSnapshot>> getPreviouslyProducedOutputs() {
                return context.getPreviousExecutionState().map(OutputExecutionState::getOutputFilesProducedByWork);
            }
        };
        Timer timer = Time.startTimer();
        try {
            workOutput = work.execute(executionRequest);
        }
        catch (Throwable t) {
            return ResultImpl.failed(t, Duration.ofMillis(timer.getElapsedMillis()));
        }
        Duration duration = Duration.ofMillis(timer.getElapsedMillis());
        ExecutionOutcome outcome = ExecuteStep.determineOutcome(context, workOutput);
        return ResultImpl.success(duration, new ExecutionResultImpl(outcome, workOutput));
    }

    private static ExecutionOutcome determineOutcome(InputChangesContext context, UnitOfWork.WorkOutput workOutput) {
        ExecutionOutcome outcome;
        switch (workOutput.getDidWork()) {
            case DID_NO_WORK: {
                outcome = ExecutionOutcome.UP_TO_DATE;
                break;
            }
            case DID_WORK: {
                boolean incremental = context.getInputChanges().map(InputChanges::isIncremental).orElse(false);
                outcome = incremental ? ExecutionOutcome.EXECUTED_INCREMENTALLY : ExecutionOutcome.EXECUTED_NON_INCREMENTALLY;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return outcome;
    }

    private static final class ExecutionResultImpl
    implements ExecutionResult {
        private final ExecutionOutcome outcome;
        private final UnitOfWork.WorkOutput workOutput;

        public ExecutionResultImpl(ExecutionOutcome outcome, UnitOfWork.WorkOutput workOutput) {
            this.outcome = outcome;
            this.workOutput = workOutput;
        }

        @Override
        public ExecutionOutcome getOutcome() {
            return this.outcome;
        }

        @Override
        public Object getOutput() {
            return this.workOutput.getOutput();
        }
    }

    private static final class ResultImpl
    implements Result {
        private final Duration duration;
        private final Try<ExecutionResult> executionResultTry;

        private ResultImpl(Duration duration, Try<ExecutionResult> executionResultTry) {
            this.duration = duration;
            this.executionResultTry = executionResultTry;
        }

        private static Result failed(Throwable t, Duration duration) {
            return new ResultImpl(duration, (Try<ExecutionResult>)Try.failure((Throwable)t));
        }

        private static Result success(Duration duration, ExecutionResult executionResult) {
            return new ResultImpl(duration, (Try<ExecutionResult>)Try.successful((Object)executionResult));
        }

        @Override
        public Duration getDuration() {
            return this.duration;
        }

        @Override
        public Try<ExecutionResult> getExecutionResult() {
            return this.executionResultTry;
        }
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }
}

