/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirGlobalResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessorKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTransformerBasedResolveProcessor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirTotalResolveProcessor;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "processors", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirResolveProcessor;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "process", "", "files", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "resolve"})
public final class FirTotalResolveProcessor {
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final List<FirResolveProcessor> processors;

    public FirTotalResolveProcessor(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.scopeSession = new ScopeSession();
        this.processors = FirTotalResolveProcessorKt.createAllCompilerResolveProcessors(session2, this.scopeSession);
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    public final void process(@NotNull List<? extends FirFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        for (FirResolveProcessor processor2 : this.processors) {
            processor2.beforePhase();
            FirResolveProcessor firResolveProcessor = processor2;
            if (firResolveProcessor instanceof FirTransformerBasedResolveProcessor) {
                for (FirFile firFile : files2) {
                    ((FirTransformerBasedResolveProcessor)processor2).processFile(firFile);
                }
            } else if (firResolveProcessor instanceof FirGlobalResolveProcessor) {
                ((FirGlobalResolveProcessor)processor2).process((Collection<? extends FirFile>)files2);
            }
            processor2.afterPhase();
        }
    }
}

