/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.gwt.dev.js.parserExceptions.AbortParsingException;
import org.jetbrains.kotlin.com.google.gwt.dev.js.rhino.CodePosition;
import org.jetbrains.kotlin.com.google.gwt.dev.js.rhino.ErrorReporter;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCodeErrorReporter;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;)V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Companion", "js.frontend"})
public final class JsCallChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private static final DescriptorPredicate JS_PATTERN;

    public JsCallChecker(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        Intrinsics.checkNotNullParameter((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isAnnotationContext() || !Companion.isJsCall(resolvedCall2)) {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"resolvedCall.call.callElement");
        KtElement expression2 = ktElement;
        if (!(expression2 instanceof KtCallExpression)) {
            return;
        }
        KtValueArgumentList ktValueArgumentList = ((KtCallExpression)expression2).getValueArgumentList();
        List<KtValueArgument> arguments2 = ktValueArgumentList != null ? ktValueArgumentList.getArguments() : null;
        List<KtValueArgument> list2 = arguments2;
        if (list2 == null || (list2 = (KtValueArgument)CollectionsKt.firstOrNull(list2)) == null || (list2 = ((KtValueArgument)((Object)list2)).getArgumentExpression()) == null) {
            return;
        }
        List<KtValueArgument> argument2 = list2;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.getTrace(), "JsCallChecker");
        Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"create(context.trace, \"JsCallChecker\")");
        TemporaryBindingTrace trace = temporaryBindingTrace;
        CompileTimeConstant evaluationResult = ConstantExpressionEvaluator.evaluateExpression$default(this.constantExpressionEvaluator, (KtExpression)((Object)argument2), trace, TypeUtils.NO_EXPECTED_TYPE, false, 8, null);
        String code = Companion.extractStringValue(evaluationResult);
        if (code == null) {
            context.getTrace().report(ErrorsJs.JSCODE_ARGUMENT_SHOULD_BE_CONSTANT.on((KtExpression)((PsiElement)((Object)argument2))));
            return;
        }
        trace.commit();
        JsCodeErrorReporter errorReporter = new JsCodeErrorReporter((KtExpression)((Object)argument2), code, context.getTrace());
        try {
            List<JsStatement> statements;
            JsFunctionScope parserScope = new JsFunctionScope(new JsRootScope(new JsProgram()), "<js fun>");
            ErrorReporter errorReporter2 = errorReporter;
            JsScope jsScope = parserScope;
            CodePosition codePosition = new CodePosition(0, 0);
            Object object = reportOn.getContainingFile();
            if (object == null || (object = object.getName()) == null) {
                object = "<unknown file>";
            }
            if ((statements = ParserUtilsKt.parseExpressionOrStatement(code, errorReporter2, jsScope, codePosition, (String)object)) == null || statements.isEmpty()) {
                context.getTrace().report(ErrorsJs.JSCODE_NO_JAVASCRIPT_PRODUCED.on((KtExpression)((PsiElement)((Object)argument2))));
            }
        }
        catch (AbortParsingException abortParsingException) {
            // empty catch block
        }
        context.getTrace().record(BindingContextSlicesJsKt.LEXICAL_SCOPE_FOR_JS, resolvedCall2, context.getScope());
    }

    @JvmStatic
    public static final <F extends CallableDescriptor> boolean isJsCall(@NotNull ResolvedCall<F> $this$isJsCall) {
        return Companion.isJsCall($this$isJsCall);
    }

    @JvmStatic
    @Nullable
    public static final String extractStringValue(@Nullable CompileTimeConstant<?> compileTimeConstant) {
        return Companion.extractStringValue(compileTimeConstant);
    }

    static {
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern("kotlin.js.js(String)");
        Intrinsics.checkNotNullExpressionValue((Object)descriptorPredicate, (String)"pattern(\"kotlin.js.js(String)\")");
        JS_PATTERN = descriptorPredicate;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u0007J\u001e\u0010\t\u001a\u00020\n\"\n\b\u0000\u0010\u000b*\u0004\u0018\u00010\f*\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallChecker$Companion;", "", "()V", "JS_PATTERN", "Lorg/jetbrains/kotlin/js/patterns/DescriptorPredicate;", "extractStringValue", "", "compileTimeConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "isJsCall", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "js.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final <F extends CallableDescriptor> boolean isJsCall(@NotNull ResolvedCall<F> $this$isJsCall) {
            Intrinsics.checkNotNullParameter($this$isJsCall, (String)"<this>");
            F descriptor2 = $this$isJsCall.getResultingDescriptor();
            return descriptor2 instanceof SimpleFunctionDescriptor && JS_PATTERN.test(descriptor2);
        }

        @JvmStatic
        @Nullable
        public final String extractStringValue(@Nullable CompileTimeConstant<?> compileTimeConstant) {
            TypedCompileTimeConstant typedCompileTimeConstant = compileTimeConstant instanceof TypedCompileTimeConstant ? (TypedCompileTimeConstant)compileTimeConstant : null;
            ConstantValue constantValue = typedCompileTimeConstant != null ? typedCompileTimeConstant.getConstantValue() : null;
            StringValue stringValue = constantValue instanceof StringValue ? (StringValue)constantValue : null;
            return stringValue != null ? (String)stringValue.getValue() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

