/**
 * Match `import.meta.resolve` except that `parent` is required (you can pass
 * `import.meta.url`).
 *
 * @param {string} specifier
 *   The module specifier to resolve relative to parent
 *   (`/example.js`, `./example.js`, `../example.js`, `some-package`, `fs`,
 *   etc).
 * @param {string} parent
 *   The absolute parent module URL to resolve from.
 *   You should pass `import.meta.url` or something else.
 * @returns {Promise<string>}
 *   Returns a promise that resolves to a full `file:`, `data:`, or `node:` URL
 *   to the found thing.
 */
export function resolve(specifier: string, parent: string): Promise<string>
export {moduleResolve} from './lib/resolve.js'
export type ErrnoException = import('./lib/errors.js').ErrnoException
