/// <reference types="node" resolution-mode="require"/>
/**
 * Search `patterns`, a mix of globs, paths, and files.
 *
 * @param {Array<string|VFile>} input
 * @param {Options} options
 * @param {Callback} callback
 */
export function finder(
  input: Array<string | VFile>,
  options: Options,
  callback: Callback
): void
export type Stats = import('fs').Stats
export type VFile = import('vfile').VFile
export type Ignore = import('./ignore.js').Ignore
export type GitIgnore = import('ignore').Ignore
export type Options = {
  cwd: string
  extensions: Array<string>
  silentlyIgnore: boolean | undefined
  ignorePatterns: Array<string>
  ignore: Ignore
}
export type SearchResults = {
  stats: fs.Stats | undefined
  ignored: boolean | undefined
}
export type Result = {
  input: Array<string | VFile>
  output: Array<VFile>
}
export type CleanResult = {
  oneFileMode: boolean
  files: Array<VFile>
}
export type Callback = (
  error: Error | null,
  result?: CleanResult | undefined
) => any
import fs from 'node:fs'
