/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnarinchi;

import io.github.dan2097.jnarinchi.RinchiFlag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;

public class RinchiOptions {
    public static final RinchiOptions DEFAULT_OPTIONS = RinchiOptions.builder().build();
    private static final boolean IS_WINDOWS = System.getProperty("os.name", "").toLowerCase(Locale.ROOT).startsWith("windows");
    private final List<RinchiFlag> flags;

    private RinchiOptions(RinchiOptionsBuilder builder) {
        this.flags = Collections.unmodifiableList(new ArrayList(builder.flags));
    }

    public static RinchiOptionsBuilder builder() {
        return new RinchiOptionsBuilder();
    }

    public List<RinchiFlag> getFlags() {
        return this.flags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (RinchiFlag rinchiFlag : this.flags) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(IS_WINDOWS ? "/" : "-");
            sb.append(rinchiFlag.toString());
        }
        return sb.toString();
    }

    public static class RinchiOptionsBuilder {
        private final EnumSet<RinchiFlag> flags = EnumSet.noneOf(RinchiFlag.class);

        private RinchiOptionsBuilder() {
        }

        public RinchiOptionsBuilder withFlag(RinchiFlag ... flags) {
            Collections.addAll(this.flags, flags);
            return this;
        }

        public RinchiOptions build() {
            return new RinchiOptions(this);
        }
    }
}

