/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.Quat;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.BioResolver;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;

public abstract class Monomer
extends Group {
    public BioPolymer bioPolymer;
    protected byte[] offsets;
    int monomerIndex = -1;
    private float phi = Float.NaN;
    private float psi = Float.NaN;
    private float omega = Float.NaN;
    private float straightness = Float.NaN;
    private float mu = Float.NaN;
    private float theta = Float.NaN;
    public boolean backboneBlockVis;

    protected static boolean have(byte[] offsets, byte n) {
        return (offsets[n] & 0xFF) != 255;
    }

    protected Monomer set2(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] interestingAtomOffsets) {
        this.setGroup(chain, group3, seqcode, firstAtomIndex, lastAtomIndex);
        this.offsets = interestingAtomOffsets;
        this.setLeadAtomIndex();
        return this;
    }

    protected void setLeadAtomIndex() {
        int offset = this.offsets[0] & 0xFF;
        if (offset != 255) {
            this.leadAtomIndex = this.firstAtomIndex + offset;
        }
    }

    void setBioPolymer(BioPolymer polymer, int index) {
        this.bioPolymer = polymer;
        this.monomerIndex = index;
    }

    @Override
    public int getSelectedMonomerCount() {
        return this.bioPolymer == null ? 0 : this.bioPolymer.getSelectedMonomerCount();
    }

    @Override
    public int getSelectedMonomerIndex() {
        return this.bioPolymer == null || !this.bioPolymer.isMonomerSelected(this.monomerIndex) ? -1 : this.monomerIndex;
    }

    @Override
    public int getBioPolymerLength() {
        return this.bioPolymer == null ? 0 : this.bioPolymer.monomerCount;
    }

    @Override
    public int getMonomerIndex() {
        return this.monomerIndex;
    }

    @Override
    public int getAtomIndex(String name, int offset) {
        if (this.bioPolymer != null) {
            Monomer[] groups = this.bioPolymer.monomers;
            int ipt = this.monomerIndex + offset;
            if (ipt >= 0 && ipt < groups.length) {
                Monomer m = groups[ipt];
                if (offset == 1 && !m.isConnectedPrevious()) {
                    return -1;
                }
                if ("\u0000".equals(name)) {
                    return m.leadAtomIndex;
                }
                Atom[] atoms = this.chain.model.ms.at;
                for (int i = m.firstAtomIndex; i <= m.lastAtomIndex; ++i) {
                    if (atoms[i] == null || name != null && !name.equalsIgnoreCase(atoms[i].getAtomName())) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    @Override
    public int getBioPolymerIndexInModel() {
        return this.bioPolymer == null ? -1 : this.bioPolymer.bioPolymerIndexInModel;
    }

    protected static byte[] scanForOffsets(int firstAtomIndex, int[] specialAtomIndexes, byte[] interestingAtomIDs) {
        int interestingCount = interestingAtomIDs.length;
        byte[] offsets = new byte[interestingCount];
        int i = interestingCount;
        while (--i >= 0) {
            int offset;
            int atomIndex;
            byte atomID = interestingAtomIDs[i];
            if (atomID < 0) {
                atomIndex = specialAtomIndexes[~atomID];
            } else {
                atomIndex = specialAtomIndexes[atomID];
                if (atomIndex < 0) {
                    return null;
                }
            }
            if (atomIndex < 0) {
                offset = 255;
            } else {
                offset = atomIndex - firstAtomIndex;
                if (offset < 0 || offset > 254) {
                    Logger.warn("Monomer.scanForOffsets i=" + i + " atomID=" + atomID + " atomIndex:" + atomIndex + " firstAtomIndex:" + firstAtomIndex + " offset out of 0-254 range. Groups aren't organized correctly. Is this really a protein?: " + offset);
                    if (atomID < 0) {
                        offset = 255;
                    }
                }
            }
            offsets[i] = (byte)offset;
        }
        return offsets;
    }

    @Override
    public STR getProteinStructureType() {
        return STR.NONE;
    }

    public boolean isHelix() {
        return false;
    }

    public boolean isSheet() {
        return false;
    }

    @Override
    public void setStrucNo(int id) {
    }

    protected final Atom getAtomFromOffsetIndex(int offsetIndex) {
        if (offsetIndex > this.offsets.length) {
            return null;
        }
        int offset = this.offsets[offsetIndex] & 0xFF;
        return offset == 255 ? null : this.chain.model.ms.at[this.firstAtomIndex + offset];
    }

    protected final Atom getSpecialAtom(byte[] interestingIDs, byte specialAtomID) {
        int i = interestingIDs.length;
        while (--i >= 0) {
            byte interestingID = interestingIDs[i];
            if (interestingID < 0) {
                interestingID = -interestingID;
            }
            if (specialAtomID != interestingID) continue;
            int offset = this.offsets[i] & 0xFF;
            return offset == 255 ? null : this.chain.model.ms.at[this.firstAtomIndex + offset];
        }
        return null;
    }

    protected final P3 getSpecialAtomPoint(byte[] interestingIDs, byte specialAtomID) {
        int i = interestingIDs.length;
        while (--i >= 0) {
            byte interestingID = interestingIDs[i];
            if (interestingID < 0) {
                interestingID = -interestingID;
            }
            if (specialAtomID != interestingID) continue;
            int offset = this.offsets[i] & 0xFF;
            return offset == 255 ? null : this.chain.model.ms.at[this.firstAtomIndex + offset];
        }
        return null;
    }

    @Override
    public boolean isLeadAtom(int atomIndex) {
        return atomIndex == this.leadAtomIndex;
    }

    @Override
    public final Atom getLeadAtom() {
        return this.getAtomFromOffsetIndex(0);
    }

    public final Atom getWingAtom() {
        return this.getAtomFromOffsetIndex(1);
    }

    Atom getInitiatorAtom() {
        return this.getLeadAtom();
    }

    Atom getTerminatorAtom() {
        return this.getLeadAtom();
    }

    abstract boolean isConnectedAfter(Monomer var1);

    void findNearestAtomIndex(int x, int y, Atom[] closest, short madBegin, short madEnd) {
    }

    public Map<String, Object> getMyInfo(P3 ptTemp) {
        Structure structure;
        float f;
        char insCode;
        Map<String, Object> info = this.getGroupInfo(this.groupIndex, ptTemp);
        info.put("chain", this.chain.getIDStr());
        int seqNum = this.getResno();
        if (seqNum > 0) {
            info.put("sequenceNumber", seqNum);
        }
        if ((insCode = this.getInsertionCode()) != '\u0000') {
            info.put("insertionCode", "" + insCode);
        }
        if (!Float.isNaN(f = this.getGroupParameter(1111490569))) {
            info.put("phi", Float.valueOf(f));
        }
        if (!Float.isNaN(f = this.getGroupParameter(1111490570))) {
            info.put("psi", Float.valueOf(f));
        }
        if (!Float.isNaN(f = this.getGroupParameter(1111490565))) {
            info.put("mu", Float.valueOf(f));
        }
        if (!Float.isNaN(f = this.getGroupParameter(1111490576))) {
            info.put("theta", Float.valueOf(f));
        }
        if ((structure = this.getStructure()) instanceof ProteinStructure) {
            info.put("structureId", ((ProteinStructure)structure).strucNo);
            info.put("structureType", ((ProteinStructure)structure).type.getBioStructureTypeName(false));
        }
        info.put("shapeVisibilityFlags", this.shapeVisibilityFlags);
        return info;
    }

    @Override
    public String getStructureId() {
        Structure structure = this.getStructure();
        return structure instanceof ProteinStructure ? ((ProteinStructure)structure).type.getBioStructureTypeName(false) : "";
    }

    final boolean updateOffsetsForAlternativeLocations(Atom[] atoms, BS bsSelected) {
        boolean updated = false;
        int offsetIndex = this.offsets.length;
        block0: while (--offsetIndex >= 0) {
            int offset = this.offsets[offsetIndex] & 0xFF;
            if (offset == 255) continue;
            int iThis = this.firstAtomIndex + offset;
            Atom atom = atoms[iThis];
            byte thisID = atom.atomID;
            if (atom.altloc == '\u0000') continue;
            int nScan = this.lastAtomIndex - this.firstAtomIndex;
            for (int i = 1; i <= nScan; ++i) {
                byte atomID;
                int offsetNew;
                int iNew = iThis + i;
                if (iNew > this.lastAtomIndex) {
                    iNew -= nScan + 1;
                }
                if ((offsetNew = iNew - this.firstAtomIndex) < 0 || offsetNew > 255 || iNew == iThis || !bsSelected.get(iNew) || (atomID = atoms[iNew].atomID) != thisID || atomID == 0 && !atoms[iNew].getAtomName().equals(atom.getAtomName())) continue;
                this.offsets[offsetIndex] = (byte)offsetNew;
                atoms[iNew].nBackbonesDisplayed = atom.nBackbonesDisplayed;
                updated = true;
                continue block0;
            }
        }
        this.setLeadAtomIndex();
        return updated;
    }

    final void getMonomerSequenceAtoms(BS bsInclude, BS bsResult) {
        this.setAtomBits(bsResult);
        bsResult.and(bsInclude);
    }

    protected static final boolean checkOptional(byte[] offsets, byte atom, int firstAtomIndex, int index) {
        if (Monomer.have(offsets, atom)) {
            return true;
        }
        if (index < 0) {
            return false;
        }
        offsets[atom] = (byte)(index - firstAtomIndex);
        return true;
    }

    P3 getQuaternionFrameCenter(char qtype) {
        return null;
    }

    protected Object getHelixData2(int tokType, char qType, int mStep) {
        Quat q1;
        if (this.monomerIndex < 0) {
            return null;
        }
        int iPrev = this.monomerIndex - mStep;
        Monomer prev = mStep < 1 || this.monomerIndex <= 0 ? null : this.bioPolymer.monomers[iPrev];
        Quat q2 = this.getQuaternion(qType);
        Quat quat = mStep < 1 ? Quat.getQuaternionFrameV(JC.axisX, JC.axisY, JC.axisZ, false) : (q1 = prev == null ? null : prev.getQuaternion(qType));
        if (q1 == null || q2 == null) {
            return super.getHelixData(tokType, qType, mStep);
        }
        P3 a = mStep < 1 ? P3.new3(0.0f, 0.0f, 0.0f) : prev.getQuaternionFrameCenter(qType);
        P3 b = this.getQuaternionFrameCenter(qType);
        return a == null || b == null ? this.getHelixData(tokType, qType, mStep) : Escape.escapeHelical(tokType == 135176 ? "helixaxis" + this.getUniqueID() : null, tokType, a, b, Measure.computeHelicalAxis(a, b, q2.div(q1)));
    }

    public String getUniqueID() {
        char aid;
        int cid = this.chain.chainID;
        Atom a = this.getLeadAtom();
        String id = (a == null ? "" : "_" + a.mi) + "_" + this.getResno() + (cid == 0 ? "" : "_" + cid);
        char c = aid = a == null ? (char)'\u0000' : this.getLeadAtom().altloc;
        if (aid != '\u0000') {
            id = id + "_" + aid;
        }
        return id;
    }

    @Override
    public boolean isCrossLinked(Group g) {
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!this.getCrossLinkGroup(i, null, g, true, true, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getCrossLinkVector(Lst<Integer> vReturn, boolean crosslinkCovalent, boolean crosslinkHBond) {
        boolean isNotCheck = vReturn == null;
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!this.getCrossLinkGroup(i, vReturn, null, crosslinkCovalent, crosslinkHBond, isNotCheck) || !isNotCheck) continue;
            return true;
        }
        return !isNotCheck && vReturn.size() > 0;
    }

    protected boolean getCrossLinkGroup(int i, Lst<Integer> vReturn, Group group, boolean crosslinkCovalent, boolean crosslinkHBond, boolean isNotCheck) {
        Atom atom = this.chain.model.ms.at[i];
        Bond[] bonds = atom.bonds;
        int ibp = this.getBioPolymerIndexInModel();
        if (ibp < 0 || bonds == null) {
            return false;
        }
        boolean haveCrossLink = false;
        boolean checkPrevious = !isNotCheck && vReturn == null && group == null;
        for (int j = 0; j < bonds.length; ++j) {
            Bond b = bonds[j];
            if (b.isCovalent() ? !crosslinkCovalent : !crosslinkHBond) continue;
            Atom a = b.getOtherAtom(atom);
            Group g = a.group;
            if (group != null && g != group) continue;
            int iPolymer = g.getBioPolymerIndexInModel();
            int igroup = g.getMonomerIndex();
            if (checkPrevious) {
                if (iPolymer != ibp || igroup != this.monomerIndex - 1) continue;
                return true;
            }
            if (iPolymer < 0 || igroup < 0 || iPolymer == ibp && igroup >= this.monomerIndex - 1 && igroup <= this.monomerIndex + 1) continue;
            haveCrossLink = true;
            if (group != null || vReturn == null) break;
            vReturn.addLast(i);
            vReturn.addLast(a.i);
            vReturn.addLast(g.leadAtomIndex);
        }
        return haveCrossLink;
    }

    public boolean isConnectedPrevious() {
        return true;
    }

    void setGroupParameter(int tok, float f) {
        switch (tok) {
            case 1111490569: {
                this.phi = f;
                break;
            }
            case 1111490570: {
                this.psi = f;
                break;
            }
            case 1111490568: {
                this.omega = f;
                break;
            }
            case 1111490565: {
                this.mu = f;
                break;
            }
            case 1111490576: {
                this.theta = f;
                break;
            }
            case 1111490574: {
                this.straightness = f;
            }
        }
    }

    @Override
    public float getGroupParameter(int tok) {
        if (this.bioPolymer == null) {
            return 0.0f;
        }
        if (!this.bioPolymer.haveParameters) {
            this.bioPolymer.calcParameters();
        }
        switch (tok) {
            case 0x41400011: {
                return 1.0f;
            }
            case 1111490568: {
                return this.omega;
            }
            case 1111490569: {
                return this.phi;
            }
            case 1111490570: {
                return this.psi;
            }
            case 1111490565: {
                return this.mu;
            }
            case 1111490576: {
                return this.theta;
            }
            case 1111490574: {
                return this.straightness;
            }
        }
        return Float.NaN;
    }

    @Override
    public char getGroup1() {
        int n;
        if (this.groupID < BioResolver.predefinedGroup1Names.length) {
            n = BioResolver.predefinedGroup1Names[this.groupID];
        } else if (this.group1 > '\u0001') {
            n = this.group1;
        } else if (this.group1 == '\u0001') {
            n = 63;
        } else {
            char c = this.getGroup1b();
            n = c;
            this.group1 = c;
        }
        return (char)n;
    }

    protected char getGroup1b() {
        return '?';
    }

    @Override
    public void setGroupID(String group3) {
        this.groupID = BioResolver.getGroupIdFor(group3);
    }

    @Override
    public String toString() {
        return "[" + this.getGroup3() + "-" + this.getSeqcodeString() + " " + this.getStructure() + "]";
    }
}

