/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.lang.annotation.Annotation;
import java.util.Collection;
import jnr.ffi.annotations.Direct;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.NulTerminate;
import jnr.ffi.annotations.Out;
import jnr.ffi.annotations.Pinned;
import jnr.ffi.annotations.Transient;

public final class ParameterFlags {
    public static final int OUT = 1;
    public static final int IN = 2;
    public static final int PINNED = 4;
    public static final int NULTERMINATE = 8;
    public static final int TRANSIENT = 16;
    public static final int DIRECT = 32;

    private ParameterFlags() {
    }

    public static int parse(Annotation annotation) {
        int flags2 = 0;
        flags2 |= annotation instanceof Out ? 1 : 0;
        flags2 |= annotation instanceof In ? 2 : 0;
        flags2 |= annotation instanceof Transient ? 16 : 0;
        flags2 |= annotation instanceof Direct ? 32 : 0;
        flags2 |= annotation instanceof Pinned ? 4 : 0;
        return flags2 |= annotation instanceof NulTerminate ? 8 : 0;
    }

    public static int parse(Annotation[] annotations) {
        int flags2 = 0;
        for (Annotation a : annotations) {
            flags2 |= ParameterFlags.parse(a);
        }
        return flags2;
    }

    public static int parse(Collection<Annotation> annotations) {
        int flags2 = 0;
        for (Annotation a : annotations) {
            flags2 |= ParameterFlags.parse(a);
        }
        return flags2;
    }

    public static boolean isFlag(Annotation annotation) {
        return ParameterFlags.parse(annotation) != 0;
    }

    public static boolean isPinned(int flags2) {
        return (flags2 & 4) != 0;
    }

    public static boolean isTransient(int flags2) {
        return (flags2 & 0x10) != 0;
    }

    public static boolean isDirect(int flags2) {
        return (flags2 & 0x20) != 0;
    }

    public static boolean isNulTerminate(int flags2) {
        return (flags2 & 8) != 0;
    }

    public static boolean isOut(int flags2) {
        return (flags2 & 3) != 2;
    }

    public static boolean isIn(int flags2) {
        return (flags2 & 3) != 1;
    }
}

