/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.dirgra;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.ExplicitVertexID;

public class EdgeTypeIterator<T extends ExplicitVertexID, U>
implements Iterator<Edge<T, U>> {
    private Edge<T, U>[] edges;
    private int edgesLength;
    private int edgeIteratorIndex = 0;
    private Object type;
    private Edge nextEdge = null;
    private boolean negate;

    public EdgeTypeIterator(Edge<T, U>[] edges, int edgesLength, Object type2, boolean negate2) {
        this.edges = edges;
        this.edgesLength = edgesLength;
        this.type = type2;
        this.negate = negate2;
    }

    @Override
    public boolean hasNext() {
        if (this.nextEdge != null) {
            return true;
        }
        for (int i2 = this.edgeIteratorIndex; i2 < this.edgesLength; ++i2) {
            Edge<T, U> edge = this.edges[i2];
            U edgeType = edge.getType();
            if (this.negate) {
                if ((edgeType == null || edgeType.equals(this.type)) && (edgeType != null || edgeType == this.type)) continue;
                this.nextEdge = edge;
                this.edgeIteratorIndex = i2 + 1;
                return true;
            }
            if ((edgeType == null || !edgeType.equals(this.type)) && (edgeType != null || edgeType != this.type)) continue;
            this.nextEdge = edge;
            this.edgeIteratorIndex = i2 + 1;
            return true;
        }
        this.edgeIteratorIndex = this.edgesLength;
        return false;
    }

    @Override
    public Edge<T, U> next() {
        if (this.hasNext()) {
            Edge tmp = this.nextEdge;
            this.nextEdge = null;
            return tmp;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

