/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.DepthCloneable;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class LocalVariable
extends Variable
implements DepthCloneable {
    protected final RubySymbol name;
    protected final int scopeDepth;
    protected final int offset;
    protected final int hcode;
    protected final boolean isOuterScopeVar;

    public LocalVariable(RubySymbol name2, int scopeDepth, int location) {
        this.name = name2;
        this.scopeDepth = scopeDepth;
        this.isOuterScopeVar = scopeDepth > 0;
        this.offset = location;
        this.hcode = (String.valueOf(name2) + ":" + this.offset).hashCode();
    }

    public LocalVariable(RubySymbol name2, int scopeDepth, int location, boolean isOuterScopeVar) {
        this.name = name2;
        this.scopeDepth = scopeDepth;
        this.isOuterScopeVar = isOuterScopeVar;
        this.offset = location;
        this.hcode = (String.valueOf(name2) + ":" + this.offset).hashCode();
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.LOCAL_VARIABLE;
    }

    public boolean isSameDepth(LocalVariable other) {
        return this.getScopeDepth() == other.getScopeDepth();
    }

    public int getScopeDepth() {
        return this.scopeDepth;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLocation() {
        return this.offset;
    }

    @Override
    public String getId() {
        return this.name.idString();
    }

    public RubySymbol getName() {
        return this.name;
    }

    public String toString() {
        return this.isSelf() ? this.name.toString() : String.valueOf(this.name) + "(" + this.scopeDepth + ":" + this.offset + (this.isOuterScopeVar ? ":outer=true" : "") + ")";
    }

    public int hashCode() {
        return this.hcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalVariable) {
            return this.hcode == ((LocalVariable)obj).hcode;
        }
        return false;
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        IRubyObject value2 = currDynScope.getValue(this.offset, this.scopeDepth);
        if (value2 == null) {
            value2 = context.nil;
        }
        return value2;
    }

    @Override
    public Variable clone(SimpleCloneInfo ii) {
        return this;
    }

    @Override
    public LocalVariable cloneForDepth(int n) {
        return n > this.scopeDepth ? new LocalVariable(this.name, n, this.offset) : new LocalVariable(this.name, n, this.offset, this.isOuterScopeVar);
    }

    public boolean isOuterScopeVar() {
        return this.isOuterScopeVar;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getName());
        e.encode(e.getCurrentScope().correctVariableDepthForForLoopsForEncoding(this.getScopeDepth()));
    }

    public static LocalVariable decode(IRReaderDecoder d) {
        return d.getCurrentScope().getLocalVariable(d.decodeSymbol(), d.decodeInt());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.LocalVariable(this);
    }
}

