/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.util;

import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.representations.IGVCFGVisitor;
import org.jruby.ir.util.IGVHelper;

public class IGVDumper {
    static final String HOST = "localhost";
    static final int PORT = 4444;
    Socket socket;
    PrintStream writer;
    final String baseLabel;

    public IGVDumper(String baseLabel, boolean saveToFile) {
        this.baseLabel = IGVDumper.sanitize(baseLabel);
        try {
            if (saveToFile) {
                this.writer = System.out;
            } else {
                this.socket = new Socket(HOST, 4444);
                this.writer = new PrintStream(this.socket.getOutputStream());
            }
            IGVHelper.startTag(this.writer, "graphDocument");
            IGVHelper.startTag(this.writer, "group");
            IGVHelper.startTag(this.writer, "properties");
            IGVHelper.property(this.writer, "name", baseLabel);
            IGVHelper.endTag(this.writer, "properties");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String sanitize(String string2) {
        return string2.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;");
    }

    public void dump(CFG cfg, String name2) {
        new IGVCFGVisitor(cfg, this.writer, name2);
    }

    public void close() {
        IGVHelper.endTag(this.writer, "group");
        IGVHelper.endTag(this.writer, "graphDocument");
        try {
            if (this.socket != null) {
                this.writer.close();
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

