/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaProxyMethods;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.ByteList;
import org.jruby.util.JRubyObjectInputStream;

@Deprecated
public class JavaObject
extends RubyObject {
    private static final Object NULL_LOCK = new Object();
    private final VariableAccessor objectAccessor;
    private static final ObjectAllocator JAVA_OBJECT_ALLOCATOR = JavaObject::new;

    protected JavaObject(Ruby runtime2, RubyClass rubyClass, Object value2) {
        super(runtime2, rubyClass);
        this.objectAccessor = rubyClass.getVariableAccessorForWrite("__wrap_struct__");
        this.dataWrapStruct(value2);
    }

    private JavaObject(Ruby runtime2, RubyClass klazz) {
        this(runtime2, klazz, null);
    }

    @Override
    public final Object dataGetStruct() {
        return this.objectAccessor.get(this);
    }

    @Override
    public final void dataWrapStruct(Object object) {
        this.objectAccessor.set(this, object);
    }

    @Deprecated(since="9.4-")
    public static JavaObject wrap(Ruby runtime2, Object value2) {
        if (value2 != null) {
            if (value2 instanceof Class) {
                Class clazz = (Class)value2;
                return JavaClass.get(runtime2, clazz);
            }
            if (value2.getClass().isArray()) {
                return new JavaArray(runtime2, value2);
            }
        }
        ThreadContext context = runtime2.getCurrentContext();
        return new JavaObject(runtime2, runtime2.getJavaSupport().getJavaModule(context).getClass(context, "JavaObject"), value2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject wrap(ThreadContext context, IRubyObject self2, IRubyObject object) {
        IRubyObject objectValue = JavaUtil.unwrapJava(object, NEVER);
        return objectValue == NEVER ? context.nil : JavaObject.wrap(context.runtime, objectValue);
    }

    @Override
    public final Class<?> getJavaClass() {
        Object dataStruct = this.dataGetStruct();
        return dataStruct != null ? dataStruct.getClass() : Void.TYPE;
    }

    public final Object getValue() {
        return this.dataGetStruct();
    }

    public static RubyClass createJavaObjectClass(Ruby runtime2, RubyClass Object2, RubyModule javaModule) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyClass JavaObject2 = javaModule.defineClassUnder(context, "JavaObject", Object2, JAVA_OBJECT_ALLOCATOR).tap(c -> c.getMetaClass().undefMethods(context, "new", "allocate"));
        JavaObject2.defineMethods(context, JavaObject.class);
        return JavaObject2;
    }

    @Override
    public boolean equals(Object other) {
        Object otherValue = other instanceof IRubyObject ? JavaUtil.unwrapJava((IRubyObject)other, NEVER) : other;
        if (otherValue == NEVER) {
            return false;
        }
        return this.getValue() == otherValue;
    }

    @Override
    public int hashCode() {
        Object value2 = this.dataGetStruct();
        return value2 == null ? 0 : value2.hashCode();
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.hashCode());
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        return JavaProxyMethods.to_s(context, this.dataGetStruct());
    }

    @Deprecated(since="10.0")
    public static IRubyObject to_s(Ruby runtime2, Object dataStruct) {
        return JavaProxyMethods.to_s(runtime2.getCurrentContext(), dataStruct);
    }

    @Deprecated(since="10.0")
    public IRubyObject op_equal(IRubyObject other) {
        return this.op_equal(this.getCurrentContext(), other);
    }

    @Override
    @JRubyMethod(name={"==", "eql?"})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return JavaProxyMethods.equals(context.runtime, this.getValue(), other);
    }

    @Deprecated(since="10.0")
    public static RubyBoolean op_equal(JavaProxy self2, IRubyObject other) {
        return JavaProxyMethods.equals(self2.getCurrentContext().runtime, self2.getObject(), other);
    }

    @JRubyMethod(name={"equal?"})
    public IRubyObject same(ThreadContext context, IRubyObject other) {
        Object thisValue = this.getValue();
        IRubyObject otherValue = JavaUtil.unwrapJava(other, NEVER);
        if (otherValue == NEVER) {
            return context.fals;
        }
        if (!(other instanceof JavaObject)) {
            return context.fals;
        }
        return Convert.asBoolean(context, thisValue == otherValue);
    }

    @Deprecated
    public IRubyObject same(IRubyObject other) {
        return this.same(this.getCurrentContext(), other);
    }

    @Deprecated(since="10.0")
    public RubyString java_type() {
        return this.java_type(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyString java_type(ThreadContext context) {
        return Create.newString(context, this.getJavaClass().getName());
    }

    @Deprecated(since="9.4-")
    public JavaClass java_class() {
        return JavaClass.get(this.getCurrentContext().runtime, this.getJavaClass());
    }

    @Deprecated(since="10.0")
    public IRubyObject get_java_class() {
        return this.get_java_class(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject get_java_class(ThreadContext context) {
        return Java.getInstance(context.runtime, this.getJavaClass());
    }

    @Deprecated(since="10.0")
    public RubyFixnum length() {
        return this.length(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyFixnum length(ThreadContext context) {
        throw Error.typeError(context, "not a java array");
    }

    @Deprecated(since="10.0")
    public IRubyObject is_java_proxy() {
        return this.is_java_proxy(this.getCurrentContext());
    }

    @JRubyMethod(name={"java_proxy?"})
    public IRubyObject is_java_proxy(ThreadContext context) {
        return context.tru;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"synchronized"})
    public final IRubyObject ruby_synchronized(ThreadContext context, Block block) {
        Object lock2 = this.getValue();
        Object object = lock2 != null ? lock2 : NULL_LOCK;
        synchronized (object) {
            return block.yield(context, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject ruby_synchronized(ThreadContext context, Object lock2, Block block) {
        Object object = lock2 != null ? lock2 : NULL_LOCK;
        synchronized (object) {
            return block.yield(context, null);
        }
    }

    @JRubyMethod
    public IRubyObject marshal_dump(ThreadContext context) {
        if (Serializable.class.isAssignableFrom(this.getJavaClass())) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new ObjectOutputStream(baos).writeObject(this.getValue());
                return context.runtime.newString(new ByteList(baos.toByteArray(), false));
            }
            catch (IOException ex) {
                throw context.runtime.newIOErrorFromException(ex);
            }
        }
        throw Error.typeError(context, "no marshal_dump is defined for class " + String.valueOf(this.getJavaClass()));
    }

    @JRubyMethod
    public IRubyObject marshal_load(ThreadContext context, IRubyObject str) {
        try {
            ByteList byteList = str.convertToString().getByteList();
            ByteArrayInputStream bais = new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
            this.dataWrapStruct(new JRubyObjectInputStream(context.runtime, bais).readObject());
            return this;
        }
        catch (IOException ex) {
            throw context.runtime.newIOErrorFromException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw Error.typeError(context, "Class not found unmarshaling Java type: " + ex.getLocalizedMessage());
        }
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        Object value2 = this.getValue();
        if (value2 == null) {
            return null;
        }
        if (target2.isAssignableFrom(value2.getClass())) {
            return target2.cast(value2);
        }
        return super.toJava(target2);
    }
}

