/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.invokers.RubyToJavaInvoker;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

@JRubyClass(name={"Java::JavaProxyConstructor"})
public class JavaProxyConstructor
extends JavaProxyReflectionObject
implements ParameterTypes {
    private final Constructor<?> proxyConstructor;
    private final Class<?>[] actualParameterTypes;
    private final boolean actualVarArgs;
    private final boolean exportable;
    private final JavaProxyClass declaringProxyClass;

    public static RubyClass createJavaProxyConstructorClass(ThreadContext context, RubyClass Object2, RubyModule Java2) {
        RubyClass JavaProxyConstructor2 = (RubyClass)((RubyModule)Java2.defineClassUnder(context, "JavaProxyConstructor", Object2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, JavaProxyConstructor.class);
        JavaProxyReflectionObject.registerRubyMethods(context, JavaProxyConstructor2);
        return JavaProxyConstructor2;
    }

    JavaProxyConstructor(Ruby runtime2, JavaProxyClass proxyClass, Constructor<?> constructor2) {
        super(runtime2, runtime2.getJavaSupport().getJavaProxyConstructorClass());
        this.declaringProxyClass = proxyClass;
        this.proxyConstructor = constructor2;
        Class[] parameterTypes = constructor2.getParameterTypes();
        this.exportable = parameterTypes.length == 0 || parameterTypes[parameterTypes.length - 1] != RubyClass.class;
        this.actualParameterTypes = ArraySupport.newCopy(parameterTypes, parameterTypes.length - (this.exportable ? 0 : 2));
        this.actualVarArgs = this.proxyConstructor.isVarArgs();
    }

    @Override
    public final Class<?>[] getParameterTypes() {
        return this.actualParameterTypes;
    }

    @Override
    public final Class<?>[] getExceptionTypes() {
        return this.proxyConstructor.getExceptionTypes();
    }

    public final boolean isExportable() {
        return this.exportable;
    }

    @Override
    public final boolean isVarArgs() {
        return this.actualVarArgs;
    }

    @JRubyMethod(name={"declaring_class"})
    public JavaProxyClass getDeclaringClass() {
        return this.declaringProxyClass;
    }

    public final Object newInstance(Object[] args2, Ruby runtime2, IRubyObject clazz) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int len = args2.length;
        if (len != this.actualParameterTypes.length) {
            throw new IllegalArgumentException("wrong number of parameters");
        }
        if (this.exportable) {
            return this.newInstanceImpl(args2, null, null);
        }
        return this.newInstanceImpl(ArraySupport.newCopy(args2, len + 2), runtime2, clazz);
    }

    final Object newInstanceImpl(Object[] argsPlus1, Ruby runtime2, IRubyObject clazz) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (!this.exportable) {
            argsPlus1[argsPlus1.length - 2] = runtime2;
            argsPlus1[argsPlus1.length - 1] = clazz;
        }
        return this.proxyConstructor.newInstance(argsPlus1);
    }

    @Deprecated(since="10.0")
    public RubyFixnum arity() {
        return this.arity(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyFixnum arity(ThreadContext context) {
        return Convert.asFixnum(context, this.getArity());
    }

    @Override
    public final int getArity() {
        return this.getParameterTypes().length;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaProxyConstructor && this.proxyConstructor == ((JavaProxyConstructor)other).proxyConstructor;
    }

    @Override
    public int hashCode() {
        return this.proxyConstructor.hashCode();
    }

    @Override
    @Deprecated(since="10.0")
    public RubyString inspect() {
        return this.inspect(this.getCurrentContext());
    }

    @Override
    @JRubyMethod
    public RubyString inspect(ThreadContext context) {
        return Create.newString(context, this.toString());
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("#<");
        buf.append(this.getDeclaringClass().nameOnInspection());
        JavaCallable.inspectParameterTypes(buf, this);
        buf.append('>');
        return buf.toString();
    }

    @Deprecated(since="10.0")
    public final RubyArray argument_types() {
        return this.argument_types(this.getCurrentContext());
    }

    @JRubyMethod
    public final RubyArray argument_types(ThreadContext context) {
        return JavaProxyConstructor.toClassArray(context, this.getParameterTypes());
    }

    @JRubyMethod(rest=true)
    public IRubyObject new_instance2(ThreadContext context, IRubyObject[] args2, Block unusedBlock) {
        Ruby runtime2 = context.runtime;
        Arity.checkArgumentCount(context, args2, 2, 2);
        IRubyObject self2 = args2[0];
        Object[] convertedArgs = this.convertArguments((RubyArray)args2[1]);
        try {
            return JavaProxyConstructor.wrapJavaObject(runtime2, this.newInstance(convertedArgs, runtime2, self2));
        }
        catch (Exception ex) {
            throw JavaProxyConstructor.mapInstantiationException(runtime2, ex);
        }
    }

    public final IRubyObject newInstance(Ruby runtime2, IRubyObject self2, Object[] args2) throws RaiseException {
        try {
            return JavaProxyConstructor.wrapJavaObject(runtime2, this.newInstance(args2, runtime2, self2));
        }
        catch (Exception ex) {
            throw JavaProxyConstructor.mapInstantiationException(runtime2, ex);
        }
    }

    public final IRubyObject newInstance(Ruby runtime2, IRubyObject self2, IRubyObject[] args2) throws RaiseException {
        Object[] javaArgsPlus1 = RubyToJavaInvoker.convertArguments((ParameterTypes)this, args2, this.exportable ? 0 : 2);
        try {
            return JavaProxyConstructor.wrapJavaObject(runtime2, this.newInstanceImpl(javaArgsPlus1, runtime2, self2));
        }
        catch (Exception ex) {
            throw JavaProxyConstructor.mapInstantiationException(runtime2, ex);
        }
    }

    public final IRubyObject newInstance(Ruby runtime2, IRubyObject self2, IRubyObject arg0) throws RaiseException {
        Object[] javaArgsPlus1 = RubyToJavaInvoker.convertArguments((ParameterTypes)this, arg0, this.exportable ? 0 : 2);
        try {
            return JavaProxyConstructor.wrapJavaObject(runtime2, this.newInstanceImpl(javaArgsPlus1, runtime2, self2));
        }
        catch (Exception ex) {
            throw JavaProxyConstructor.mapInstantiationException(runtime2, ex);
        }
    }

    private static IRubyObject wrapJavaObject(Ruby runtime2, Object obj) {
        return Java.getInstance(runtime2, obj);
    }

    public static RaiseException mapInstantiationException(Ruby runtime2, Throwable e) {
        Throwable cause2 = e;
        while (cause2.getCause() != null) {
            cause2 = cause2.getCause();
        }
        String msg = cause2.getLocalizedMessage();
        ArgumentError ex = Error.argumentError(runtime2.getCurrentContext(), "Constructor invocation failed: " + (msg == null ? e.getClass().getName() : msg));
        ((Throwable)ex).initCause(e);
        ex.addSuppressed(e);
        throw ex;
    }

    public static RuntimeException throwInstantiationExceptionCause(Ruby runtime2, ReflectiveOperationException e) {
        Throwable cause2 = e;
        if (cause2.getCause() != null) {
            cause2 = cause2.getCause();
        }
        Helpers.throwException(cause2);
        return new RuntimeException("Dead code... If you see this, file a bug: JPCtIEC fail");
    }

    @Deprecated
    public IRubyObject new_instance(IRubyObject[] args2, Block block) {
        return this.new_instance2(this.getCurrentContext(), args2, block);
    }

    @JRubyMethod(required=1, optional=1, checkArity=false)
    public IRubyObject new_instance(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.runtime;
        int last2 = Arity.checkArgumentCount(context, args2, 1, 2) - 1;
        RubyProc proc2 = args2[last2] instanceof RubyProc ? (RubyProc)args2[last2] : runtime2.newProc(Block.Type.PROC, block);
        Object[] convertedArgs = this.convertArguments((RubyArray)args2[0]);
        try {
            return JavaProxyConstructor.wrapJavaObject(runtime2, this.newInstance(convertedArgs, runtime2, (IRubyObject)proc2));
        }
        catch (Exception e) {
            throw JavaProxyConstructor.mapInstantiationException(runtime2, e);
        }
    }

    private Object[] convertArguments(RubyArray arguments) {
        int argsSize = arguments.size();
        Object[] args2 = new Object[argsSize];
        Class<?>[] parameterTypes = this.getParameterTypes();
        for (int i2 = 0; i2 < argsSize; ++i2) {
            args2[i2] = arguments.eltInternal(i2).toJava(parameterTypes[i2]);
        }
        return args2;
    }
}

