/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigInteger;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.StrptimeParser;
import org.jruby.util.StrptimeToken;
import org.jruby.util.TimeZoneConverter;

public class RubyDateParser {
    public IRubyObject parse(ThreadContext context, RubyString format, RubyString text) {
        return this.parse(context, format.asJavaString(), text);
    }

    public IRubyObject parse(ThreadContext context, String format, RubyString text) {
        List<StrptimeToken> compiledPattern = context.runtime.getCachedStrptimePattern(format);
        StrptimeParser.FormatBag bag = new StrptimeParser().parse(compiledPattern, text.asJavaString());
        return bag == null ? context.nil : RubyDateParser.convertFormatBagToHash(context, bag, text.getEncoding());
    }

    static RubyHash convertFormatBagToHash(ThreadContext context, StrptimeParser.FormatBag bag, Encoding encoding2) {
        RubyHash hash2 = Create.newHash(context);
        if (StrptimeParser.FormatBag.has(bag.getMDay())) {
            RubyDateParser.setHashValue(context, hash2, "mday", Convert.asFixnum(context, bag.getMDay()));
        }
        if (StrptimeParser.FormatBag.has(bag.getWDay())) {
            RubyDateParser.setHashValue(context, hash2, "wday", Convert.asFixnum(context, bag.getWDay()));
        }
        if (StrptimeParser.FormatBag.has(bag.getCWDay())) {
            RubyDateParser.setHashValue(context, hash2, "cwday", Convert.asFixnum(context, bag.getCWDay()));
        }
        if (StrptimeParser.FormatBag.has(bag.getYDay())) {
            RubyDateParser.setHashValue(context, hash2, "yday", Convert.asFixnum(context, bag.getYDay()));
        }
        if (StrptimeParser.FormatBag.has(bag.getCWeek())) {
            RubyDateParser.setHashValue(context, hash2, "cweek", Convert.asFixnum(context, bag.getCWeek()));
        }
        if (StrptimeParser.FormatBag.has(bag.getCWYear())) {
            RubyDateParser.setHashValue(context, hash2, "cwyear", RubyBignum.newBignum(context.runtime, bag.getCWYear()));
        }
        if (StrptimeParser.FormatBag.has(bag.getMin())) {
            RubyDateParser.setHashValue(context, hash2, "min", Convert.asFixnum(context, bag.getMin()));
        }
        if (StrptimeParser.FormatBag.has(bag.getMon())) {
            RubyDateParser.setHashValue(context, hash2, "mon", Convert.asFixnum(context, bag.getMon()));
        }
        if (StrptimeParser.FormatBag.has(bag.getHour())) {
            RubyDateParser.setHashValue(context, hash2, "hour", Convert.asFixnum(context, bag.getHour()));
        }
        if (StrptimeParser.FormatBag.has(bag.getYear())) {
            RubyDateParser.setHashValue(context, hash2, "year", RubyBignum.newBignum(context.runtime, bag.getYear()));
        }
        if (StrptimeParser.FormatBag.has(bag.getSec())) {
            RubyDateParser.setHashValue(context, hash2, "sec", Convert.asFixnum(context, bag.getSec()));
        }
        if (StrptimeParser.FormatBag.has(bag.getWNum0())) {
            RubyDateParser.setHashValue(context, hash2, "wnum0", Convert.asFixnum(context, bag.getWNum0()));
        }
        if (StrptimeParser.FormatBag.has(bag.getWNum1())) {
            RubyDateParser.setHashValue(context, hash2, "wnum1", Convert.asFixnum(context, bag.getWNum1()));
        }
        if (bag.getZone() != null) {
            RubyString zone2 = RubyString.newString(context.runtime, bag.getZone(), encoding2);
            RubyDateParser.setHashValue(context, hash2, "zone", zone2);
            int offset2 = TimeZoneConverter.dateZoneToDiff(bag.getZone());
            if (offset2 != Integer.MIN_VALUE) {
                RubyDateParser.setHashValue(context, hash2, "offset", Convert.asFixnum(context, offset2));
            }
        }
        if (StrptimeParser.FormatBag.has(bag.getSecFraction())) {
            RubyInteger secFraction = RubyDateParser.toRubyInteger(context, bag.getSecFraction());
            RubyFixnum secFractionSize = Convert.asFixnum(context, (long)Math.pow(10.0, bag.getSecFractionSize()));
            RubyDateParser.setHashValue(context, hash2, "sec_fraction", RubyRational.newRationalCanonicalize(context, secFraction, secFractionSize));
        }
        if (StrptimeParser.FormatBag.has(bag.getSeconds())) {
            if (StrptimeParser.FormatBag.has(bag.getSecondsSize())) {
                RubyInteger seconds = RubyDateParser.toRubyInteger(context, bag.getSeconds());
                RubyFixnum secondsSize = Convert.asFixnum(context, (long)Math.pow(10.0, bag.getSecondsSize()));
                RubyDateParser.setHashValue(context, hash2, "seconds", RubyRational.newRationalCanonicalize(context, seconds, secondsSize));
            } else {
                RubyDateParser.setHashValue(context, hash2, "seconds", RubyDateParser.toRubyInteger(context, bag.getSeconds()));
            }
        }
        if (StrptimeParser.FormatBag.has(bag.getMerid())) {
            RubyDateParser.setHashValue(context, hash2, "_merid", Convert.asFixnum(context, bag.getMerid()));
        }
        if (StrptimeParser.FormatBag.has(bag.getCent())) {
            RubyDateParser.setHashValue(context, hash2, "_cent", RubyBignum.newBignum(context.runtime, bag.getCent()));
        }
        if (bag.getLeftover() != null) {
            RubyString leftover = Create.newString(context, bag.getLeftover(), encoding2);
            RubyDateParser.setHashValue(context, hash2, "leftover", leftover);
        }
        return hash2;
    }

    private static RubyInteger toRubyInteger(ThreadContext context, Number i2) {
        RubyInteger rubyInteger;
        if (i2 instanceof BigInteger) {
            BigInteger bigint = (BigInteger)i2;
            rubyInteger = RubyBignum.newBignum(context.runtime, bigint);
        } else {
            rubyInteger = Convert.asFixnum(context, i2.longValue());
        }
        return rubyInteger;
    }

    private static void setHashValue(ThreadContext context, RubyHash hash2, String key2, IRubyObject value2) {
        hash2.fastASet(Convert.asSymbol(context, key2), value2);
    }
}

