
#ifndef KCALENDARCORE_EXPORT_H
#define KCALENDARCORE_EXPORT_H

#ifdef KCALENDARCORE_STATIC_DEFINE
#  define KCALENDARCORE_EXPORT
#  define KCALENDARCORE_NO_EXPORT
#else
#  ifndef KCALENDARCORE_EXPORT
#    ifdef KF5CalendarCore_EXPORTS
        /* We are building this library */
#      define KCALENDARCORE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KCALENDARCORE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KCALENDARCORE_NO_EXPORT
#    define KCALENDARCORE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KCALENDARCORE_DECL_DEPRECATED
#  define KCALENDARCORE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KCALENDARCORE_DECL_DEPRECATED_EXPORT
#  define KCALENDARCORE_DECL_DEPRECATED_EXPORT KCALENDARCORE_EXPORT KCALENDARCORE_DECL_DEPRECATED
#endif

#ifndef KCALENDARCORE_DECL_DEPRECATED_NO_EXPORT
#  define KCALENDARCORE_DECL_DEPRECATED_NO_EXPORT KCALENDARCORE_NO_EXPORT KCALENDARCORE_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KCALENDARCORE_NO_DEPRECATED
#    define KCALENDARCORE_NO_DEPRECATED
#  endif
#endif

#define KCALENDARCORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KCALENDARCORE_NO_DEPRECATED) && !defined(KCALENDARCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KCALENDARCORE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KCALENDARCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KCALENDARCORE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KCALENDARCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KCALENDARCORE_NO_DEPRECATED_WARNINGS) && !defined(KCALENDARCORE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KCALENDARCORE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KCALENDARCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KCALENDARCORE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KCALENDARCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KCALENDARCORE_NO_DEPRECATED)
#  undef KCALENDARCORE_DEPRECATED
#  define KCALENDARCORE_DEPRECATED_EXPORT KCALENDARCORE_EXPORT
#  define KCALENDARCORE_DEPRECATED_NO_EXPORT KCALENDARCORE_NO_EXPORT
#elif defined(KCALENDARCORE_NO_DEPRECATED_WARNINGS)
#  define KCALENDARCORE_DEPRECATED
#  define KCALENDARCORE_DEPRECATED_EXPORT KCALENDARCORE_EXPORT
#  define KCALENDARCORE_DEPRECATED_NO_EXPORT KCALENDARCORE_NO_EXPORT
#else
#  define KCALENDARCORE_DEPRECATED KCALENDARCORE_DECL_DEPRECATED
#  define KCALENDARCORE_DEPRECATED_EXPORT KCALENDARCORE_DECL_DEPRECATED_EXPORT
#  define KCALENDARCORE_DEPRECATED_NO_EXPORT KCALENDARCORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KCALENDARCORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KCALENDARCORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KCALENDARCORE_NO_DEPRECATED
#  define KCALENDARCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x57300
#endif
#ifdef KCALENDARCORE_NO_DEPRECATED_WARNINGS
#  define KCALENDARCORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KCALENDARCORE_DEPRECATED_WARNINGS_SINCE
#  ifdef KCALENDARCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KCALENDARCORE_DEPRECATED_WARNINGS_SINCE KCALENDARCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KCALENDARCORE_DEPRECATED_WARNINGS_SINCE 0x57300
#  endif
#endif

#ifndef KCALENDARCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KCALENDARCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KCALENDARCORE_DEPRECATED
#  define KCALENDARCORE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KCALENDARCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KCALENDARCORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KCALENDARCORE_DEPRECATED_WARNINGS_SINCE >= 0x54000
#  define KCALENDARCORE_DEPRECATED_VERSION_5_64(text) KCALENDARCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KCALENDARCORE_DEPRECATED_VERSION_5_64(text)
#endif

#if KCALENDARCORE_DEPRECATED_WARNINGS_SINCE >= 0x55900
#  define KCALENDARCORE_DEPRECATED_VERSION_5_89(text) KCALENDARCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KCALENDARCORE_DEPRECATED_VERSION_5_89(text)
#endif

#if KCALENDARCORE_DEPRECATED_WARNINGS_SINCE >= 0x55b00
#  define KCALENDARCORE_DEPRECATED_VERSION_5_91(text) KCALENDARCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KCALENDARCORE_DEPRECATED_VERSION_5_91(text)
#endif

#if KCALENDARCORE_DEPRECATED_WARNINGS_SINCE >= 0x55f00
#  define KCALENDARCORE_DEPRECATED_VERSION_5_95(text) KCALENDARCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KCALENDARCORE_DEPRECATED_VERSION_5_95(text)
#endif

#if KCALENDARCORE_DEPRECATED_WARNINGS_SINCE >= 0x56000
#  define KCALENDARCORE_DEPRECATED_VERSION_5_96(text) KCALENDARCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KCALENDARCORE_DEPRECATED_VERSION_5_96(text)
#endif

#if KCALENDARCORE_DEPRECATED_WARNINGS_SINCE >= 0x56100
#  define KCALENDARCORE_DEPRECATED_VERSION_5_97(text) KCALENDARCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KCALENDARCORE_DEPRECATED_VERSION_5_97(text)
#endif

#if KCALENDARCORE_DEPRECATED_WARNINGS_SINCE >= 0x56a00
#  define KCALENDARCORE_DEPRECATED_VERSION_5_106(text) KCALENDARCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KCALENDARCORE_DEPRECATED_VERSION_5_106(text)
#endif
#define KCALENDARCORE_DEPRECATED_VERSION_5(minor, text)      KCALENDARCORE_DEPRECATED_VERSION_5_##minor(text)
#define KCALENDARCORE_DEPRECATED_VERSION(major, minor, text) KCALENDARCORE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KCALENDARCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCALENDARCORE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KCALENDARCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KCALENDARCORE_DEPRECATED_VERSION(major, minor, text)
#  define KCALENDARCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCALENDARCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KCALENDARCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KCALENDARCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KCALENDARCORE_EXPORT_H */
