/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J0\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\u0010J(\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u001a\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u0007H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/util/LibraryUtils;", "", "()V", "findClassesFromJdkHome", "", "", "jdkHome", "Ljava/nio/file/Path;", "getAllPsiFilesFromJar", "Lcom/intellij/psi/PsiFile;", "jar", "project", "Lcom/intellij/openapi/project/Project;", "jarFileSystem", "Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;", "includeRoot", "", "getAllVirtualFilesFromDirectory", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "dir", "getAllVirtualFilesFromJar", "getAllVirtualFilesFromRoot", "root", "isExplodedModularRuntime", "homePath", "isModularRuntime", "readModulesFromReleaseFile", "jrtBaseDir", "analysis-api-impl-base"})
@SourceDebugExtension(value={"SMAP\nLibraryUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryUtils.kt\norg/jetbrains/kotlin/analysis/api/impl/base/util/LibraryUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1#2:136\n1#2:147\n1603#3,9:137\n1855#3:146\n1856#3:148\n1612#3:149\n*S KotlinDebug\n*F\n+ 1 LibraryUtils.kt\norg/jetbrains/kotlin/analysis/api/impl/base/util/LibraryUtils\n*L\n50#1:147\n50#1:137,9\n50#1:146\n50#1:148\n50#1:149\n*E\n"})
public final class LibraryUtils {
    @NotNull
    public static final LibraryUtils INSTANCE = new LibraryUtils();

    private LibraryUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Collection<VirtualFile> getAllVirtualFilesFromJar(@NotNull Path jar, @NotNull CoreJarFileSystem jarFileSystem, boolean includeRoot) {
        Collection<VirtualFile> collection;
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter((Object)jarFileSystem, (String)"jarFileSystem");
        VirtualFile virtualFile2 = jarFileSystem.refreshAndFindFileByPath(jar + "!/");
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            Collection<VirtualFile> collection2 = INSTANCE.getAllVirtualFilesFromRoot(it, includeRoot);
            if (collection2 != null) {
                collection = collection2;
                return collection;
            }
        }
        collection = SetsKt.emptySet();
        return collection;
    }

    public static /* synthetic */ Collection getAllVirtualFilesFromJar$default(LibraryUtils libraryUtils, Path path, CoreJarFileSystem coreJarFileSystem, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            coreJarFileSystem = new CoreJarFileSystem();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return libraryUtils.getAllVirtualFilesFromJar(path, coreJarFileSystem, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiFile> getAllPsiFilesFromJar(@NotNull Path jar, @NotNull Project project, @NotNull CoreJarFileSystem jarFileSystem, boolean includeRoot) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jarFileSystem, (String)"jarFileSystem");
        Collection<VirtualFile> virtualFiles = this.getAllVirtualFilesFromJar(jar, jarFileSystem, includeRoot);
        Iterable iterable = virtualFiles;
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile virtualFile2 = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (PsiManager.getInstance((Project)project).findFile(virtualFile2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getAllPsiFilesFromJar$default(LibraryUtils libraryUtils, Path path, Project project, CoreJarFileSystem coreJarFileSystem, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            coreJarFileSystem = new CoreJarFileSystem();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return libraryUtils.getAllPsiFilesFromJar(path, project, coreJarFileSystem, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Collection<VirtualFile> getAllVirtualFilesFromDirectory(@NotNull Path dir, boolean includeRoot) {
        Collection<VirtualFile> collection;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        VirtualFileSystem fs = StandardFileSystems.local();
        VirtualFile virtualFile2 = fs.findFileByPath(((Object)dir).toString());
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            Collection<VirtualFile> collection2 = INSTANCE.getAllVirtualFilesFromRoot(it, includeRoot);
            if (collection2 != null) {
                collection = collection2;
                return collection;
            }
        }
        collection = SetsKt.emptySet();
        return collection;
    }

    public static /* synthetic */ Collection getAllVirtualFilesFromDirectory$default(LibraryUtils libraryUtils, Path path, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return libraryUtils.getAllVirtualFilesFromDirectory(path, bl);
    }

    @NotNull
    public final Collection<VirtualFile> getAllVirtualFilesFromRoot(@NotNull VirtualFile root, boolean includeRoot) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Set files = new LinkedHashSet();
        if (includeRoot) {
            files.add(root);
        }
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, LibraryUtils::getAllVirtualFilesFromRoot$lambda$3, arg_0 -> LibraryUtils.getAllVirtualFilesFromRoot$lambda$4(files, arg_0));
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> readModulesFromReleaseFile(Path jrtBaseDir) {
        Closeable closeable = Files.newInputStream(jrtBaseDir.resolve("release"), new OpenOption[0]);
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            Properties p = new Properties();
            p.load(stream);
            String modules = p.getProperty("MODULES");
            if (modules != null) {
                List list = StringUtil.split((String)StringUtil.unquoteString((String)modules), (String)" ");
                return list;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return null;
    }

    private final boolean isModularRuntime(Path homePath) {
        return Files.isRegularFile(homePath.resolve("lib/jrt-fs.jar"), new LinkOption[0]) || this.isExplodedModularRuntime(homePath);
    }

    private final boolean isExplodedModularRuntime(Path homePath) {
        return Files.isDirectory(homePath.resolve("modules/java.base"), new LinkOption[0]);
    }

    @NotNull
    public final List<String> findClassesFromJdkHome(@NotNull Path jdkHome) {
        Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
        List result = new ArrayList();
        if (this.isModularRuntime(jdkHome)) {
            String jrtBaseUrl = "jrt://" + FileUtil.toSystemIndependentName((String)((Object)jdkHome.toAbsolutePath()).toString()) + "!/";
            List<String> modules = this.readModulesFromReleaseFile(jdkHome);
            if (modules != null) {
                for (String module : modules) {
                    result.add(jrtBaseUrl + module);
                }
            }
        }
        CollectionsKt.sort((List)result);
        return result;
    }

    private static final boolean getAllVirtualFilesFromRoot$lambda$3(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean getAllVirtualFilesFromRoot$lambda$4(Set $files, VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        if (!virtualFile2.isDirectory()) {
            $files.add(virtualFile2);
        }
        return true;
    }
}

