/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.Demo;
import org.languagetool.rules.FakeRule;
import org.languagetool.rules.GRPCUtils;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ml.MLServerProto;

public class GRPCUtilsTest {
    @Test
    public void testLevels() {
        for (JLanguageTool.Level level : JLanguageTool.Level.values()) {
            GRPCUtils.toGRPC((JLanguageTool.Level)level);
        }
        for (JLanguageTool.Level level : MLServerProto.ProcessingOptions.Level.values()) {
            if (level.equals((Object)MLServerProto.ProcessingOptions.Level.UNRECOGNIZED)) continue;
            GRPCUtils.fromGRPC((MLServerProto.ProcessingOptions.Level)level);
        }
    }

    @Test
    public void testURLFromRule() throws IOException {
        JLanguageTool lt = new JLanguageTool((Language)new Demo());
        AnalyzedSentence s = lt.getAnalyzedSentence("This is a test");
        FakeRule rule = new FakeRule();
        rule.setUrl(new URL("http://example.com/"));
        RuleMatch m = new RuleMatch((Rule)rule, s, 0, 1, "test");
        String url = GRPCUtils.toGRPC((RuleMatch)m).getUrl();
        Assert.assertEquals((Object)"http://example.com/", (Object)url);
    }

    @Test
    public void testURLFromRuleMatch() throws IOException {
        JLanguageTool lt = new JLanguageTool((Language)new Demo());
        AnalyzedSentence s = lt.getAnalyzedSentence("This is a test");
        FakeRule rule = new FakeRule();
        rule.setUrl(new URL("http://example.com/wrong"));
        RuleMatch m = new RuleMatch((Rule)rule, s, 0, 1, "test");
        m.setUrl(new URL("http://example.com/"));
        String url = GRPCUtils.toGRPC((RuleMatch)m).getUrl();
        Assert.assertEquals((Object)"http://example.com/", (Object)url);
    }
}

