/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.languagetool.Experimental;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.rules.GRPCUtils;
import org.languagetool.rules.ml.MLServerProto;
import org.languagetool.rules.ml.ProcessingServerGrpc;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.Pipeline;
import org.languagetool.server.PipelinePool;
import org.languagetool.server.PipelineSettings;
import org.languagetool.server.TextChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class GRPCServer
extends ProcessingServerGrpc.ProcessingServerImplBase {
    private static final Logger log = LoggerFactory.getLogger(GRPCServer.class);
    private PipelinePool pool;
    private UserConfig userConfig = new UserConfig();
    private GlobalConfig globalConfig = new GlobalConfig();

    public void initPool(HTTPServerConfig serverConfig) {
        this.pool = new PipelinePool(serverConfig, null, false);
    }

    private PipelineSettings buildSettings(MLServerProto.ProcessingOptions options) {
        Language lang = Languages.getLanguageForShortCode((String)options.getLanguage());
        JLanguageTool.Level level = GRPCUtils.fromGRPC((MLServerProto.ProcessingOptions.Level)options.getLevel());
        List<String> enabled = options.getEnabledRulesList().stream().collect(Collectors.toList());
        List<String> disabled = options.getDisabledRulesList().stream().collect(Collectors.toList());
        TextChecker.QueryParams params = new TextChecker.QueryParams(Collections.emptyList(), enabled, disabled, Collections.emptyList(), Collections.emptyList(), options.getEnabledOnly(), true, false, false, options.getPremium(), options.getTempOff(), JLanguageTool.Mode.ALL, level, null);
        return new PipelineSettings(lang, null, params, this.globalConfig, this.userConfig);
    }

    public void analyze(MLServerProto.AnalyzeRequest request, StreamObserver<MLServerProto.AnalyzeResponse> responseObserver) {
        if (this.pool == null) {
            responseObserver.onError((Throwable)new IllegalStateException("Pool not initialized"));
            return;
        }
        try {
            log.info("Handling analyze request");
            PipelineSettings settings = this.buildSettings(request.getOptions());
            Pipeline pipeline = this.pool.getPipeline(settings);
            List sentences = pipeline.analyzeText(request.getText());
            MLServerProto.AnalyzeResponse response = MLServerProto.AnalyzeResponse.newBuilder().addAllSentences((Iterable)sentences.stream().map(GRPCUtils::toGRPC).collect(Collectors.toList())).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            log.warn("Analyze request failed", (Throwable)e);
            responseObserver.onError((Throwable)e);
        }
    }

    public void process(MLServerProto.ProcessRequest request, StreamObserver<MLServerProto.ProcessResponse> responseObserver) {
        if (this.pool == null) {
            responseObserver.onError((Throwable)new IllegalStateException("Pool not initialized"));
            return;
        }
        try {
            log.info("Handling process request: {}", (Object)request);
            PipelineSettings settings = this.buildSettings(request.getOptions());
            Pipeline pipeline = this.pool.getPipeline(settings);
            ArrayList rawMatches = new ArrayList();
            String text = request.getSentencesList().stream().map(s -> s.getText()).collect(Collectors.joining());
            List matches = pipeline.check(text, m -> rawMatches.add(m));
            MLServerProto.ProcessResponse response = MLServerProto.ProcessResponse.newBuilder().addAllRawMatches((Iterable)rawMatches.stream().map(GRPCUtils::toGRPC).collect(Collectors.toList())).addAllMatches((Iterable)matches.stream().map(GRPCUtils::toGRPC).collect(Collectors.toList())).build();
            responseObserver.onNext((Object)response);
            log.info("Sending response: {}", (Object)response);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            log.warn("Process request failed", (Throwable)e);
            responseObserver.onError((Throwable)e);
        }
    }

    private Options getCommandLineOptions() {
        Options options = new Options();
        options.addOption(Option.builder().longOpt("config").hasArg().required().build());
        options.addOption(Option.builder().longOpt("port").hasArg().build());
        options.addOption(Option.builder().longOpt("cert").hasArg().build());
        options.addOption(Option.builder().longOpt("key").hasArg().build());
        return options;
    }

    private CommandLine parseCommandLine(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        return parser.parse(this.getCommandLineOptions(), args);
    }

    public static void main(String[] args) throws Exception {
        HTTPServerConfig config;
        GRPCServer instance = new GRPCServer();
        int port = 8080;
        File cert = null;
        File key = null;
        try {
            CommandLine cli = instance.parseCommandLine(args);
            String certPath = cli.getOptionValue("cert");
            String keyPath = cli.getOptionValue("key");
            if (certPath != null && keyPath != null) {
                cert = new File(certPath);
                key = new File(keyPath);
            }
            if (cli.hasOption("port")) {
                port = Integer.parseInt(cli.getOptionValue("port"));
            }
            config = cli.hasOption("config") ? new HTTPServerConfig(new String[]{"--config", cli.getOptionValue("config")}) : new HTTPServerConfig();
        }
        catch (Exception e) {
            HelpFormatter help = new HelpFormatter();
            help.printHelp("GRPCServer", instance.getCommandLineOptions());
            System.exit(1);
            return;
        }
        instance.initPool(config);
        ExecutorService executor = Executors.newCachedThreadPool();
        ServerBuilder builder = ServerBuilder.forPort((int)port).addService((BindableService)instance).executor((Executor)executor);
        if (cert != null && key != null) {
            builder = builder.useTransportSecurity(cert, key);
        }
        Server server = builder.build();
        server.start();
        System.out.println("port=" + server.getPort());
        server.awaitTermination();
    }
}

