/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.corpus.dictionary.DictionaryMaker;
import com.hankcs.hanlp.corpus.dictionary.EasyDictionary;
import com.hankcs.hanlp.corpus.dictionary.ISaveAble;
import com.hankcs.hanlp.corpus.dictionary.NGramDictionaryMaker;
import com.hankcs.hanlp.corpus.document.CorpusLoader;
import com.hankcs.hanlp.corpus.document.Document;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class CommonDictionaryMaker
implements ISaveAble {
    public boolean verbose = false;
    EasyDictionary dictionary;
    DictionaryMaker dictionaryMaker;
    NGramDictionaryMaker nGramDictionaryMaker = new NGramDictionaryMaker();

    public CommonDictionaryMaker(EasyDictionary dictionary) {
        this.dictionaryMaker = new DictionaryMaker();
        this.dictionary = dictionary;
    }

    @Override
    public boolean saveTxtTo(String path) {
        return this.dictionaryMaker.saveTxtTo(path + ".txt") && this.nGramDictionaryMaker.saveTxtTo(path);
    }

    public void compute(List<List<IWord>> sentenceList) {
        this.roleTag(sentenceList);
        this.addToDictionary(sentenceList);
    }

    public void learn(List<Sentence> sentenceList) {
        ArrayList<List<IWord>> s = new ArrayList<List<IWord>>(sentenceList.size());
        for (Sentence sentence : sentenceList) {
            s.add(sentence.wordList);
        }
        this.compute(s);
    }

    public void learn(Sentence ... sentences) {
        this.learn(Arrays.asList(sentences));
    }

    public void train(String corpus) {
        CorpusLoader.walk(corpus, new CorpusLoader.Handler(){

            @Override
            public void handle(Document document) {
                List<List<Word>> simpleSentenceList = document.getSimpleSentenceList();
                LinkedList<List<IWord>> compatibleList = new LinkedList<List<IWord>>();
                for (List<Word> wordList : simpleSentenceList) {
                    compatibleList.add(new LinkedList<Word>(wordList));
                }
                CommonDictionaryMaker.this.compute(compatibleList);
            }
        });
    }

    protected abstract void addToDictionary(List<List<IWord>> var1);

    protected abstract void roleTag(List<List<IWord>> var1);
}

