/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.RedisCommandTimeoutException;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.internal.ExceptionFactory;
import io.lettuce.core.protocol.ConnectionInitializer;
import io.lettuce.core.resource.ClientResources;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;

public class RedisHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final ConnectionInitializer connectionInitializer;
    private final ClientResources clientResources;
    private final Duration initializeTimeout;
    private final CompletableFuture<Void> handshakeFuture = new CompletableFuture();
    private volatile boolean timedOut = false;

    public RedisHandshakeHandler(ConnectionInitializer connectionInitializer, ClientResources clientResources, Duration initializeTimeout) {
        this.connectionInitializer = connectionInitializer;
        this.clientResources = clientResources;
        this.initializeTimeout = initializeTimeout;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        Runnable timeoutGuard = () -> {
            this.timedOut = true;
            if (this.handshakeFuture.isDone()) {
                return;
            }
            this.fail(ctx, new RedisCommandTimeoutException("Connection initialization timed out after " + ExceptionFactory.formatTimeout(this.initializeTimeout)));
        };
        Timeout timeoutHandle = this.clientResources.timer().newTimeout(t -> {
            if (this.clientResources.eventExecutorGroup().isShuttingDown()) {
                timeoutGuard.run();
                return;
            }
            this.clientResources.eventExecutorGroup().submit(timeoutGuard);
        }, this.initializeTimeout.toNanos(), TimeUnit.NANOSECONDS);
        this.handshakeFuture.thenAccept(ignore -> timeoutHandle.cancel());
        super.channelRegistered(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.shouldFail()) {
            this.fail(ctx, new RedisConnectionException("Connection closed prematurely"));
        }
        super.channelInactive(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        CompletionStage<Void> future = this.connectionInitializer.initialize(ctx.channel());
        future.whenComplete((ignore, throwable) -> {
            if (throwable != null) {
                if (this.shouldFail()) {
                    this.fail(ctx, (Throwable)throwable);
                }
            } else {
                ctx.fireChannelActive();
                this.succeed();
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.shouldFail()) {
            this.fail(ctx, cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    protected void succeed() {
        this.handshakeFuture.complete(null);
    }

    protected void fail(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close().addListener(closeFuture -> this.handshakeFuture.completeExceptionally(cause));
    }

    public CompletionStage<Void> channelInitialized() {
        return this.handshakeFuture;
    }

    private boolean shouldFail() {
        return !this.handshakeFuture.isDone() && !this.timedOut;
    }
}

