/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import net.osmand.data.RotatedTileBox;
import net.sourceforge.offroad.ui.OffRoadUIThread;
import net.sourceforge.offroad.ui.OsmBitmapPanel;

public class GenerateLayerOverlayThread
extends OffRoadUIThread {
    private RotatedTileBox mTileBox;

    public GenerateLayerOverlayThread(OsmBitmapPanel pOsmBitmapPanel, RotatedTileBox pTileCopy) {
        super(pOsmBitmapPanel, "Overlay");
        this.mTileBox = pTileCopy;
    }

    @Override
    public void runInBackground() {
        int counter = 0;
        while (this.mNextThread == null) {
            try {
                int millis = 20;
                Thread.sleep(millis);
                if ((counter += millis) < 1000) continue;
                log.debug((Object)("THREAD:" + this + " executes its background task."));
                this.createLayers();
                return;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.debug((Object)("THREAD:" + this + " should continue without background task."));
    }

    private void createLayers() {
        Dimension size = this.mOsmBitmapPanel.getSize();
        BufferedImage layerImage = new BufferedImage(size.width, size.height, 2);
        Graphics2D lg = layerImage.createGraphics();
        this.mOsmBitmapPanel.drawLayers(this.mTileBox, lg, false);
        this.mOsmBitmapPanel.setLayerImage(layerImage, this.mTileBox);
    }
}

