/*
 * Decompiled with CFR 0.152.
 */
package j2html.tags;

import j2html.Config;
import j2html.attributes.Attribute;
import j2html.rendering.FlatHtml;
import j2html.rendering.HtmlBuilder;
import j2html.rendering.IndentedHtml;
import j2html.rendering.TagBuilder;
import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.Text;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class ContainerTag<T extends ContainerTag<T>>
extends Tag<T> {
    protected List<DomContent> children = new ArrayList<DomContent>();

    public ContainerTag(String tagName) {
        super(tagName);
    }

    public T with(DomContent child) {
        if (this == child) {
            throw new RuntimeException("Cannot append a tag to itself.");
        }
        if (child != null) {
            this.children.add(child);
        }
        return (T)((ContainerTag)this.self());
    }

    public T condWith(boolean condition, DomContent child) {
        return (T)(condition ? this.with(child) : (ContainerTag)this.self());
    }

    public T with(Iterable<? extends DomContent> children) {
        if (children != null) {
            for (DomContent domContent : children) {
                this.with(domContent);
            }
        }
        return (T)((ContainerTag)this.self());
    }

    public T condWith(boolean condition, Iterable<? extends DomContent> children) {
        return (T)(condition ? this.with(children) : (ContainerTag)this.self());
    }

    public T with(DomContent ... children) {
        for (DomContent child : children) {
            this.with(child);
        }
        return (T)((ContainerTag)this.self());
    }

    public T with(Stream<DomContent> children) {
        children.forEach(this::with);
        return (T)((ContainerTag)this.self());
    }

    public T condWith(boolean condition, DomContent ... children) {
        return (T)(condition ? this.with(children) : (ContainerTag)this.self());
    }

    public T withText(String text) {
        return this.with((DomContent)new Text(text));
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public String renderFormatted() {
        try {
            return this.render(IndentedHtml.into(new StringBuilder(), Config.global())).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <A extends Appendable> A render(HtmlBuilder<A> builder, Object model) throws IOException {
        if (this.hasTagName()) {
            TagBuilder tagBuilder = builder.appendStartTag(this.getTagName());
            for (Attribute attribute : this.getAttributes()) {
                attribute.render(tagBuilder, model);
            }
            tagBuilder.completeTag();
        }
        for (DomContent child : this.children) {
            child.render(builder, model);
        }
        if (this.hasTagName()) {
            builder.appendEndTag(this.getTagName());
        }
        return builder.output();
    }

    @Override
    @Deprecated
    public void renderModel(Appendable writer, Object model) throws IOException {
        FlatHtml<Appendable> builder = writer instanceof HtmlBuilder ? (FlatHtml<Appendable>)writer : FlatHtml.into(writer, Config.global());
        this.render((HtmlBuilder)builder, model);
    }
}

