/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedSecurityRequirement;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedSecurityRequirements
implements ComposedChanged {
    private List<SecurityRequirement> oldSecurityRequirements;
    private List<SecurityRequirement> newSecurityRequirements;
    private List<SecurityRequirement> missing;
    private List<SecurityRequirement> increased;
    private List<ChangedSecurityRequirement> changed;

    public ChangedSecurityRequirements(List<SecurityRequirement> oldSecurityRequirements, List<SecurityRequirement> newSecurityRequirements) {
        this.oldSecurityRequirements = oldSecurityRequirements;
        this.newSecurityRequirements = newSecurityRequirements;
        this.changed = new ArrayList<ChangedSecurityRequirement>();
    }

    @Override
    public List<Changed> getChangedElements() {
        return new ArrayList<Changed>(this.changed);
    }

    @Override
    public DiffResult isCoreChanged() {
        if (CollectionUtils.isEmpty(this.missing) && CollectionUtils.isEmpty(this.increased)) {
            return DiffResult.NO_CHANGES;
        }
        if (CollectionUtils.isEmpty(this.missing)) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.INCOMPATIBLE;
    }

    public void addMissing(SecurityRequirement securityRequirement) {
        if (this.missing == null) {
            this.missing = new ArrayList<SecurityRequirement>();
        }
        this.missing.add(securityRequirement);
    }

    public void addIncreased(SecurityRequirement securityRequirement) {
        if (this.increased == null) {
            this.increased = new ArrayList<SecurityRequirement>();
        }
        this.increased.add(securityRequirement);
    }

    public void addChanged(ChangedSecurityRequirement changedSecurityRequirement) {
        if (this.changed == null) {
            this.changed = new ArrayList<ChangedSecurityRequirement>();
        }
        this.changed.add(changedSecurityRequirement);
    }

    public List<SecurityRequirement> getOldSecurityRequirements() {
        return this.oldSecurityRequirements;
    }

    public List<SecurityRequirement> getNewSecurityRequirements() {
        return this.newSecurityRequirements;
    }

    public List<SecurityRequirement> getMissing() {
        return this.missing;
    }

    public List<SecurityRequirement> getIncreased() {
        return this.increased;
    }

    public List<ChangedSecurityRequirement> getChanged() {
        return this.changed;
    }

    public ChangedSecurityRequirements setOldSecurityRequirements(List<SecurityRequirement> oldSecurityRequirements) {
        this.oldSecurityRequirements = oldSecurityRequirements;
        return this;
    }

    public ChangedSecurityRequirements setNewSecurityRequirements(List<SecurityRequirement> newSecurityRequirements) {
        this.newSecurityRequirements = newSecurityRequirements;
        return this;
    }

    public ChangedSecurityRequirements setMissing(List<SecurityRequirement> missing) {
        this.missing = missing;
        return this;
    }

    public ChangedSecurityRequirements setIncreased(List<SecurityRequirement> increased) {
        this.increased = increased;
        return this;
    }

    public ChangedSecurityRequirements setChanged(List<ChangedSecurityRequirement> changed) {
        this.changed = changed;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedSecurityRequirements that = (ChangedSecurityRequirements)o;
        return Objects.equals(this.oldSecurityRequirements, that.oldSecurityRequirements) && Objects.equals(this.newSecurityRequirements, that.newSecurityRequirements) && Objects.equals(this.missing, that.missing) && Objects.equals(this.increased, that.increased) && Objects.equals(this.changed, that.changed);
    }

    public int hashCode() {
        return Objects.hash(this.oldSecurityRequirements, this.newSecurityRequirements, this.missing, this.increased, this.changed);
    }

    public String toString() {
        return "ChangedSecurityRequirements(oldSecurityRequirements=" + this.getOldSecurityRequirements() + ", newSecurityRequirements=" + this.getNewSecurityRequirements() + ", missing=" + this.getMissing() + ", increased=" + this.getIncreased() + ", changed=" + this.getChanged() + ")";
    }
}

