/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.SetOnce;
import org.opensearch.common.collect.Tuple;
import org.opensearch.core.common.Strings;

public interface IndexAbstraction {
    public Type getType();

    public String getName();

    public List<IndexMetadata> getIndices();

    @Nullable
    public IndexMetadata getWriteIndex();

    @Nullable
    public DataStream getParentDataStream();

    public boolean isHidden();

    public boolean isSystem();

    public static class DataStream
    implements IndexAbstraction {
        private final org.opensearch.cluster.metadata.DataStream dataStream;
        private final List<IndexMetadata> dataStreamIndices;
        private final IndexMetadata writeIndex;

        public DataStream(org.opensearch.cluster.metadata.DataStream dataStream, List<IndexMetadata> dataStreamIndices) {
            this.dataStream = dataStream;
            this.dataStreamIndices = List.copyOf(dataStreamIndices);
            this.writeIndex = dataStreamIndices.get(dataStreamIndices.size() - 1);
            assert (this.writeIndex.getIndex().getName().equals(org.opensearch.cluster.metadata.DataStream.getDefaultBackingIndexName(dataStream.getName(), dataStream.getGeneration())));
        }

        @Override
        public String getName() {
            return this.dataStream.getName();
        }

        @Override
        public Type getType() {
            return Type.DATA_STREAM;
        }

        @Override
        public List<IndexMetadata> getIndices() {
            return this.dataStreamIndices;
        }

        @Override
        public IndexMetadata getWriteIndex() {
            return this.writeIndex;
        }

        @Override
        public DataStream getParentDataStream() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isSystem() {
            return false;
        }

        public org.opensearch.cluster.metadata.DataStream getDataStream() {
            return this.dataStream;
        }
    }

    public static class Alias
    implements IndexAbstraction {
        private final String aliasName;
        private final List<IndexMetadata> referenceIndexMetadatas;
        private final SetOnce<IndexMetadata> writeIndex = new SetOnce();
        private final boolean isHidden;

        public Alias(AliasMetadata aliasMetadata, IndexMetadata indexMetadata) {
            this.aliasName = aliasMetadata.getAlias();
            this.referenceIndexMetadatas = new ArrayList<IndexMetadata>();
            this.referenceIndexMetadatas.add(indexMetadata);
            this.isHidden = aliasMetadata.isHidden() == null ? false : aliasMetadata.isHidden();
        }

        @Override
        public Type getType() {
            return Type.ALIAS;
        }

        @Override
        public String getName() {
            return this.aliasName;
        }

        @Override
        public List<IndexMetadata> getIndices() {
            return this.referenceIndexMetadatas;
        }

        @Override
        @Nullable
        public IndexMetadata getWriteIndex() {
            return (IndexMetadata)this.writeIndex.get();
        }

        @Override
        public DataStream getParentDataStream() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }

        @Override
        public boolean isSystem() {
            return this.referenceIndexMetadatas.stream().allMatch(IndexMetadata::isSystem);
        }

        public Iterable<Tuple<String, AliasMetadata>> getConcreteIndexAndAliasMetadatas() {
            return () -> new Iterator<Tuple<String, AliasMetadata>>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < referenceIndexMetadatas.size();
                }

                @Override
                public Tuple<String, AliasMetadata> next() {
                    IndexMetadata indexMetadata = referenceIndexMetadatas.get(this.index++);
                    return new Tuple((Object)indexMetadata.getIndex().getName(), (Object)indexMetadata.getAliases().get(aliasName));
                }
            };
        }

        public AliasMetadata getFirstAliasMetadata() {
            return this.referenceIndexMetadatas.get(0).getAliases().get(this.aliasName);
        }

        void addIndex(IndexMetadata indexMetadata) {
            this.referenceIndexMetadatas.add(indexMetadata);
        }

        public void computeAndValidateAliasProperties() {
            List writeIndices = this.referenceIndexMetadatas.stream().filter(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(this.aliasName).writeIndex())).collect(Collectors.toList());
            if (writeIndices.isEmpty() && this.referenceIndexMetadatas.size() == 1 && this.referenceIndexMetadatas.get(0).getAliases().get(this.aliasName).writeIndex() == null) {
                writeIndices.add(this.referenceIndexMetadatas.get(0));
            }
            if (writeIndices.size() == 1) {
                this.writeIndex.set((Object)((IndexMetadata)writeIndices.get(0)));
            } else if (writeIndices.size() > 1) {
                List writeIndicesStrings = writeIndices.stream().map(i -> i.getIndex().getName()).collect(Collectors.toList());
                throw new IllegalStateException("alias [" + this.aliasName + "] has more than one write index [" + Strings.collectionToCommaDelimitedString(writeIndicesStrings) + "]");
            }
            Map<Boolean, List<IndexMetadata>> groupedByHiddenStatus = this.referenceIndexMetadatas.stream().collect(Collectors.groupingBy(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(this.aliasName).isHidden())));
            if (this.isNonEmpty(groupedByHiddenStatus.get(true)) && this.isNonEmpty(groupedByHiddenStatus.get(false))) {
                List hiddenOn = groupedByHiddenStatus.get(true).stream().map(idx -> idx.getIndex().getName()).collect(Collectors.toList());
                List nonHiddenOn = groupedByHiddenStatus.get(false).stream().map(idx -> idx.getIndex().getName()).collect(Collectors.toList());
                throw new IllegalStateException("alias [" + this.aliasName + "] has is_hidden set to true on indices [" + Strings.collectionToCommaDelimitedString(hiddenOn) + "] but does not have is_hidden set to true on indices [" + Strings.collectionToCommaDelimitedString(nonHiddenOn) + "]; alias must have the same is_hidden setting on all indices");
            }
        }

        private boolean isNonEmpty(List<IndexMetadata> idxMetas) {
            return !(Objects.isNull(idxMetas) || idxMetas.isEmpty());
        }
    }

    public static class Index
    implements IndexAbstraction {
        private final IndexMetadata concreteIndex;
        private final DataStream dataStream;

        public Index(IndexMetadata indexMetadata, DataStream dataStream) {
            this.concreteIndex = indexMetadata;
            this.dataStream = dataStream;
        }

        public Index(IndexMetadata indexMetadata) {
            this(indexMetadata, null);
        }

        @Override
        public String getName() {
            return this.concreteIndex.getIndex().getName();
        }

        @Override
        public Type getType() {
            return Type.CONCRETE_INDEX;
        }

        @Override
        public List<IndexMetadata> getIndices() {
            return Collections.singletonList(this.concreteIndex);
        }

        @Override
        public IndexMetadata getWriteIndex() {
            return this.concreteIndex;
        }

        @Override
        public DataStream getParentDataStream() {
            return this.dataStream;
        }

        @Override
        public boolean isHidden() {
            return IndexMetadata.INDEX_HIDDEN_SETTING.get(this.concreteIndex.getSettings());
        }

        @Override
        public boolean isSystem() {
            return this.concreteIndex.isSystem();
        }
    }

    public static enum Type {
        CONCRETE_INDEX("concrete index"),
        ALIAS("alias"),
        DATA_STREAM("data_stream");

        private final String displayName;

        private Type(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

