/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.geo;

import java.util.Arrays;
import java.util.Locale;
import org.apache.lucene.document.ShapeField;

public class ShapeDocValue {
    protected Centroid centroid;
    protected BoundingRectangle boundingRectangle;
    protected ShapeType highestDimensionType;

    public Centroid getCentroid() {
        return this.centroid;
    }

    public BoundingRectangle getBoundingRectangle() {
        return this.boundingRectangle;
    }

    public ShapeType getHighestDimensionType() {
        return this.highestDimensionType;
    }

    public static enum ShapeType {
        POINT,
        LINE,
        TRIANGLE;


        public static ShapeType fromShapeFieldType(ShapeField.DecodedTriangle.TYPE type) {
            switch (type) {
                case POINT: {
                    return POINT;
                }
                case LINE: {
                    return LINE;
                }
                case TRIANGLE: {
                    return TRIANGLE;
                }
            }
            throw new IllegalStateException(String.format(Locale.ROOT, "No correct mapped type found for the value %s in the list of values : %s", type, Arrays.toString((Object[])ShapeType.values())));
        }

        public String toString() {
            return this.name();
        }
    }

    public static class BoundingRectangle {
        private final double maxX;
        private final double maxY;
        private final double minY;
        private final double minX;

        BoundingRectangle(double maxLon, double maxLat, double minLon, double minLat) {
            this.maxY = maxLat;
            this.maxX = maxLon;
            this.minY = minLat;
            this.minX = minLon;
        }

        public double getMaxX() {
            return this.maxX;
        }

        public double getMaxY() {
            return this.maxY;
        }

        public double getMinY() {
            return this.minY;
        }

        public double getMinX() {
            return this.minX;
        }

        public String toString() {
            return "maxY: " + this.maxY + "minY: " + this.minY + "maxX: " + this.maxX + "minX: " + this.minX;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundingRectangle boundingRectangle = (BoundingRectangle)o;
            if (Double.compare(boundingRectangle.maxY, this.maxY) != 0) {
                return false;
            }
            if (Double.compare(boundingRectangle.maxX, this.minX) != 0) {
                return false;
            }
            if (Double.compare(boundingRectangle.minY, this.minY) != 0) {
                return false;
            }
            return Double.compare(boundingRectangle.minX, this.minX) == 0;
        }

        public int hashCode() {
            long temp = this.maxY != 0.0 ? Double.doubleToLongBits(this.maxY) : 0L;
            int result = Long.hashCode(temp);
            temp = this.maxX != 0.0 ? Double.doubleToLongBits(this.maxX) : 0L;
            result = 31 * result + Long.hashCode(temp);
            temp = this.minY != 0.0 ? Double.doubleToLongBits(this.minY) : 0L;
            result = 31 * result + Long.hashCode(temp);
            temp = this.minX != 0.0 ? Double.doubleToLongBits(this.minX) : 0L;
            result = 31 * result + Long.hashCode(temp);
            return result;
        }
    }

    public static class Centroid {
        private final double y;
        private final double x;

        Centroid(double y, double x) {
            this.y = y;
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public double getX() {
            return this.x;
        }

        public String toString() {
            return this.y + ", " + this.x;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Centroid centroid = (Centroid)o;
            if (Double.compare(centroid.y, this.y) != 0) {
                return false;
            }
            return Double.compare(centroid.x, this.x) == 0;
        }

        public int hashCode() {
            long temp = this.y != 0.0 ? Double.doubleToLongBits(this.y) : 0L;
            int result = Long.hashCode(temp);
            temp = this.x != 0.0 ? Double.doubleToLongBits(this.x) : 0L;
            result = 31 * result + Long.hashCode(temp);
            return result;
        }
    }
}

