/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.opensearch.OpenSearchException;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.transport.TransportService;

public class NamedRoute
extends RestHandler.Route {
    private static final String VALID_ACTION_NAME_PATTERN = "^[a-zA-Z0-9:/*_]*$";
    static final int MAX_LENGTH_OF_ACTION_NAME = 250;
    private final String uniqueName;
    private final Set<String> actionNames;
    private Function<RestRequest, RestResponse> handler;

    private NamedRoute(Builder builder) {
        super(builder.method, builder.path);
        if (!this.isValidRouteName(builder.uniqueName)) {
            throw new OpenSearchException("Invalid route name specified. The route name may include the following characters 'a-z', 'A-Z', '0-9', ':', '/', '*', '_' and be less than 250 characters", new Object[0]);
        }
        this.uniqueName = builder.uniqueName;
        this.actionNames = Set.copyOf(builder.legacyActionNames);
        this.handler = builder.handler;
    }

    public boolean isValidRouteName(String routeName) {
        return routeName != null && !routeName.isBlank() && routeName.length() <= 250 && routeName.matches(VALID_ACTION_NAME_PATTERN);
    }

    public String name() {
        return this.uniqueName;
    }

    public Set<String> actionNames() {
        return this.actionNames;
    }

    public Function<RestRequest, RestResponse> handler() {
        return this.handler;
    }

    @Override
    public String toString() {
        return "NamedRoute [method=" + this.method + ", path=" + this.path + ", name=" + this.uniqueName + ", actionNames=" + this.actionNames + "]";
    }

    public static class Builder {
        private RestRequest.Method method;
        private String path;
        private String uniqueName;
        private final Set<String> legacyActionNames = new HashSet<String>();
        private Function<RestRequest, RestResponse> handler;

        public Builder method(RestRequest.Method method) {
            Objects.requireNonNull(method, "REST method must not be null.");
            this.method = method;
            return this;
        }

        public Builder path(String path) {
            Objects.requireNonNull(path, "REST path must not be null.");
            this.path = path;
            return this;
        }

        public Builder uniqueName(String name) {
            Objects.requireNonNull(name, "REST route name must not be null.");
            this.uniqueName = name;
            return this;
        }

        public Builder legacyActionNames(Set<String> legacyActionNames) {
            this.legacyActionNames.addAll(this.validateLegacyActionNames(legacyActionNames));
            return this;
        }

        public Builder handler(Function<RestRequest, RestResponse> handler) {
            Objects.requireNonNull(handler, "Route handler must not be null.");
            this.handler = handler;
            return this;
        }

        public NamedRoute build() {
            this.checkIfFieldsAreSet();
            return new NamedRoute(this);
        }

        private void checkIfFieldsAreSet() {
            if (this.method == null || this.path == null || this.uniqueName == null) {
                throw new IllegalStateException("REST method, path and uniqueName are required.");
            }
        }

        private Set<String> validateLegacyActionNames(Set<String> legacyActionNames) {
            if (legacyActionNames == null) {
                return new HashSet<String>();
            }
            for (String actionName : legacyActionNames) {
                if (TransportService.isValidActionName(actionName)) continue;
                throw new OpenSearchException("Invalid action name [" + actionName + "]. It must start with one of: " + TransportService.VALID_ACTION_PREFIXES, new Object[0]);
            }
            return legacyActionNames;
        }
    }
}

