/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.percolator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.BinaryRange;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.sandbox.search.CoveringQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.opensearch.Version;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.hash.MurmurHash3;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.OutputStreamStreamOutput;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.BinaryFieldMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.RangeFieldMapper;
import org.opensearch.index.mapper.RangeType;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.BoostingQueryBuilder;
import org.opensearch.index.query.ConstantScoreQueryBuilder;
import org.opensearch.index.query.DisMaxQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.index.query.Rewriteable;
import org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.opensearch.percolator.PercolateQuery;
import org.opensearch.percolator.QueryAnalyzer;
import org.opensearch.search.lookup.SearchLookup;

public class PercolatorFieldMapper
extends ParametrizedFieldMapper {
    static final Setting<Boolean> INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING = Setting.boolSetting((String)"index.percolator.map_unmapped_fields_as_text", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
    static final String CONTENT_TYPE = "percolator";
    static final byte FIELD_VALUE_SEPARATOR = 0;
    static final String EXTRACTION_COMPLETE = "complete";
    static final String EXTRACTION_PARTIAL = "partial";
    static final String EXTRACTION_FAILED = "failed";
    static final String EXTRACTED_TERMS_FIELD_NAME = "extracted_terms";
    static final String EXTRACTION_RESULT_FIELD_NAME = "extraction_result";
    static final String QUERY_BUILDER_FIELD_NAME = "query_builder_field";
    static final String RANGE_FIELD_NAME = "range_field";
    static final String MINIMUM_SHOULD_MATCH_FIELD_NAME = "minimum_should_match_field";
    private final Supplier<QueryShardContext> queryShardContext;
    private final KeywordFieldMapper queryTermsField;
    private final KeywordFieldMapper extractionResultField;
    private final BinaryFieldMapper queryBuilderField;
    private final NumberFieldMapper minimumShouldMatchFieldMapper;
    private final RangeFieldMapper rangeFieldMapper;
    private final boolean mapUnmappedFieldsAsText;
    private static final FieldType INDEXED_KEYWORD = new FieldType();

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.queryShardContext).init((FieldMapper)this);
    }

    PercolatorFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Supplier<QueryShardContext> queryShardContext, KeywordFieldMapper queryTermsField, KeywordFieldMapper extractionResultField, BinaryFieldMapper queryBuilderField, RangeFieldMapper rangeFieldMapper, NumberFieldMapper minimumShouldMatchFieldMapper, boolean mapUnmappedFieldsAsText) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.queryShardContext = queryShardContext;
        this.queryTermsField = queryTermsField;
        this.extractionResultField = extractionResultField;
        this.queryBuilderField = queryBuilderField;
        this.minimumShouldMatchFieldMapper = minimumShouldMatchFieldMapper;
        this.rangeFieldMapper = rangeFieldMapper;
        this.mapUnmappedFieldsAsText = mapUnmappedFieldsAsText;
    }

    public void parse(ParseContext context) throws IOException {
        QueryShardContext queryShardContext = this.queryShardContext.get();
        if (context.doc().getField(this.queryBuilderField.name()) != null) {
            throw new IllegalArgumentException("a document can only contain one percolator query");
        }
        PercolatorFieldMapper.configureContext(queryShardContext, this.isMapUnmappedFieldAsText());
        XContentParser parser = context.parser();
        QueryBuilder queryBuilder = PercolatorFieldMapper.parseQueryBuilder(parser, parser.getTokenLocation());
        PercolatorFieldMapper.verifyQuery(queryBuilder);
        PlainActionFuture future = new PlainActionFuture();
        Rewriteable.rewriteAndFetch((Rewriteable)queryBuilder, (QueryRewriteContext)queryShardContext, (ActionListener)future);
        queryBuilder = (QueryBuilder)future.actionGet();
        Version indexVersion = context.mapperService().getIndexSettings().getIndexVersionCreated();
        PercolatorFieldMapper.createQueryBuilderField(indexVersion, this.queryBuilderField, queryBuilder, context);
        QueryBuilder queryBuilderForProcessing = queryBuilder.rewrite((QueryRewriteContext)new QueryShardContext(queryShardContext));
        Query query = queryBuilderForProcessing.toQuery(queryShardContext);
        this.processQuery(query, context);
    }

    static void createQueryBuilderField(Version indexVersion, BinaryFieldMapper qbField, QueryBuilder queryBuilder, ParseContext context) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             OutputStreamStreamOutput out = new OutputStreamStreamOutput((OutputStream)stream);){
            out.setVersion(indexVersion);
            out.writeNamedWriteable((NamedWriteable)queryBuilder);
            byte[] queryBuilderAsBytes = stream.toByteArray();
            qbField.parse(context.createExternalValueContext((Object)queryBuilderAsBytes));
        }
    }

    void processQuery(Query query, ParseContext context) {
        ParseContext.Document doc = context.doc();
        PercolatorFieldType pft = (PercolatorFieldType)this.fieldType();
        Version indexVersion = context.mapperService().getIndexSettings().getIndexVersionCreated();
        QueryAnalyzer.Result result = QueryAnalyzer.analyze(query, indexVersion);
        if (result == QueryAnalyzer.Result.UNKNOWN) {
            doc.add((IndexableField)new Field(pft.extractionResultField.name(), (CharSequence)EXTRACTION_FAILED, (IndexableFieldType)INDEXED_KEYWORD));
            return;
        }
        for (QueryAnalyzer.QueryExtraction extraction : result.extractions) {
            if (extraction.term != null) {
                BytesRefBuilder builder = new BytesRefBuilder();
                builder.append(new BytesRef((CharSequence)extraction.field()));
                builder.append((byte)0);
                builder.append(extraction.bytes());
                doc.add((IndexableField)new Field(this.queryTermsField.name(), builder.toBytesRef(), (IndexableFieldType)INDEXED_KEYWORD));
                continue;
            }
            if (extraction.range == null) continue;
            byte[] min = extraction.range.lowerPoint;
            byte[] max = extraction.range.upperPoint;
            doc.add((IndexableField)new BinaryRange(this.rangeFieldMapper.name(), PercolatorFieldMapper.encodeRange(extraction.range.fieldName, min, max)));
        }
        if (result.matchAllDocs) {
            doc.add((IndexableField)new Field(this.extractionResultField.name(), (CharSequence)EXTRACTION_FAILED, (IndexableFieldType)INDEXED_KEYWORD));
            if (result.verified) {
                doc.add((IndexableField)new Field(this.extractionResultField.name(), (CharSequence)EXTRACTION_COMPLETE, (IndexableFieldType)INDEXED_KEYWORD));
            }
        } else if (result.verified) {
            doc.add((IndexableField)new Field(this.extractionResultField.name(), (CharSequence)EXTRACTION_COMPLETE, (IndexableFieldType)INDEXED_KEYWORD));
        } else {
            doc.add((IndexableField)new Field(this.extractionResultField.name(), (CharSequence)EXTRACTION_PARTIAL, (IndexableFieldType)INDEXED_KEYWORD));
        }
        this.createFieldNamesField(context);
        doc.add((IndexableField)new NumericDocValuesField(this.minimumShouldMatchFieldMapper.name(), (long)result.minimumShouldMatch));
    }

    static void configureContext(QueryShardContext context, boolean mapUnmappedFieldsAsString) {
        context.setAllowUnmappedFields(false);
        context.setMapUnmappedFieldAsString(mapUnmappedFieldsAsString);
    }

    static QueryBuilder parseQueryBuilder(XContentParser parser, XContentLocation location) {
        try {
            return AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
        }
        catch (IOException e) {
            throw new ParsingException(location, "Failed to parse", (Throwable)e, new Object[0]);
        }
    }

    public Iterator<Mapper> iterator() {
        return Arrays.asList(this.queryTermsField, this.extractionResultField, this.queryBuilderField, this.minimumShouldMatchFieldMapper, this.rangeFieldMapper).iterator();
    }

    protected void parseCreateField(ParseContext context) {
        throw new UnsupportedOperationException("should not be invoked");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    boolean isMapUnmappedFieldAsText() {
        return this.mapUnmappedFieldsAsText;
    }

    static void verifyQuery(QueryBuilder queryBuilder) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (queryBuilder.getName().equals("has_child")) {
                                throw new IllegalArgumentException("the [has_child] query is unsupported inside a percolator query");
                            }
                            if (queryBuilder.getName().equals("has_parent")) {
                                throw new IllegalArgumentException("the [has_parent] query is unsupported inside a percolator query");
                            }
                            if (!(queryBuilder instanceof BoolQueryBuilder)) break block4;
                            BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
                            ArrayList clauses = new ArrayList();
                            clauses.addAll(boolQueryBuilder.filter());
                            clauses.addAll(boolQueryBuilder.must());
                            clauses.addAll(boolQueryBuilder.mustNot());
                            clauses.addAll(boolQueryBuilder.should());
                            for (QueryBuilder clause : clauses) {
                                PercolatorFieldMapper.verifyQuery(clause);
                            }
                            break block5;
                        }
                        if (!(queryBuilder instanceof ConstantScoreQueryBuilder)) break block6;
                        PercolatorFieldMapper.verifyQuery(((ConstantScoreQueryBuilder)queryBuilder).innerQuery());
                        break block5;
                    }
                    if (!(queryBuilder instanceof FunctionScoreQueryBuilder)) break block7;
                    PercolatorFieldMapper.verifyQuery(((FunctionScoreQueryBuilder)queryBuilder).query());
                    break block5;
                }
                if (!(queryBuilder instanceof BoostingQueryBuilder)) break block8;
                PercolatorFieldMapper.verifyQuery(((BoostingQueryBuilder)queryBuilder).negativeQuery());
                PercolatorFieldMapper.verifyQuery(((BoostingQueryBuilder)queryBuilder).positiveQuery());
                break block5;
            }
            if (!(queryBuilder instanceof DisMaxQueryBuilder)) break block5;
            DisMaxQueryBuilder disMaxQueryBuilder = (DisMaxQueryBuilder)queryBuilder;
            for (QueryBuilder innerQueryBuilder : disMaxQueryBuilder.innerQueries()) {
                PercolatorFieldMapper.verifyQuery(innerQueryBuilder);
            }
        }
    }

    static byte[] encodeRange(String rangeFieldName, byte[] minEncoded, byte[] maxEncoded) {
        assert (minEncoded.length == maxEncoded.length);
        byte[] bytes = new byte[32];
        BytesRef fieldAsBytesRef = new BytesRef((CharSequence)rangeFieldName);
        MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
        MurmurHash3.hash128((byte[])fieldAsBytesRef.bytes, (int)fieldAsBytesRef.offset, (int)fieldAsBytesRef.length, (long)0L, (MurmurHash3.Hash128)hash);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.putLong(hash.h1).putLong(hash.h2).putLong(hash.h1).putLong(hash.h2);
        assert (bb.position() == bb.limit());
        int offset = 16 - minEncoded.length;
        System.arraycopy(minEncoded, 0, bytes, offset, minEncoded.length);
        System.arraycopy(maxEncoded, 0, bytes, 16 + offset, maxEncoded.length);
        return bytes;
    }

    static {
        INDEXED_KEYWORD.setTokenized(false);
        INDEXED_KEYWORD.setOmitNorms(true);
        INDEXED_KEYWORD.setIndexOptions(IndexOptions.DOCS);
        INDEXED_KEYWORD.freeze();
    }

    static class PercolatorFieldType
    extends MappedFieldType {
        MappedFieldType queryTermsField;
        MappedFieldType extractionResultField;
        MappedFieldType queryBuilderField;
        MappedFieldType minimumShouldMatchField;
        RangeFieldMapper.RangeFieldType rangeField;
        boolean mapUnmappedFieldsAsText;

        private PercolatorFieldType(String name, Map<String, String> meta) {
            super(name, false, false, false, TextSearchInfo.NONE, meta);
        }

        public String typeName() {
            return PercolatorFieldMapper.CONTENT_TYPE;
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Percolator fields are not searchable directly, use a percolate query instead", new Object[0]);
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.identity((String)this.name(), (QueryShardContext)context, (String)format);
        }

        Query percolateQuery(String name, PercolateQuery.QueryStore queryStore, List<BytesReference> documents, IndexSearcher searcher, boolean excludeNestedDocuments, Version indexVersion) throws IOException {
            IndexReader indexReader = searcher.getIndexReader();
            Tuple<BooleanQuery, Boolean> t = this.createCandidateQuery(indexReader, indexVersion);
            Query candidateQuery = (Query)t.v1();
            boolean canUseMinimumShouldMatchField = (Boolean)t.v2();
            Object verifiedMatchesQuery = canUseMinimumShouldMatchField && indexReader.maxDoc() == 1 ? new TermQuery(new Term(this.extractionResultField.name(), PercolatorFieldMapper.EXTRACTION_COMPLETE)) : new MatchNoDocsQuery("multiple or nested docs or CoveringQuery could not be used");
            Query filter = null;
            if (excludeNestedDocuments) {
                filter = Queries.newNonNestedFilter();
            }
            return new PercolateQuery(name, queryStore, documents, candidateQuery, searcher, filter, (Query)verifiedMatchesQuery);
        }

        Tuple<BooleanQuery, Boolean> createCandidateQuery(IndexReader indexReader, Version indexVersion) throws IOException {
            Tuple<List<BytesRef>, Map<String, List<byte[]>>> t = this.extractTermsAndRanges(indexReader);
            List extractedTerms = (List)t.v1();
            Map encodedPointValuesByField = (Map)t.v2();
            boolean canUseMinimumShouldMatchField = 1 + extractedTerms.size() + encodedPointValuesByField.size() <= BooleanQuery.getMaxClauseCount();
            ArrayList<Object> subQueries = new ArrayList<Object>();
            for (Map.Entry entry : encodedPointValuesByField.entrySet()) {
                String string = (String)entry.getKey();
                List encodedPointValues = (List)entry.getValue();
                byte[] min = (byte[])encodedPointValues.get(0);
                byte[] max = (byte[])encodedPointValues.get(1);
                Query query = BinaryRange.newIntersectsQuery((String)this.rangeField.name(), (byte[])PercolatorFieldMapper.encodeRange(string, min, max));
                subQueries.add(query);
            }
            BooleanQuery.Builder candidateQuery = new BooleanQuery.Builder();
            if (canUseMinimumShouldMatchField) {
                LongValuesSource valuesSource = LongValuesSource.fromIntField((String)this.minimumShouldMatchField.name());
                for (BytesRef extractedTerm : extractedTerms) {
                    subQueries.add(new TermQuery(new Term(this.queryTermsField.name(), extractedTerm)));
                }
                candidateQuery.add((Query)new CoveringQuery(subQueries, valuesSource), BooleanClause.Occur.SHOULD);
            } else {
                candidateQuery.add((Query)new TermInSetQuery(this.queryTermsField.name(), (Collection)extractedTerms), BooleanClause.Occur.SHOULD);
                for (Query query : subQueries) {
                    candidateQuery.add(query, BooleanClause.Occur.SHOULD);
                }
            }
            candidateQuery.add((Query)new TermQuery(new Term(this.extractionResultField.name(), PercolatorFieldMapper.EXTRACTION_FAILED)), BooleanClause.Occur.SHOULD);
            return new Tuple((Object)candidateQuery.build(), (Object)canUseMinimumShouldMatchField);
        }

        Tuple<List<BytesRef>, Map<String, List<byte[]>>> extractTermsAndRanges(IndexReader indexReader) throws IOException {
            ArrayList<BytesRef> extractedTerms = new ArrayList<BytesRef>();
            HashMap encodedPointValuesByField = new HashMap();
            LeafReader reader = ((LeafReaderContext)indexReader.leaves().get(0)).reader();
            for (FieldInfo info : reader.getFieldInfos()) {
                Terms terms = reader.terms(info.name);
                if (terms != null) {
                    BytesRef fieldBr = new BytesRef((CharSequence)info.name);
                    TermsEnum tenum = terms.iterator();
                    BytesRef term = tenum.next();
                    while (term != null) {
                        BytesRefBuilder builder = new BytesRefBuilder();
                        builder.append(fieldBr);
                        builder.append((byte)0);
                        builder.append(term);
                        extractedTerms.add(builder.toBytesRef());
                        term = tenum.next();
                    }
                }
                if (info.getPointIndexDimensionCount() != 1) continue;
                PointValues values = reader.getPointValues(info.name);
                ArrayList<byte[]> encodedPointValues = new ArrayList<byte[]>();
                encodedPointValues.add((byte[])values.getMinPackedValue().clone());
                encodedPointValues.add((byte[])values.getMaxPackedValue().clone());
                encodedPointValuesByField.put(info.name, encodedPointValues);
            }
            return new Tuple(extractedTerms, encodedPointValuesByField);
        }
    }

    static class TypeParser
    implements Mapper.TypeParser {
        TypeParser() {
        }

        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            return new Builder(name, parserContext.queryShardContextSupplier());
        }
    }

    static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final Supplier<QueryShardContext> queryShardContext;

        Builder(String fieldName, Supplier<QueryShardContext> queryShardContext) {
            super(fieldName);
            this.queryShardContext = queryShardContext;
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.meta);
        }

        public PercolatorFieldMapper build(Mapper.BuilderContext context) {
            PercolatorFieldType fieldType = new PercolatorFieldType(this.buildFullName(context), (Map)this.meta.getValue());
            context.path().add(this.name());
            KeywordFieldMapper extractedTermsField = Builder.createExtractQueryFieldBuilder(PercolatorFieldMapper.EXTRACTED_TERMS_FIELD_NAME, context);
            fieldType.queryTermsField = extractedTermsField.fieldType();
            KeywordFieldMapper extractionResultField = Builder.createExtractQueryFieldBuilder(PercolatorFieldMapper.EXTRACTION_RESULT_FIELD_NAME, context);
            fieldType.extractionResultField = extractionResultField.fieldType();
            BinaryFieldMapper queryBuilderField = Builder.createQueryBuilderFieldBuilder(context);
            fieldType.queryBuilderField = queryBuilderField.fieldType();
            RangeFieldMapper rangeFieldMapper = Builder.createExtractedRangeFieldBuilder(PercolatorFieldMapper.RANGE_FIELD_NAME, RangeType.IP, context);
            fieldType.rangeField = rangeFieldMapper.fieldType();
            NumberFieldMapper minimumShouldMatchFieldMapper = Builder.createMinimumShouldMatchField(context);
            fieldType.minimumShouldMatchField = minimumShouldMatchFieldMapper.fieldType();
            fieldType.mapUnmappedFieldsAsText = Builder.getMapUnmappedFieldAsText(context.indexSettings());
            context.path().remove();
            return new PercolatorFieldMapper(this.name(), fieldType, this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), this.queryShardContext, extractedTermsField, extractionResultField, queryBuilderField, rangeFieldMapper, minimumShouldMatchFieldMapper, Builder.getMapUnmappedFieldAsText(context.indexSettings()));
        }

        private static boolean getMapUnmappedFieldAsText(Settings indexSettings) {
            return (Boolean)INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING.get(indexSettings);
        }

        static KeywordFieldMapper createExtractQueryFieldBuilder(String name, Mapper.BuilderContext context) {
            KeywordFieldMapper.Builder queryMetadataFieldBuilder = new KeywordFieldMapper.Builder(name);
            queryMetadataFieldBuilder.docValues(false);
            return queryMetadataFieldBuilder.build(context);
        }

        static BinaryFieldMapper createQueryBuilderFieldBuilder(Mapper.BuilderContext context) {
            BinaryFieldMapper.Builder builder = new BinaryFieldMapper.Builder(PercolatorFieldMapper.QUERY_BUILDER_FIELD_NAME, true);
            return builder.build(context);
        }

        static RangeFieldMapper createExtractedRangeFieldBuilder(String name, RangeType rangeType, Mapper.BuilderContext context) {
            RangeFieldMapper.Builder builder = new RangeFieldMapper.Builder(name, rangeType, true, PercolatorFieldMapper.hasIndexCreated((Settings)context.indexSettings()) ? context.indexCreatedVersion() : null);
            builder.docValues(false);
            return builder.build(context);
        }

        static NumberFieldMapper createMinimumShouldMatchField(Mapper.BuilderContext context) {
            NumberFieldMapper.Builder builder = NumberFieldMapper.Builder.docValuesOnly((String)PercolatorFieldMapper.MINIMUM_SHOULD_MATCH_FIELD_NAME, (NumberFieldMapper.NumberType)NumberFieldMapper.NumberType.INTEGER);
            return builder.build(context);
        }
    }
}

