/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.termvectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.single.shard.SingleShardRequest;
import org.opensearch.action.termvectors.TermVectorsRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class MultiTermVectorsShardRequest
extends SingleShardRequest<MultiTermVectorsShardRequest> {
    private int shardId;
    private String preference;
    List<Integer> locations;
    List<TermVectorsRequest> requests;

    MultiTermVectorsShardRequest(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.locations = new ArrayList<Integer>(size);
        this.requests = new ArrayList<TermVectorsRequest>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            this.requests.add(new TermVectorsRequest(in));
        }
        this.preference = in.readOptionalString();
    }

    MultiTermVectorsShardRequest(String index, int shardId) {
        super(index);
        this.shardId = shardId;
        this.locations = new ArrayList<Integer>();
        this.requests = new ArrayList<TermVectorsRequest>();
    }

    @Override
    public ActionRequestValidationException validate() {
        return super.validateNonNullIndex();
    }

    public int shardId() {
        return this.shardId;
    }

    public MultiTermVectorsShardRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public void add(int location, TermVectorsRequest request) {
        this.locations.add(location);
        this.requests.add(request);
    }

    @Override
    public String[] indices() {
        String[] indices = new String[this.requests.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.requests.get(i).index();
        }
        return indices;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i).intValue());
            this.requests.get(i).writeTo(out);
        }
        out.writeOptionalString(this.preference);
    }
}

