/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.Accountable;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.LeafFieldData;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;

public class BinaryDVLeafFieldData
implements LeafFieldData {
    private final LeafReader reader;
    private final String field;

    public BinaryDVLeafFieldData(LeafReader reader, String field) {
        this.reader = reader;
        this.field = field;
    }

    @Override
    public SortedBinaryDocValues getBytesValues() {
        try {
            BinaryDocValues values = DocValues.getBinary((LeafReader)this.reader, (String)this.field);
            return FieldData.singleton(values);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }

    public ScriptDocValues.Strings getScriptValues() {
        return new ScriptDocValues.Strings(this.getBytesValues());
    }

    public void close() {
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }
}

