/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugins;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ContextParser;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryParser;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionParser;
import org.opensearch.search.SearchExtBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationParsingFunction;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.opensearch.search.aggregations.pipeline.MovAvgModel;
import org.opensearch.search.aggregations.pipeline.PipelineAggregator;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.deciders.ConcurrentSearchRequestDecider;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.subphase.highlight.Highlighter;
import org.opensearch.search.query.QueryPhaseSearcher;
import org.opensearch.search.rescore.RescorerBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortParser;
import org.opensearch.search.suggest.Suggest;
import org.opensearch.search.suggest.SuggestionBuilder;
import org.opensearch.threadpool.ThreadPool;

public interface SearchPlugin {
    default public List<ScoreFunctionSpec<?>> getScoreFunctions() {
        return Collections.emptyList();
    }

    default public List<SignificanceHeuristicSpec<?>> getSignificanceHeuristics() {
        return Collections.emptyList();
    }

    default public List<SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>> getMovingAverageModels() {
        return Collections.emptyList();
    }

    default public List<FetchSubPhase> getFetchSubPhases(FetchPhaseConstructionContext context) {
        return Collections.emptyList();
    }

    default public List<SearchExtSpec<?>> getSearchExts() {
        return Collections.emptyList();
    }

    default public Map<String, Highlighter> getHighlighters() {
        return Collections.emptyMap();
    }

    @ExperimentalApi
    default public Optional<ConcurrentSearchRequestDecider.Factory> getConcurrentSearchRequestDeciderFactory() {
        return Optional.empty();
    }

    default public List<SuggesterSpec<?>> getSuggesters() {
        return Collections.emptyList();
    }

    default public List<QuerySpec<?>> getQueries() {
        return Collections.emptyList();
    }

    default public List<SortSpec<?>> getSorts() {
        return Collections.emptyList();
    }

    default public List<AggregationSpec> getAggregations() {
        return Collections.emptyList();
    }

    default public List<Consumer<ValuesSourceRegistry.Builder>> getAggregationExtentions() {
        return Collections.emptyList();
    }

    default public List<CompositeAggregationSpec> getCompositeAggregations() {
        return Collections.emptyList();
    }

    default public List<PipelineAggregationSpec> getPipelineAggregations() {
        return Collections.emptyList();
    }

    default public List<RescorerSpec<?>> getRescorers() {
        return Collections.emptyList();
    }

    default public Optional<QueryPhaseSearcher> getQueryPhaseSearcher() {
        return Optional.empty();
    }

    default public Optional<ExecutorServiceProvider> getIndexSearcherExecutorProvider() {
        return Optional.empty();
    }

    public static class FetchPhaseConstructionContext {
        private final Map<String, Highlighter> highlighters;

        public FetchPhaseConstructionContext(Map<String, Highlighter> highlighters) {
            this.highlighters = highlighters;
        }

        public Map<String, Highlighter> getHighlighters() {
            return this.highlighters;
        }
    }

    public static class SearchExtensionSpec<W extends NamedWriteable, P> {
        private final ParseField name;
        private final Writeable.Reader<? extends W> reader;
        private final P parser;

        public SearchExtensionSpec(ParseField name, Writeable.Reader<? extends W> reader, P parser) {
            this.name = name;
            this.reader = reader;
            this.parser = parser;
        }

        public SearchExtensionSpec(String name, Writeable.Reader<? extends W> reader, P parser) {
            this(new ParseField(name, new String[0]), reader, parser);
        }

        public ParseField getName() {
            return this.name;
        }

        public Writeable.Reader<? extends W> getReader() {
            return this.reader;
        }

        public P getParser() {
            return this.parser;
        }
    }

    public static class RescorerSpec<T extends RescorerBuilder<T>>
    extends SearchExtensionSpec<T, CheckedFunction<XContentParser, T, IOException>> {
        public RescorerSpec(ParseField name, Writeable.Reader<? extends T> reader, CheckedFunction<XContentParser, T, IOException> parser) {
            super(name, reader, parser);
        }

        public RescorerSpec(String name, Writeable.Reader<? extends T> reader, CheckedFunction<XContentParser, T, IOException> parser) {
            super(name, reader, parser);
        }
    }

    public static class SearchExtSpec<T extends SearchExtBuilder>
    extends SearchExtensionSpec<T, CheckedFunction<XContentParser, T, IOException>> {
        public SearchExtSpec(ParseField name, Writeable.Reader<? extends T> reader, CheckedFunction<XContentParser, T, IOException> parser) {
            super(name, reader, parser);
        }

        public SearchExtSpec(String name, Writeable.Reader<? extends T> reader, CheckedFunction<XContentParser, T, IOException> parser) {
            super(name, reader, parser);
        }
    }

    public static class PipelineAggregationSpec
    extends SearchExtensionSpec<PipelineAggregationBuilder, ContextParser<String, ? extends PipelineAggregationBuilder>> {
        private final Map<String, Writeable.Reader<? extends InternalAggregation>> resultReaders = new TreeMap<String, Writeable.Reader<? extends InternalAggregation>>();

        public PipelineAggregationSpec(ParseField name, Writeable.Reader<? extends PipelineAggregationBuilder> builderReader, ContextParser<String, ? extends PipelineAggregationBuilder> parser) {
            super(name, builderReader, parser);
        }

        public PipelineAggregationSpec(String name, Writeable.Reader<? extends PipelineAggregationBuilder> builderReader, ContextParser<String, ? extends PipelineAggregationBuilder> parser) {
            super(name, builderReader, parser);
        }

        @Deprecated
        public PipelineAggregationSpec(ParseField name, Writeable.Reader<? extends PipelineAggregationBuilder> builderReader, PipelineAggregator.Parser parser) {
            super(name, builderReader, (p, n) -> parser.parse((String)n, p));
        }

        @Deprecated
        public PipelineAggregationSpec(String name, Writeable.Reader<? extends PipelineAggregationBuilder> builderReader, PipelineAggregator.Parser parser) {
            super(name, builderReader, (p, n) -> parser.parse((String)n, p));
        }

        public PipelineAggregationSpec addResultReader(Writeable.Reader<? extends InternalAggregation> resultReader) {
            return this.addResultReader(this.getName().getPreferredName(), resultReader);
        }

        public PipelineAggregationSpec addResultReader(String writeableName, Writeable.Reader<? extends InternalAggregation> resultReader) {
            this.resultReaders.put(writeableName, resultReader);
            return this;
        }

        public Map<String, Writeable.Reader<? extends InternalAggregation>> getResultReaders() {
            return this.resultReaders;
        }
    }

    public static class CompositeAggregationSpec {
        private final Consumer<ValuesSourceRegistry.Builder> aggregatorRegistrar;
        private final Class<?> valueSourceBuilderClass;
        @Deprecated
        private Byte byteCode;
        private final CompositeAggregationParsingFunction parsingFunction;
        private final String aggregationType;
        private final Writeable.Reader<? extends CompositeValuesSourceBuilder<?>> reader;

        public CompositeAggregationSpec(Consumer<ValuesSourceRegistry.Builder> aggregatorRegistrar, Class<? extends CompositeValuesSourceBuilder<?>> valueSourceBuilderClass, Byte byteCode, Writeable.Reader<? extends CompositeValuesSourceBuilder<?>> reader, CompositeAggregationParsingFunction parsingFunction, String aggregationType) {
            this.aggregatorRegistrar = aggregatorRegistrar;
            this.valueSourceBuilderClass = valueSourceBuilderClass;
            this.byteCode = byteCode;
            this.parsingFunction = parsingFunction;
            this.aggregationType = aggregationType;
            this.reader = reader;
        }

        public Consumer<ValuesSourceRegistry.Builder> getAggregatorRegistrar() {
            return this.aggregatorRegistrar;
        }

        public Class<?> getValueSourceBuilderClass() {
            return this.valueSourceBuilderClass;
        }

        public Byte getByteCode() {
            return this.byteCode;
        }

        public CompositeAggregationParsingFunction getParsingFunction() {
            return this.parsingFunction;
        }

        public String getAggregationType() {
            return this.aggregationType;
        }

        public Writeable.Reader<? extends CompositeValuesSourceBuilder<?>> getReader() {
            return this.reader;
        }
    }

    public static class AggregationSpec
    extends SearchExtensionSpec<AggregationBuilder, ContextParser<String, ? extends AggregationBuilder>> {
        private final Map<String, Writeable.Reader<? extends InternalAggregation>> resultReaders = new TreeMap<String, Writeable.Reader<? extends InternalAggregation>>();
        private Consumer<ValuesSourceRegistry.Builder> aggregatorRegistrar;

        public <T extends AggregationBuilder> AggregationSpec(ParseField name, Writeable.Reader<T> reader, ContextParser<String, T> parser) {
            super(name, reader, parser);
        }

        public <T extends AggregationBuilder> AggregationSpec(String name, Writeable.Reader<T> reader, ContextParser<String, T> parser) {
            super(name, reader, parser);
        }

        @Deprecated
        public AggregationSpec(ParseField name, Writeable.Reader<? extends AggregationBuilder> reader, Aggregator.Parser parser) {
            super(name, reader, (p, aggName) -> parser.parse((String)aggName, p));
        }

        @Deprecated
        public AggregationSpec(String name, Writeable.Reader<? extends AggregationBuilder> reader, Aggregator.Parser parser) {
            super(name, reader, (p, aggName) -> parser.parse((String)aggName, p));
        }

        public AggregationSpec addResultReader(Writeable.Reader<? extends InternalAggregation> resultReader) {
            return this.addResultReader(this.getName().getPreferredName(), resultReader);
        }

        public AggregationSpec addResultReader(String writeableName, Writeable.Reader<? extends InternalAggregation> resultReader) {
            this.resultReaders.put(writeableName, resultReader);
            return this;
        }

        public Map<String, Writeable.Reader<? extends InternalAggregation>> getResultReaders() {
            return this.resultReaders;
        }

        public Consumer<ValuesSourceRegistry.Builder> getAggregatorRegistrar() {
            return this.aggregatorRegistrar;
        }

        public AggregationSpec setAggregatorRegistrar(Consumer<ValuesSourceRegistry.Builder> aggregatorRegistrar) {
            this.aggregatorRegistrar = aggregatorRegistrar;
            return this;
        }
    }

    public static class SortSpec<T extends SortBuilder<T>>
    extends SearchExtensionSpec<T, SortParser<T>> {
        public SortSpec(ParseField name, Writeable.Reader<T> reader, SortParser<T> parser) {
            super(name, reader, parser);
        }

        public SortSpec(String name, Writeable.Reader<T> reader, SortParser<T> parser) {
            super(name, reader, parser);
        }
    }

    public static class QuerySpec<T extends QueryBuilder>
    extends SearchExtensionSpec<T, QueryParser<T>> {
        public QuerySpec(ParseField name, Writeable.Reader<T> reader, QueryParser<T> parser) {
            super(name, reader, parser);
        }

        public QuerySpec(String name, Writeable.Reader<T> reader, QueryParser<T> parser) {
            super(name, reader, parser);
        }
    }

    public static class SuggesterSpec<T extends SuggestionBuilder<T>>
    extends SearchExtensionSpec<T, CheckedFunction<XContentParser, T, IOException>> {
        private Writeable.Reader<? extends Suggest.Suggestion> suggestionReader;

        public SuggesterSpec(ParseField name, Writeable.Reader<T> builderReader, CheckedFunction<XContentParser, T, IOException> builderParser, Writeable.Reader<? extends Suggest.Suggestion> suggestionReader) {
            super(name, builderReader, builderParser);
            this.setSuggestionReader(suggestionReader);
        }

        public SuggesterSpec(String name, Writeable.Reader<T> builderReader, CheckedFunction<XContentParser, T, IOException> builderParser, Writeable.Reader<? extends Suggest.Suggestion> suggestionReader) {
            super(name, builderReader, builderParser);
            this.setSuggestionReader(suggestionReader);
        }

        private void setSuggestionReader(Writeable.Reader<? extends Suggest.Suggestion> reader) {
            this.suggestionReader = reader;
        }

        public Writeable.Reader<? extends Suggest.Suggestion> getSuggestionReader() {
            return this.suggestionReader;
        }
    }

    public static class SignificanceHeuristicSpec<T extends SignificanceHeuristic>
    extends SearchExtensionSpec<T, BiFunction<XContentParser, Void, T>> {
        public SignificanceHeuristicSpec(ParseField name, Writeable.Reader<T> reader, BiFunction<XContentParser, Void, T> parser) {
            super(name, reader, parser);
        }

        public SignificanceHeuristicSpec(String name, Writeable.Reader<T> reader, BiFunction<XContentParser, Void, T> parser) {
            super(name, reader, parser);
        }
    }

    public static class ScoreFunctionSpec<T extends ScoreFunctionBuilder<T>>
    extends SearchExtensionSpec<T, ScoreFunctionParser<T>> {
        public ScoreFunctionSpec(ParseField name, Writeable.Reader<T> reader, ScoreFunctionParser<T> parser) {
            super(name, reader, parser);
        }

        public ScoreFunctionSpec(String name, Writeable.Reader<T> reader, ScoreFunctionParser<T> parser) {
            super(name, reader, parser);
        }
    }

    public static interface ExecutorServiceProvider {
        public ExecutorService getExecutor(ThreadPool var1);
    }
}

