/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntConsumer;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.search.SearchAction;
import org.opensearch.action.search.SearchContextId;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.Booleans;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestCancellableNodeClient;
import org.opensearch.rest.action.RestStatusToXContentListener;
import org.opensearch.search.Scroll;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.StoredFieldsContext;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.search.suggest.SuggestBuilder;
import org.opensearch.search.suggest.SuggestBuilders;
import org.opensearch.search.suggest.term.TermSuggestionBuilder;
import org.opensearch.transport.client.node.NodeClient;

public class RestSearchAction
extends BaseRestHandler {
    public static final String TOTAL_HITS_AS_INT_PARAM = "rest_total_hits_as_int";
    public static final String TYPED_KEYS_PARAM = "typed_keys";
    public static final String INCLUDE_NAMED_QUERIES_SCORE_PARAM = "include_named_queries_score";
    private static final Set<String> RESPONSE_PARAMS;

    @Override
    public String getName() {
        return "search_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_search"), new RestHandler.Route(RestRequest.Method.POST, "/_search"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_search"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_search")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchRequest searchRequest = new SearchRequest();
        IntConsumer setSize = size -> searchRequest.source().size(size);
        request.withContentOrSourceParamParserOrNull((CheckedConsumer<XContentParser, IOException>)((CheckedConsumer)parser -> RestSearchAction.parseSearchRequest(searchRequest, request, parser, client.getNamedWriteableRegistry(), setSize)));
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancelClient.execute(SearchAction.INSTANCE, searchRequest, new RestStatusToXContentListener((RestChannel)channel));
        };
    }

    public static void parseSearchRequest(SearchRequest searchRequest, RestRequest request, XContentParser requestContentParser, NamedWriteableRegistry namedWriteableRegistry, IntConsumer setSize) throws IOException {
        String searchType;
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        searchRequest.indices(Strings.splitStringByCommaToArray((String)request.param("index")));
        if (requestContentParser != null) {
            searchRequest.source().parseXContent(requestContentParser, true);
        }
        int batchedReduceSize = request.paramAsInt("batched_reduce_size", searchRequest.getBatchedReduceSize());
        searchRequest.setBatchedReduceSize(batchedReduceSize);
        if (request.hasParam("pre_filter_shard_size")) {
            searchRequest.setPreFilterShardSize(request.paramAsInt("pre_filter_shard_size", 128));
        }
        if (request.hasParam("max_concurrent_shard_requests")) {
            int maxConcurrentShardRequests = request.paramAsInt("max_concurrent_shard_requests", searchRequest.getMaxConcurrentShardRequests());
            searchRequest.setMaxConcurrentShardRequests(maxConcurrentShardRequests);
        }
        if (request.hasParam("allow_partial_search_results")) {
            searchRequest.allowPartialSearchResults(request.paramAsBoolean("allow_partial_search_results", null));
        }
        if (request.hasParam("phase_took")) {
            searchRequest.setPhaseTook(request.paramAsBoolean("phase_took", true));
        }
        if ("query_and_fetch".equals(searchType = request.param("search_type")) || "dfs_query_and_fetch".equals(searchType)) {
            throw new IllegalArgumentException("Unsupported search type [" + searchType + "]");
        }
        searchRequest.searchType(searchType);
        RestSearchAction.parseSearchSource(searchRequest.source(), request, setSize);
        searchRequest.requestCache(request.paramAsBoolean("request_cache", searchRequest.requestCache()));
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchRequest.scroll(new Scroll(TimeValue.parseTimeValue((String)scroll, null, (String)"scroll")));
        }
        searchRequest.routing(request.param("routing"));
        searchRequest.preference(request.param("preference"));
        searchRequest.indicesOptions(IndicesOptions.fromRequest(request, searchRequest.indicesOptions()));
        searchRequest.pipeline(request.param("search_pipeline", searchRequest.source().pipeline()));
        RestSearchAction.checkRestTotalHits(request, searchRequest);
        request.paramAsBoolean(INCLUDE_NAMED_QUERIES_SCORE_PARAM, false);
        if (searchRequest.pointInTimeBuilder() != null) {
            RestSearchAction.preparePointInTime(searchRequest, request, namedWriteableRegistry);
        } else {
            searchRequest.setCcsMinimizeRoundtrips(request.paramAsBoolean("ccs_minimize_roundtrips", searchRequest.isCcsMinimizeRoundtrips()));
        }
        searchRequest.setCancelAfterTimeInterval(request.paramAsTime("cancel_after_time_interval", null));
    }

    private static void parseSearchSource(SearchSourceBuilder searchSourceBuilder, RestRequest request, IntConsumer setSize) {
        String suggestField;
        String sStats;
        String sSorts;
        FetchSourceContext fetchSourceContext;
        String sDocValueFields;
        StoredFieldsContext storedFieldsContext;
        QueryBuilder queryBuilder = RestActions.urlParamsToQueryBuilder(request);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        if (request.hasParam("from")) {
            searchSourceBuilder.from(request.paramAsInt("from", 0));
        }
        if (request.hasParam("size")) {
            setSize.accept(request.paramAsInt("size", 10));
        }
        if (request.hasParam("explain")) {
            searchSourceBuilder.explain(request.paramAsBoolean("explain", null));
        }
        if (request.hasParam("version")) {
            searchSourceBuilder.version(request.paramAsBoolean("version", null));
        }
        if (request.hasParam("seq_no_primary_term")) {
            searchSourceBuilder.seqNoAndPrimaryTerm(request.paramAsBoolean("seq_no_primary_term", null));
        }
        if (request.hasParam("timeout")) {
            searchSourceBuilder.timeout(request.paramAsTime("timeout", null));
        }
        if (request.hasParam("verbose_pipeline")) {
            searchSourceBuilder.verbosePipeline(request.paramAsBoolean("verbose_pipeline", false));
        }
        if (request.hasParam("terminate_after")) {
            int terminateAfter = request.paramAsInt("terminate_after", 0);
            if (terminateAfter < 0) {
                throw new IllegalArgumentException("terminateAfter must be > 0");
            }
            if (terminateAfter > 0) {
                searchSourceBuilder.terminateAfter(terminateAfter);
            }
        }
        if ((storedFieldsContext = StoredFieldsContext.fromRestRequest(SearchSourceBuilder.STORED_FIELDS_FIELD.getPreferredName(), request)) != null) {
            searchSourceBuilder.storedFields(storedFieldsContext);
        }
        if ((sDocValueFields = request.param("docvalue_fields")) != null && Strings.hasText((String)sDocValueFields)) {
            String[] sFields;
            for (String field : sFields = Strings.splitStringByCommaToArray((String)sDocValueFields)) {
                searchSourceBuilder.docValueField(field, null);
            }
        }
        if ((fetchSourceContext = FetchSourceContext.parseFromRestRequest(request)) != null) {
            searchSourceBuilder.fetchSource(fetchSourceContext);
        }
        if (request.hasParam("track_scores")) {
            searchSourceBuilder.trackScores(request.paramAsBoolean("track_scores", false));
        }
        if (request.hasParam(INCLUDE_NAMED_QUERIES_SCORE_PARAM)) {
            searchSourceBuilder.includeNamedQueriesScores(request.paramAsBoolean(INCLUDE_NAMED_QUERIES_SCORE_PARAM, false));
        }
        if (request.hasParam("track_total_hits")) {
            if (Booleans.isBoolean((String)request.param("track_total_hits"))) {
                searchSourceBuilder.trackTotalHits(request.paramAsBoolean("track_total_hits", true));
            } else {
                searchSourceBuilder.trackTotalHitsUpTo(request.paramAsInt("track_total_hits", 10000));
            }
        }
        if ((sSorts = request.param("sort")) != null) {
            String[] sorts;
            for (String sort : sorts = Strings.splitStringByCommaToArray((String)sSorts)) {
                int delimiter = sort.lastIndexOf(":");
                if (delimiter != -1) {
                    String sortField = sort.substring(0, delimiter);
                    String reverse = sort.substring(delimiter + 1);
                    if ("asc".equals(reverse)) {
                        searchSourceBuilder.sort(sortField, SortOrder.ASC);
                        continue;
                    }
                    if (!"desc".equals(reverse)) continue;
                    searchSourceBuilder.sort(sortField, SortOrder.DESC);
                    continue;
                }
                searchSourceBuilder.sort(sort);
            }
        }
        if ((sStats = request.param("stats")) != null) {
            searchSourceBuilder.stats(Arrays.asList(Strings.splitStringByCommaToArray((String)sStats)));
        }
        if ((suggestField = request.param("suggest_field")) != null) {
            String suggestText = request.param("suggest_text", request.param("q"));
            int suggestSize = request.paramAsInt("suggest_size", 5);
            String suggestMode = request.param("suggest_mode");
            searchSourceBuilder.suggest(new SuggestBuilder().addSuggestion(suggestField, ((TermSuggestionBuilder)((TermSuggestionBuilder)SuggestBuilders.termSuggestion(suggestField).text(suggestText)).size(suggestSize)).suggestMode(TermSuggestionBuilder.SuggestMode.resolve(suggestMode))));
        }
    }

    static void preparePointInTime(SearchRequest request, RestRequest restRequest, NamedWriteableRegistry namedWriteableRegistry) {
        assert (request.pointInTimeBuilder() != null);
        ActionRequestValidationException validationException = null;
        if (request.indices().length > 0) {
            validationException = ValidateActions.addValidationError("[indices] cannot be used with point in time", validationException);
        }
        if (request.indicesOptions() != SearchRequest.DEFAULT_INDICES_OPTIONS) {
            validationException = ValidateActions.addValidationError("[indicesOptions] cannot be used with point in time", validationException);
        }
        if (request.routing() != null) {
            validationException = ValidateActions.addValidationError("[routing] cannot be used with point in time", validationException);
        }
        if (request.preference() != null) {
            validationException = ValidateActions.addValidationError("[preference] cannot be used with point in time", validationException);
        }
        if (restRequest.paramAsBoolean("ccs_minimize_roundtrips", false)) {
            validationException = ValidateActions.addValidationError("[ccs_minimize_roundtrips] cannot be used with point in time", validationException);
            request.setCcsMinimizeRoundtrips(false);
        }
        ExceptionsHelper.reThrowIfNotNull((Throwable)((Object)validationException));
        IndicesOptions indicesOptions = request.indicesOptions();
        IndicesOptions stricterIndicesOptions = IndicesOptions.fromOptions(indicesOptions.ignoreUnavailable(), indicesOptions.allowNoIndices(), false, false, false, true, true, indicesOptions.ignoreThrottled());
        request.indicesOptions(stricterIndicesOptions);
        SearchContextId searchContextId = SearchContextId.decode(namedWriteableRegistry, request.pointInTimeBuilder().getId());
        request.indices(searchContextId.getActualIndices());
    }

    public static void checkRestTotalHits(RestRequest restRequest, SearchRequest searchRequest) {
        Integer trackTotalHitsUpTo;
        boolean totalHitsAsInt = restRequest.paramAsBoolean(TOTAL_HITS_AS_INT_PARAM, false);
        if (!totalHitsAsInt) {
            return;
        }
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        if ((trackTotalHitsUpTo = searchRequest.source().trackTotalHitsUpTo()) == null) {
            searchRequest.source().trackTotalHits(true);
        } else if (trackTotalHitsUpTo != Integer.MAX_VALUE && trackTotalHitsUpTo != -1) {
            throw new IllegalArgumentException("[rest_total_hits_as_int] cannot be used if the tracking of total hits is not accurate, got " + trackTotalHitsUpTo);
        }
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    public boolean allowsUnsafeBuffers() {
        return true;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList(TYPED_KEYS_PARAM, TOTAL_HITS_AS_INT_PARAM, INCLUDE_NAMED_QUERIES_SCORE_PARAM));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

