/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.stats.ADStats;
import org.opensearch.ad.transport.StatsAnomalyDetectorAction;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.rest.RestStatsAction;
import org.opensearch.timeseries.transport.StatsRequest;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;
import org.opensearch.transport.client.node.NodeClient;

public class RestStatsAnomalyDetectorAction
extends RestStatsAction {
    private static final String STATS_ANOMALY_DETECTOR_ACTION = "stats_anomaly_detector";

    public RestStatsAnomalyDetectorAction(ADStats timeSeriesStats, DiscoveryNodeFilterer nodeFilter) {
        super(timeSeriesStats, nodeFilter);
    }

    public String getName() {
        return STATS_ANOMALY_DETECTOR_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        if (!ADEnabledSetting.isADEnabled()) {
            throw new IllegalStateException("AD functionality is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        StatsRequest adStatsRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)StatsAnomalyDetectorAction.INSTANCE, (ActionRequest)adStatsRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_anomaly_detection/{nodeId}/stats/", RestRequest.Method.GET, "/_opendistro/_anomaly_detection/{nodeId}/stats/"), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_anomaly_detection/{nodeId}/stats/{stat}", RestRequest.Method.GET, "/_opendistro/_anomaly_detection/{nodeId}/stats/{stat}"), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_anomaly_detection/stats/", RestRequest.Method.GET, "/_opendistro/_anomaly_detection/stats/"), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_anomaly_detection/stats/{stat}", RestRequest.Method.GET, "/_opendistro/_anomaly_detection/stats/{stat}"));
    }
}

