/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.ValidationException;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.forecast.transport.SuggestForecasterParamAction;
import org.opensearch.forecast.transport.SuggestName;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.transport.BaseSuggestConfigParamTransportAction;
import org.opensearch.timeseries.transport.SuggestConfigParamRequest;
import org.opensearch.timeseries.transport.SuggestConfigParamResponse;
import org.opensearch.timeseries.util.MultiResponsesDelegateActionListener;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class SuggestForecasterParamTransportAction
extends BaseSuggestConfigParamTransportAction {
    public static final Logger logger = LogManager.getLogger(SuggestForecasterParamTransportAction.class);

    @Inject
    public SuggestForecasterParamTransportAction(Client client, SecurityClientUtil clientUtil, ClusterService clusterService, Settings settings, ForecastIndexManagement anomalyDetectionIndices, ActionFilters actionFilters, TransportService transportService, SearchFeatureDao searchFeatureDao) {
        super(SuggestForecasterParamAction.NAME, client, clientUtil, clusterService, settings, actionFilters, transportService, ForecastSettings.FORECAST_FILTER_BY_BACKEND_ROLES, AnalysisType.FORECAST, searchFeatureDao);
    }

    @Override
    public void suggestExecute(SuggestConfigParamRequest request, User user, ThreadContext.StoredContext storedContext, ActionListener<SuggestConfigParamResponse> listener) {
        storedContext.restore();
        Set<SuggestName> params = this.getParametersToSuggest(request.getParam());
        if (params.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("The given suggest type doesn't exist");
            listener.onFailure((Exception)validationException);
            return;
        }
        Config config = request.getConfig();
        int responseSize = params.size();
        if (params.contains(SuggestName.HISTORY) && params.contains(SuggestName.INTERVAL)) {
            --responseSize;
        }
        MultiResponsesDelegateActionListener<SuggestConfigParamResponse> delegateListener = new MultiResponsesDelegateActionListener<SuggestConfigParamResponse>(listener, responseSize, CommonMessages.FAIL_SUGGEST_ERR_MSG, false);
        if (params.contains(SuggestName.HISTORY)) {
            this.suggestHistory(request.getConfig(), user, request.getRequestTimeout(), params.contains(SuggestName.INTERVAL), delegateListener);
        } else if (params.contains(SuggestName.INTERVAL)) {
            this.suggestInterval(request.getConfig(), user, request.getRequestTimeout(), (ActionListener<Pair<IntervalTimeConfiguration, Map<String, Object>>>)ActionListener.wrap(intervalEntity -> delegateListener.onResponse(new SuggestConfigParamResponse.Builder().interval((IntervalTimeConfiguration)intervalEntity.getLeft()).build()), delegateListener::onFailure));
        }
        if (params.contains(SuggestName.HORIZON)) {
            Forecaster forecaster = (Forecaster)config;
            delegateListener.onResponse(new SuggestConfigParamResponse.Builder().horizon(forecaster.suggestHorizon()).build());
        }
        if (params.contains(SuggestName.WINDOW_DELAY)) {
            this.suggestWindowDelay(request.getConfig(), user, request.getRequestTimeout(), delegateListener);
        }
    }
}

