"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.partitionDrilldownFocus = exports.partitionMultiGeometries = void 0;
var __1 = require("../../..");
var specs_1 = require("../../../../specs");
var create_selector_1 = require("../../../../state/create_selector");
var get_chart_container_dimensions_1 = require("../../../../state/selectors/get_chart_container_dimensions");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var utils_1 = require("../../../../state/utils");
var config_1 = require("../../layout/config");
var viewmodel_types_1 = require("../../layout/types/viewmodel_types");
var scenegraph_1 = require("../../layout/viewmodel/scenegraph");
var get_partition_specs_1 = require("./get_partition_specs");
var tree_1 = require("./tree");
var horizontalSplit = function (s) { return s === null || s === void 0 ? void 0 : s.splitHorizontally; };
var verticalSplit = function (s) { return s === null || s === void 0 ? void 0 : s.splitVertically; };
function getInterMarginSize(size, startMargin, endMargin) {
    return size * (1 - Math.min(1, startMargin + endMargin));
}
function bandwidth(range, bandCount, _a) {
    var outer = _a.outer, inner = _a.inner;
    return range / (2 * outer + bandCount + bandCount * inner - inner);
}
exports.partitionMultiGeometries = create_selector_1.createCustomCachedSelector([get_settings_specs_1.getSpecs, get_partition_specs_1.getPartitionSpecs, get_chart_container_dimensions_1.getChartContainerDimensionsSelector, tree_1.getTrees, get_chart_theme_1.getChartThemeSelector], function (specs, partitionSpecs, parentDimensions, trees, _a) {
    var background = _a.background;
    var smallMultiplesSpecs = utils_1.getSpecsFromStore(specs, __1.ChartType.Global, specs_1.SpecType.SmallMultiples);
    var outerSpecDirection = ['horizontal', 'vertical', 'zigzag'][0];
    var innerBreakdownDirection = horizontalSplit(smallMultiplesSpecs[0])
        ? 'horizontal'
        : verticalSplit(smallMultiplesSpecs[0])
            ? 'vertical'
            : 'zigzag';
    var marginedWidth = parentDimensions.width, marginedHeight = parentDimensions.height;
    var outerPanelCount = partitionSpecs.length;
    var zigzagColumnCount = Math.ceil(Math.sqrt(outerPanelCount));
    var zigzagRowCount = Math.ceil(outerPanelCount / zigzagColumnCount);
    var outerWidthRatio = outerSpecDirection === 'horizontal'
        ? 1 / outerPanelCount
        : outerSpecDirection === 'zigzag'
            ? 1 / zigzagColumnCount
            : 1;
    var outerHeightRatio = outerSpecDirection === 'vertical'
        ? 1 / outerPanelCount
        : outerSpecDirection === 'zigzag'
            ? 1 / zigzagRowCount
            : 1;
    var result = partitionSpecs.flatMap(function (spec, index) {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        var marginLeft = (_b = (_a = spec.config.margin) === null || _a === void 0 ? void 0 : _a.left) !== null && _b !== void 0 ? _b : config_1.config.margin.left;
        var marginRight = (_d = (_c = spec.config.margin) === null || _c === void 0 ? void 0 : _c.right) !== null && _d !== void 0 ? _d : config_1.config.margin.right;
        var chartWidth = getInterMarginSize(marginedWidth, marginLeft, marginRight);
        var marginTop = (_f = (_e = spec.config.margin) === null || _e === void 0 ? void 0 : _e.top) !== null && _f !== void 0 ? _f : config_1.config.margin.top;
        var marginBottom = (_h = (_g = spec.config.margin) === null || _g === void 0 ? void 0 : _g.bottom) !== null && _h !== void 0 ? _h : config_1.config.margin.bottom;
        var chartHeight = getInterMarginSize(marginedHeight, marginTop, marginBottom);
        return trees.map(function (_a, innerIndex, a) {
            var _b;
            var name = _a.name, smAccessorValue = _a.smAccessorValue, style = _a.style, t = _a.tree;
            var innerPanelCount = a.length;
            var outerPanelWidth = chartWidth * outerWidthRatio;
            var outerPanelHeight = chartHeight * outerHeightRatio;
            var outerPanelArea = outerPanelWidth * outerPanelHeight;
            var innerPanelTargetArea = outerPanelArea / innerPanelCount;
            var innerPanelTargetHeight = Math.sqrt(innerPanelTargetArea);
            var innerZigzagRowCountEstimate = Math.max(1, Math.floor(outerPanelHeight / innerPanelTargetHeight));
            var innerZigzagColumnCount = Math.ceil(a.length / innerZigzagRowCountEstimate);
            var innerZigzagRowCount = Math.ceil(a.length / innerZigzagColumnCount);
            var innerRowCount = innerBreakdownDirection === 'vertical'
                ? a.length
                : innerBreakdownDirection === 'zigzag'
                    ? innerZigzagRowCount
                    : 1;
            var innerColumnCount = innerBreakdownDirection === 'vertical'
                ? 1
                : innerBreakdownDirection === 'zigzag'
                    ? innerZigzagColumnCount
                    : a.length;
            var innerRowIndex = innerBreakdownDirection === 'vertical'
                ? innerIndex
                : innerBreakdownDirection === 'zigzag'
                    ? Math.floor(innerIndex / innerZigzagColumnCount)
                    : 0;
            var innerColumnIndex = innerBreakdownDirection === 'vertical'
                ? 0
                : innerBreakdownDirection === 'zigzag'
                    ? innerIndex % innerZigzagColumnCount
                    : innerIndex;
            var topOuterRatio = outerSpecDirection === 'vertical'
                ? index / outerPanelCount
                : outerSpecDirection === 'zigzag'
                    ? Math.floor(index / zigzagColumnCount) / zigzagRowCount
                    : 0;
            var topInnerRatio = outerHeightRatio *
                (innerBreakdownDirection === 'vertical'
                    ? innerIndex / a.length
                    : innerBreakdownDirection === 'zigzag'
                        ? Math.floor(innerIndex / innerZigzagColumnCount) / innerZigzagRowCount
                        : 0);
            var panelHeightRatio = outerHeightRatio *
                (innerBreakdownDirection === 'vertical'
                    ? 1 / a.length
                    : innerBreakdownDirection === 'zigzag'
                        ? 1 / innerZigzagRowCount
                        : 1);
            var leftOuterRatio = outerSpecDirection === 'horizontal'
                ? index / outerPanelCount
                : outerSpecDirection === 'zigzag'
                    ? (index % zigzagColumnCount) / zigzagColumnCount
                    : 0;
            var leftInnerRatio = outerWidthRatio *
                (innerBreakdownDirection === 'horizontal'
                    ? innerIndex / a.length
                    : innerBreakdownDirection === 'zigzag'
                        ? (innerIndex % innerZigzagColumnCount) / innerZigzagColumnCount
                        : 0);
            var panelWidthRatio = outerWidthRatio *
                (innerBreakdownDirection === 'horizontal'
                    ? 1 / a.length
                    : innerBreakdownDirection === 'zigzag'
                        ? 1 / innerZigzagColumnCount
                        : 1);
            var width = parentDimensions.width, height = parentDimensions.height;
            var innerWidth = getInterMarginSize(width, marginLeft, marginRight);
            var innerHeight = getInterMarginSize(height, marginTop, marginBottom);
            var panelInnerWidth = bandwidth(innerWidth, innerColumnCount, style.horizontalPanelPadding);
            var panelInnerHeight = bandwidth(innerHeight, innerRowCount, style.verticalPanelPadding);
            var marginLeftPx = width * marginLeft +
                panelInnerWidth * style.horizontalPanelPadding.outer +
                innerColumnIndex * (panelInnerWidth * (1 + style.horizontalPanelPadding.inner));
            var marginTopPx = height * marginTop +
                panelInnerHeight * style.verticalPanelPadding.outer +
                innerRowIndex * (panelInnerHeight * (1 + style.verticalPanelPadding.inner));
            return scenegraph_1.getShapeViewModel(spec, parentDimensions, t, background.color, style, {
                index: index,
                innerIndex: innerIndex,
                partitionLayout: (_b = spec.config.partitionLayout) !== null && _b !== void 0 ? _b : config_1.config.partitionLayout,
                panelTitle: String(name),
                smAccessorValue: smAccessorValue,
                top: topOuterRatio + topInnerRatio,
                height: panelHeightRatio,
                left: leftOuterRatio + leftInnerRatio,
                width: panelWidthRatio,
                innerRowCount: innerRowCount,
                innerColumnCount: innerColumnCount,
                innerRowIndex: innerRowIndex,
                innerColumnIndex: innerColumnIndex,
                marginLeftPx: marginLeftPx,
                marginTopPx: marginTopPx,
                panelInnerWidth: panelInnerWidth,
                panelInnerHeight: panelInnerHeight,
            });
        });
    });
    return result.length === 0 ? [viewmodel_types_1.nullShapeViewModel(config_1.config, { x: outerWidthRatio, y: outerHeightRatio })] : result;
});
function focusRect(quadViewModel, _a, drilldown) {
    var _b;
    var left = _a.left, width = _a.width;
    return drilldown.length === 0
        ? { x0: left, x1: left + width }
        : (_b = quadViewModel.find(function (_a) {
            var path = _a.path;
            return path.length === drilldown.length && path.every(function (_a, i) {
                var value = _a.value;
                return value === drilldown[i];
            });
        })) !== null && _b !== void 0 ? _b : { x0: left, x1: left + width };
}
exports.partitionDrilldownFocus = create_selector_1.createCustomCachedSelector([
    exports.partitionMultiGeometries,
    get_chart_container_dimensions_1.getChartContainerDimensionsSelector,
    function (state) { return state.interactions.drilldown; },
    function (state) { return state.interactions.prevDrilldown; },
], function (multiGeometries, chartDimensions, drilldown, prevDrilldown) {
    return multiGeometries.map(function (_a) {
        var quadViewModel = _a.quadViewModel, smAccessorValue = _a.smAccessorValue, index = _a.index, innerIndex = _a.innerIndex;
        var _b = focusRect(quadViewModel, chartDimensions, drilldown), currentFocusX0 = _b.x0, currentFocusX1 = _b.x1;
        var _c = focusRect(quadViewModel, chartDimensions, prevDrilldown), prevFocusX0 = _c.x0, prevFocusX1 = _c.x1;
        return { currentFocusX0: currentFocusX0, currentFocusX1: currentFocusX1, prevFocusX0: prevFocusX0, prevFocusX1: prevFocusX1, smAccessorValue: smAccessorValue, index: index, innerIndex: innerIndex };
    });
});
//# sourceMappingURL=geometries.js.map