/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import { prettyDuration } from '../pretty_duration';
import { OuiI18n } from '../../../i18n';
import { htmlIdGenerator } from '../../../../services';
import { OuiTitle } from '../../../title';
import { OuiLink } from '../../../link';
import { OuiHorizontalRule } from '../../../horizontal_rule';
var generateId = htmlIdGenerator();
export var OuiRecentlyUsed = function OuiRecentlyUsed(_ref) {
  var applyTime = _ref.applyTime,
      commonlyUsedRanges = _ref.commonlyUsedRanges,
      dateFormat = _ref.dateFormat,
      _ref$recentlyUsedRang = _ref.recentlyUsedRanges,
      recentlyUsedRanges = _ref$recentlyUsedRang === void 0 ? [] : _ref$recentlyUsedRang;
  var legendId = generateId();

  if (recentlyUsedRanges.length === 0) {
    return null;
  }

  var links = recentlyUsedRanges.map(function (_ref2) {
    var start = _ref2.start,
        end = _ref2.end;

    var applyRecentlyUsed = function applyRecentlyUsed() {
      applyTime({
        start: start,
        end: end
      });
    };

    return /*#__PURE__*/React.createElement("li", {
      className: "ouiQuickSelectPopover__sectionItem",
      key: "".concat(start, "-").concat(end)
    }, /*#__PURE__*/React.createElement(OuiLink, {
      onClick: applyRecentlyUsed
    }, prettyDuration(start, end, commonlyUsedRanges, dateFormat)));
  });
  return /*#__PURE__*/React.createElement("fieldset", null, /*#__PURE__*/React.createElement(OuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/React.createElement("legend", {
    id: legendId
  }, /*#__PURE__*/React.createElement(OuiI18n, {
    token: "ouiRecentlyUsed.legend",
    default: "Recently used date ranges"
  }))), /*#__PURE__*/React.createElement("div", {
    className: "ouiQuickSelectPopover__section"
  }, /*#__PURE__*/React.createElement("ul", null, links)), /*#__PURE__*/React.createElement(OuiHorizontalRule, {
    margin: "s"
  }));
};
OuiRecentlyUsed.propTypes = {
  applyTime: PropTypes.func.isRequired,
  commonlyUsedRanges: PropTypes.arrayOf(PropTypes.shape({
    end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
    label: PropTypes.string,
    start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
  }).isRequired).isRequired,
  dateFormat: PropTypes.string.isRequired,
  recentlyUsedRanges: PropTypes.arrayOf(PropTypes.shape({
    end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
    label: PropTypes.string,
    start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
  }).isRequired)
};
OuiRecentlyUsed.displayName = 'OuiRecentlyUsed';
/* OUI -> EUI Aliases: Build-Time */

/* OUI -> EUI Aliases: Build-Time */
export { EuiRecentlyUsed } from '../../../../eui_components/date_picker/super_date_picker/quick_select_popover/recently_used';