"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiLoadingChart", {
  enumerable: true,
  get: function get() {
    return _loading_chart.EuiLoadingChart;
  }
});
exports.OuiLoadingChart = exports.SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

var _loading_chart = require("../../eui_components/loading/loading_chart");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var sizeToClassNameMap = {
  m: 'ouiLoadingChart--medium',
  l: 'ouiLoadingChart--large',
  xl: 'ouiLoadingChart--xLarge'
};
var SIZES = (0, _common.keysOf)(sizeToClassNameMap);
exports.SIZES = SIZES;

var OuiLoadingChart = function OuiLoadingChart(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$mono = _ref.mono,
      mono = _ref$mono === void 0 ? false : _ref$mono,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["size", "mono", "className"]);
  var classes = (0, _classnames.default)('ouiLoadingChart', {
    'ouiLoadingChart--mono': mono
  }, className, sizeToClassNameMap[size]);
  return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({
    className: classes
  }, rest), /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiLoadingChart__bar"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiLoadingChart__bar"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiLoadingChart__bar"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiLoadingChart__bar"
  }));
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiLoadingChart = OuiLoadingChart;
OuiLoadingChart.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  size: _propTypes.default.oneOf(["m", "l", "xl"]),
  mono: _propTypes.default.bool
};
/* OUI -> EUI Aliases: Build-Time */