"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFilter = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _is_filter = require("./is_filter");

var _field_value_selection_filter = require("./field_value_selection_filter");

var _field_value_toggle_filter = require("./field_value_toggle_filter");

var _field_value_toggle_group_filter = require("./field_value_toggle_group_filter");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var createFilter = function createFilter(index, config, query, onChange) {
  var props = {
    index: index,
    query: query,
    onChange: onChange
  }; // We don't put `config` into `props` above because until we check
  // `config.type`, TS only knows that it's a `FilterConfig`, and that type
  // is used to define `props` as well. Once we've checked `config.type`
  // below, its type is narrowed correctly, hence we pass down `config`
  // separately.

  switch (config.type) {
    case 'is':
      return /*#__PURE__*/_react.default.createElement(_is_filter.IsFilter, (0, _extends2.default)({}, props, {
        config: config
      }));

    case 'field_value_selection':
      return /*#__PURE__*/_react.default.createElement(_field_value_selection_filter.FieldValueSelectionFilter, (0, _extends2.default)({}, props, {
        config: config
      }));

    case 'field_value_toggle':
      return /*#__PURE__*/_react.default.createElement(_field_value_toggle_filter.FieldValueToggleFilter, (0, _extends2.default)({}, props, {
        config: config
      }));

    case 'field_value_toggle_group':
      return /*#__PURE__*/_react.default.createElement(_field_value_toggle_group_filter.FieldValueToggleGroupFilter, (0, _extends2.default)({}, props, {
        config: config
      }));

    default:
      // @ts-ignore TS knows that we've checked `config.type` exhaustively
      throw new Error("Unknown search filter type [".concat(config.type, "]"));
  }
};

exports.createFilter = createFilter;