## API Report File for "opensearch-dashboards"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { Action } from 'history';
import { ApiResponse } from '@opensearch-project/opensearch/lib/Transport';
import Boom from '@hapi/boom';
import { ConfigPath } from '@osd/config';
import { EnvironmentMode } from '@osd/config';
import { EuiBreadcrumb } from '@elastic/eui';
import { EuiButtonEmptyProps } from '@elastic/eui';
import { EuiConfirmModalProps } from '@elastic/eui';
import { EuiGlobalToastListToast } from '@elastic/eui';
import { ExclusiveUnion } from '@elastic/eui';
import { History } from 'history';
import { Href } from 'history';
import { IconType } from '@elastic/eui';
import { OpenSearchDashboardsClient } from '@opensearch-project/opensearch/api/opensearch_dashboards';
import { Location } from 'history';
import { LocationDescriptorObject } from 'history';
import { Logger } from '@osd/logging';
import { LogMeta } from '@osd/logging';
import { MaybePromise } from '@osd/utility-types';
import { Observable } from 'rxjs';
import { OpenSearchDashboardsConfigType } from 'src/core/server/opensearch_dashboards_config';
import { PackageInfo } from '@osd/config';
import { Path } from 'history';
import { PublicMethodsOf } from '@osd/utility-types';
import { PublicUiSettingsParams as PublicUiSettingsParams_2 } from 'src/core/server/types';
import React from 'react';
import { RecursiveReadonly } from '@osd/utility-types';
import * as Rx from 'rxjs';
import { ShallowPromise } from '@osd/utility-types';
import { TransportRequestOptions } from '@opensearch-project/opensearch/lib/Transport';
import { TransportRequestParams } from '@opensearch-project/opensearch/lib/Transport';
import { TransportRequestPromise } from '@opensearch-project/opensearch/lib/Transport';
import { Type } from '@osd/config-schema';
import { TypeOf } from '@osd/config-schema';
import { UnregisterCallback } from 'history';
import { UserProvidedValues as UserProvidedValues_2 } from 'src/core/server/types';

// @internal (undocumented)
export function __osdBootstrap__(): Promise<void>;

// @public (undocumented)
export interface App<HistoryLocationState = unknown> {
    appRoute?: string;
    capabilities?: Partial<Capabilities>;
    category?: AppCategory;
    chromeless?: boolean;
    defaultPath?: string;
    euiIconType?: string;
    exactRoute?: boolean;
    icon?: string;
    id: string;
    mount: AppMount<HistoryLocationState> | AppMountDeprecated<HistoryLocationState>;
    navLinkStatus?: AppNavLinkStatus;
    order?: number;
    status?: AppStatus;
    title: string;
    tooltip?: string;
    updater$?: Observable<AppUpdater>;
}

// @public
export interface AppCategory {
    ariaLabel?: string;
    euiIconType?: string;
    id: string;
    label: string;
    order?: number;
}

// @public
export type AppLeaveAction = AppLeaveDefaultAction | AppLeaveConfirmAction;

// @public
export enum AppLeaveActionType {
    // (undocumented)
    confirm = "confirm",
    // (undocumented)
    default = "default"
}

// Warning: (ae-unresolved-link) The @link reference could not be resolved: The package "opensearch-dashboards" does not have an export "AppLeaveActionFactory"
//
// @public
export interface AppLeaveConfirmAction {
    // (undocumented)
    text: string;
    // (undocumented)
    title?: string;
    // (undocumented)
    type: AppLeaveActionType.confirm;
}

// Warning: (ae-unresolved-link) The @link reference could not be resolved: The package "opensearch-dashboards" does not have an export "AppLeaveActionFactory"
//
// @public
export interface AppLeaveDefaultAction {
    // (undocumented)
    type: AppLeaveActionType.default;
}

// Warning: (ae-forgotten-export) The symbol "AppLeaveActionFactory" needs to be exported by the entry point index.d.ts
//
// @public
export type AppLeaveHandler = (factory: AppLeaveActionFactory) => AppLeaveAction;

// @public (undocumented)
export interface ApplicationSetup {
    register<HistoryLocationState = unknown>(app: App<HistoryLocationState>): void;
    registerAppUpdater(appUpdater$: Observable<AppUpdater>): void;
    // @deprecated
    registerMountContext<T extends keyof AppMountContext>(contextName: T, provider: IContextProvider<AppMountDeprecated, T>): void;
}

// @public (undocumented)
export interface ApplicationStart {
    applications$: Observable<ReadonlyMap<string, PublicAppInfo>>;
    capabilities: RecursiveReadonly<Capabilities>;
    currentAppId$: Observable<string | undefined>;
    getUrlForApp(appId: string, options?: {
        path?: string;
        absolute?: boolean;
    }): string;
    navigateToApp(appId: string, options?: NavigateToAppOptions): Promise<void>;
    navigateToUrl(url: string): Promise<void>;
    // @deprecated
    registerMountContext<T extends keyof AppMountContext>(contextName: T, provider: IContextProvider<AppMountDeprecated, T>): void;
}

// @public
export type AppMount<HistoryLocationState = unknown> = (params: AppMountParameters<HistoryLocationState>) => AppUnmount | Promise<AppUnmount>;

// @public @deprecated
export interface AppMountContext {
    core: {
        application: Pick<ApplicationStart, 'capabilities' | 'navigateToApp'>;
        chrome: ChromeStart;
        docLinks: DocLinksStart;
        http: HttpStart;
        i18n: I18nStart;
        notifications: NotificationsStart;
        overlays: OverlayStart;
        savedObjects: SavedObjectsStart;
        uiSettings: IUiSettingsClient;
        injectedMetadata: {
            getInjectedVar: (name: string, defaultValue?: any) => unknown;
        };
    };
}

// @public @deprecated
export type AppMountDeprecated<HistoryLocationState = unknown> = (context: AppMountContext, params: AppMountParameters<HistoryLocationState>) => AppUnmount | Promise<AppUnmount>;

// @public (undocumented)
export interface AppMountParameters<HistoryLocationState = unknown> {
    // @deprecated
    appBasePath: string;
    element: HTMLElement;
    history: ScopedHistory<HistoryLocationState>;
    onAppLeave: (handler: AppLeaveHandler) => void;
    setHeaderActionMenu: (menuMount: MountPoint | undefined) => void;
}

// @public
export enum AppNavLinkStatus {
    default = 0,
    disabled = 2,
    hidden = 3,
    visible = 1
}

// @public
export enum AppStatus {
    accessible = 0,
    inaccessible = 1
}

// @public
export type AppUnmount = () => void;

// @public
export type AppUpdatableFields = Pick<App, 'status' | 'navLinkStatus' | 'tooltip' | 'defaultPath'>;

// @public
export type AppUpdater = (app: App) => Partial<AppUpdatableFields> | undefined;

// @public
export interface Capabilities {
    [key: string]: Record<string, boolean | Record<string, boolean>>;
    catalogue: Record<string, boolean>;
    management: {
        [sectionId: string]: Record<string, boolean>;
    };
    navLinks: Record<string, boolean>;
}

// @public (undocumented)
export interface ChromeBadge {
    // (undocumented)
    iconType?: IconType;
    // (undocumented)
    text: string;
    // (undocumented)
    tooltip: string;
}

// @public (undocumented)
export interface ChromeBrand {
    // (undocumented)
    logo?: string;
    // (undocumented)
    smallLogo?: string;
}

// @public (undocumented)
export type ChromeBreadcrumb = EuiBreadcrumb;

// @public
export interface ChromeDocTitle {
    change(newTitle: string | string[]): void;
    reset(): void;
}

// @public (undocumented)
export interface ChromeHelpExtension {
    appName: string;
    content?: (element: HTMLDivElement) => () => void;
    links?: ChromeHelpExtensionMenuLink[];
}

// @public (undocumented)
export type ChromeHelpExtensionMenuCustomLink = EuiButtonEmptyProps & {
    linkType: 'custom';
    content: React.ReactNode;
};

// @public (undocumented)
export type ChromeHelpExtensionMenuDiscussLink = EuiButtonEmptyProps & {
    linkType: 'discuss';
    href: string;
};

// @public (undocumented)
export type ChromeHelpExtensionMenuDocumentationLink = EuiButtonEmptyProps & {
    linkType: 'documentation';
    href: string;
};

// @public (undocumented)
export type ChromeHelpExtensionMenuGitHubLink = EuiButtonEmptyProps & {
    linkType: 'github';
    labels: string[];
    title?: string;
};

// @public (undocumented)
export type ChromeHelpExtensionMenuLink = ExclusiveUnion<ChromeHelpExtensionMenuGitHubLink, ExclusiveUnion<ChromeHelpExtensionMenuDiscussLink, ExclusiveUnion<ChromeHelpExtensionMenuDocumentationLink, ChromeHelpExtensionMenuCustomLink>>>;

// @public (undocumented)
export interface ChromeNavControl {
    // (undocumented)
    mount: MountPoint;
    // (undocumented)
    order?: number;
}

// @public
export interface ChromeNavControls {
    // @internal (undocumented)
    getCenter$(): Observable<ChromeNavControl[]>;
    // @internal (undocumented)
    getLeft$(): Observable<ChromeNavControl[]>;
    // @internal (undocumented)
    getRight$(): Observable<ChromeNavControl[]>;
    registerCenter(navControl: ChromeNavControl): void;
    registerLeft(navControl: ChromeNavControl): void;
    registerRight(navControl: ChromeNavControl): void;
}

// @public (undocumented)
export interface ChromeNavLink {
    readonly baseUrl: string;
    readonly category?: AppCategory;
    readonly disabled?: boolean;
    readonly euiIconType?: string;
    readonly hidden?: boolean;
    readonly href: string;
    readonly icon?: string;
    readonly id: string;
    readonly order?: number;
    readonly title: string;
    readonly tooltip?: string;
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: The package "opensearch-dashboards" does not have an export "AppBase"
    readonly url?: string;
}

// @public
export interface ChromeNavLinks {
    enableForcedAppSwitcherNavigation(): void;
    get(id: string): ChromeNavLink | undefined;
    getAll(): Array<Readonly<ChromeNavLink>>;
    getForceAppSwitcherNavigation$(): Observable<boolean>;
    getNavLinks$(): Observable<Array<Readonly<ChromeNavLink>>>;
    has(id: string): boolean;
    showOnly(id: string): void;
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: The package "opensearch-dashboards" does not have an export "AppBase"
    //
    // @deprecated
    update(id: string, values: ChromeNavLinkUpdateableFields): ChromeNavLink | undefined;
}

// @public (undocumented)
export type ChromeNavLinkUpdateableFields = Partial<Pick<ChromeNavLink, 'disabled' | 'hidden' | 'url' | 'href'>>;

// @public
export interface ChromeRecentlyAccessed {
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: No member was found with name "basePath"
    add(link: string, label: string, id: string): void;
    get$(): Observable<ChromeRecentlyAccessedHistoryItem[]>;
    get(): ChromeRecentlyAccessedHistoryItem[];
}

// @public (undocumented)
export interface ChromeRecentlyAccessedHistoryItem {
    // (undocumented)
    id: string;
    // (undocumented)
    label: string;
    // (undocumented)
    link: string;
}

// @public
export interface ChromeStart {
    addApplicationClass(className: string): void;
    docTitle: ChromeDocTitle;
    getApplicationClasses$(): Observable<string[]>;
    getBadge$(): Observable<ChromeBadge | undefined>;
    getBrand$(): Observable<ChromeBrand>;
    getBreadcrumbs$(): Observable<ChromeBreadcrumb[]>;
    getCustomNavLink$(): Observable<Partial<ChromeNavLink> | undefined>;
    getHelpExtension$(): Observable<ChromeHelpExtension | undefined>;
    getIsNavDrawerLocked$(): Observable<boolean>;
    getIsVisible$(): Observable<boolean>;
    navControls: ChromeNavControls;
    navLinks: ChromeNavLinks;
    recentlyAccessed: ChromeRecentlyAccessed;
    removeApplicationClass(className: string): void;
    setAppTitle(appTitle: string): void;
    setBadge(badge?: ChromeBadge): void;
    setBrand(brand: ChromeBrand): void;
    setBreadcrumbs(newBreadcrumbs: ChromeBreadcrumb[]): void;
    setCustomNavLink(newCustomNavLink?: Partial<ChromeNavLink>): void;
    setHelpExtension(helpExtension?: ChromeHelpExtension): void;
    setHelpSupportUrl(url: string): void;
    setIsVisible(isVisible: boolean): void;
}

// @public
export interface ContextSetup {
    createContextContainer<THandler extends HandlerFunction<any>>(): IContextContainer<THandler>;
}

// @internal (undocumented)
export interface CoreContext {
    // Warning: (ae-forgotten-export) The symbol "CoreId" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    coreId: CoreId;
    // (undocumented)
    env: {
        mode: Readonly<EnvironmentMode>;
        packageInfo: Readonly<PackageInfo>;
    };
}

// @public
export interface CoreSetup<TPluginsStart extends object = object, TStart = unknown> {
    // (undocumented)
    application: ApplicationSetup;
    // @deprecated (undocumented)
    context: ContextSetup;
    // (undocumented)
    fatalErrors: FatalErrorsSetup;
    // (undocumented)
    getStartServices: StartServicesAccessor<TPluginsStart, TStart>;
    // (undocumented)
    http: HttpSetup;
    // @deprecated
    injectedMetadata: {
        getInjectedVar: (name: string, defaultValue?: any) => unknown;
    };
    // (undocumented)
    notifications: NotificationsSetup;
    // (undocumented)
    uiSettings: IUiSettingsClient;
}

// @public
export interface CoreStart {
    // (undocumented)
    application: ApplicationStart;
    // (undocumented)
    chrome: ChromeStart;
    // (undocumented)
    docLinks: DocLinksStart;
    // (undocumented)
    fatalErrors: FatalErrorsStart;
    // (undocumented)
    http: HttpStart;
    // (undocumented)
    i18n: I18nStart;
    // @deprecated
    injectedMetadata: {
        getInjectedVar: (name: string, defaultValue?: any) => unknown;
    };
    // (undocumented)
    notifications: NotificationsStart;
    // (undocumented)
    overlays: OverlayStart;
    // (undocumented)
    savedObjects: SavedObjectsStart;
    // (undocumented)
    uiSettings: IUiSettingsClient;
}

// @internal
export class CoreSystem {
    // Warning: (ae-forgotten-export) The symbol "Params" needs to be exported by the entry point index.d.ts
    constructor(params: Params);
    // (undocumented)
    setup(): Promise<{
        fatalErrors: FatalErrorsSetup;
    } | undefined>;
    // (undocumented)
    start(): Promise<{
        application: InternalApplicationStart;
    } | undefined>;
    // (undocumented)
    stop(): void;
    }

// @internal (undocumented)
export const DEFAULT_APP_CATEGORIES: Record<string, AppCategory>;

// @public (undocumented)
export interface DocLinksStart {
    // (undocumented)
    readonly DOC_LINK_VERSION: string;
    readonly OPENSEARCH_WEBSITE_URL: string;
    // (undocumented)
    readonly links: {
        readonly opensearch: {
            readonly introduction: string;
            readonly installation: {
                readonly base: string;
                readonly compatibility: string;
                readonly docker: string;
                readonly dockerSecurity: string;
                readonly helm: string;
                readonly tar: string;
                readonly ansible: string;
                readonly settings: string;
                readonly plugins: string;
            };
            readonly configuration: string;
            readonly cluster: {
                readonly base: string;
                readonly naming: string;
                readonly set_attribute: string;
                readonly build_cluster: string;
                readonly config_host: string;
                readonly start: string;
                readonly config_shard: string;
                readonly setup_hot_arch: string;
            };
            readonly indexData: {
                readonly base: string;
                readonly naming: string;
                readonly read_data: string;
                readonly update_data: string;
                readonly delete_data: string;
            };
            readonly indexAlias: {
                readonly base: string;
                readonly create_alias: string;
                readonly add_remove_index: string;
                readonly manage_alias: string;
                readonly filtered_alias: string;
                readonly alias_option: string;
            };
            readonly dataStreams: string;
            readonly aggregations: {
                readonly base: string;
                readonly metric: {
                readonly base: string;
                readonly types: string;
                readonly sum: string;
                readonly cardinality: string;
                readonly value_count: string;
                readonly stats: string;
                readonly percentile: string;
                readonly geo_bound: string;
                readonly top_hits: string;
                readonly scripted_metric: string;
                };
                readonly bucket: {
                readonly base: string;
                readonly terms: string;
                readonly smapler: string;
                readonly significant_terms: string;
                readonly missing: string;
                readonly histogram: string;
                readonly range: string;
                readonly filter: string;
                readonly global: string;
                readonly geo: string;
                readonly adjacency_matrix: string;
                readonly nested: string;
                };
                readonly pipeline: {
                readonly base: string;
                readonly syntax: string;
                readonly types: string;
                readonly avg_bucket: string;
                readonly stats_bucket: string;
                readonly bucket_script: string;
                readonly bucket_sort: string;
                readonly cumulative_sum: string;
                readonly derivative: string;
                readonly moving_avg: string;
                readonly serial_diff: string;
                };
            };
            readonly indexTemplates: {
                readonly base: string;
                readonly composable: string;
                readonly options: string;
            };
            readonly reindexData: {
                readonly base: string;
                readonly all: string;
                readonly remote: string;
                readonly subset: string;
                readonly combine: string;
                readonly unique: string;
                readonly transform: string;
                readonly update: string;
                readonly source: string;
                readonly destination: string;
            };
            readonly queryDSL: {
                readonly base: string;
                readonly term: {
                readonly base: string;
                readonly terms: string;
                readonly ids: string;
                readonly range: string;
                readonly prefix: string;
                readonly exists: string;
                readonly wildcards: string;
                readonly regex: string;
                };
                readonly fullText: {
                readonly base: string;
                readonly match: string;
                readonly multi_match: string;
                readonly match_phrase: string;
                readonly common_terms: string;
                readonly query_string: string;
                readonly options: string;
                };
                readonly boolQuery: string;
            };
            readonly searchTemplate: {
                readonly base: string;
                readonly create: string;
                readonly execute: string;
                readonly advanced_operation: string;
                readonly multiple_search: string;
                readonly manage: string;
            };
            readonly searchExperience: {
                readonly base: string;
                readonly autocomplete: string;
                readonly paginate: string;
                readonly scroll: string;
                readonly sort: string;
                readonly highlight_match: string;
            };
            readonly logs: {
                readonly base: string;
                readonly application_log: string;
                readonly slow_log: string;
                readonly deprecation_log: string;
            };
            readonly snapshotRestore: {
                readonly base: string;
                readonly register: string;
                readonly take_snapshot: string;
                readonly restore_snapshot: string;
                readonly security_plugin: string;
            };
            readonly supportedUnits: string;
            readonly commonParameters: string;
            readonly popularAPI: string;
            readonly restAPI: {
                readonly base: string;
                readonly indexAPI: {
                    readonly base: string,
                    readonly create: string,
                    readonly exists: string,
                    readonly delete: string,
                    readonly get: string,
                    readonly close: string,
                },
            };
        };
        readonly opensearchDashboards: {
            readonly introduction: string;
            readonly installation: {
                readonly base: string;
                readonly docker: string;
                readonly tar: string;
                readonly helm: string;
                readonly tls: string;
                readonly plugins: string;
            };
            readonly mapTiles: string;
            readonly ganttCharts: string;
            readonly reporting: string;
            readonly notebooks: {
                readonly base: string;
                readonly notebook_tutorial: string;
                readonly paragraph_tutorial: string;
                readonly sample_notebook: string;
                readonly create_report: string;
            };
            readonly dql: {
                readonly base: string;
                readonly terms_query: string;
                readonly boolean_query: string;
                readonly date_query: string;
                readonly nested_query: string;
            };
            readonly browser: string;
        };
        readonly noDocumentation: {
            readonly auditbeat: string;
            readonly filebeat: string;
            readonly metricbeat: string;
            readonly heartbeat: string;
            readonly logstash: string;
            readonly functionbeat: string;
            readonly winlogbeat: string;
            readonly siem: string;
            readonly indexPatterns: {
                readonly loadingData: string;
                readonly introduction: string;
            };
            readonly scriptedFields: {
                readonly scriptFields: string;
                readonly scriptAggs: string;
                readonly painless: string;
                readonly painlessApi: string;
                readonly painlessSyntax: string;
                readonly luceneExpressions: string;
            };
            readonly management: Record<string, string>;
            readonly visualize: Record<string, string>;
            readonly addData: string;
            readonly vega: string;
            readonly dateMath: string;
            readonly savedObject: {
                readonly manageSavedObject: string;
            };
            readonly clusterAPI: {
                readonly clusterRoute: string;
                readonly clusterState: string;
                readonly clusterStats: string;
                readonly clusterPending: string;
            };
            readonly mappingTypes: string;
            readonly moduleScripting: string;
            readonly ingest: {
                readonly appendProcessor: string;
                readonly bytesProcessor: string;
                readonly ingestCircleProcessor: string;
                readonly csvProcessor: string;
                readonly convertProcessor: string;
                readonly dataProcessor: string;
                readonly dataIndexNamProcessor: string;
                readonly dissectProcessor: string;
                readonly dotExpandProcessor: string;
                readonly dropProcessor: string;
                readonly failProcessor: string;
                readonly foreachProcessor: string;
                readonly geoIPProcessor: string;
                readonly grokProcessor: string;
                readonly gusbProcessor: string;
                readonly htmlstripProcessor: string;
                readonly inferenceProcessor: string;
                readonly joinProcessor: string;
                readonly jsonProcessor: string;
                readonly kvProcessor: string;
                readonly lowecaseProcessor: string;
                readonly pipelineProcessor: string;
                readonly removeProcessor: string;
                readonly renameProcessor: string;
                readonly scriptProcessor: string;
                readonly setProcessor: string;
                readonly securityUserProcessor: string;
                readonly splitProcessor: string;
                readonly sortProcessor: string;
                readonly trimProcessor: string;
                readonly uppercaseProcessor: string;
                readonly urldecodeProcessor: string;
                readonly userAgentProcessor: string;
            };
            readonly indexAPI : {
                readonly indexAnalyze: string;
                readonly indexClearCache: string;
                readonly indexClone: string;
                readonly indexSynced: string;
                readonly indexFlush: string;
                readonly indexForceMerge: string;
                readonly indexSetting: string;
                readonly indexUpgrade: string;
                readonly indexUpdateSetting: string;
                readonly indexRecovery: string;
                readonly indexRefresh: string;
                readonly indexRollover: string;
                readonly indexSegment: string;
                readonly indexShardStore: string;
                readonly indexShrink: string;
                readonly indexSplit: string;
                readonly indexStats: string;
            };
            readonly nodes: {
                readonly info: string;
                readonly hotThreads: string;
                readonly reloadSecuritySetting: string;
                readonly nodeStats: string;
                readonly usage: string;
            };
            readonly reIndex: {
                readonly rethrottle: string;
            };
            readonly timelineDeprecation: string;
            readonly apmServer: string;
            readonly tutorial: {
                readonly loadDataTutorial: string;
                readonly visualizeTutorial: string;
            };
            readonly scroll: {
                readonly clear_scroll: string;
            };
            readonly documentAPI: {
                readonly delete_by_query: string;
                readonly multiTermVector: string;
                readonly termVector: string;
                readonly update_by_query_rethrottle: string;
            };
            readonly filed_caps: string;
            readonly painless_execute: string;
            readonly search: {
                readonly search : string;
                readonly searchRankEval: string;
                readonly searchShards: string;
                readonly searchFieldCap: string;
            };
            readonly snapshot: {          
                readonly deleteSnapshot: string;
                readonly deleteRepository: string;
                readonly cleanup: string;
                readonly veirfyRepository: string; 
            };
        };
    };
}

export { EnvironmentMode }

// @public
export interface ErrorToastOptions extends ToastOptions {
    title: string;
    toastMessage?: string;
}

// @public
export interface FatalErrorInfo {
    // (undocumented)
    message: string;
    // (undocumented)
    stack: string | undefined;
}

// @public
export interface FatalErrorsSetup {
    add: (error: string | Error, source?: string) => never;
    get$: () => Rx.Observable<FatalErrorInfo>;
}

// @public
export type FatalErrorsStart = FatalErrorsSetup;

// @public
export type HandlerContextType<T extends HandlerFunction<any>> = T extends HandlerFunction<infer U> ? U : never;

// @public
export type HandlerFunction<T extends object> = (context: T, ...args: any[]) => any;

// @public
export type HandlerParameters<T extends HandlerFunction<any>> = T extends (context: any, ...args: infer U) => any ? U : never;

// @internal (undocumented)
export class HttpFetchError extends Error implements IHttpFetchError {
    constructor(message: string, name: string, request: Request, response?: Response | undefined, body?: any);
    // (undocumented)
    readonly body?: any;
    // (undocumented)
    readonly name: string;
    // (undocumented)
    readonly req: Request;
    // (undocumented)
    readonly request: Request;
    // (undocumented)
    readonly res?: Response;
    // (undocumented)
    readonly response?: Response | undefined;
}

// @public
export interface HttpFetchOptions extends HttpRequestInit {
    asResponse?: boolean;
    asSystemRequest?: boolean;
    headers?: HttpHeadersInit;
    prependBasePath?: boolean;
    query?: HttpFetchQuery;
}

// @public
export interface HttpFetchOptionsWithPath extends HttpFetchOptions {
    // (undocumented)
    path: string;
}

// @public (undocumented)
export interface HttpFetchQuery {
    // (undocumented)
    [key: string]: string | number | boolean | undefined | Array<string | number | boolean | undefined>;
}

// @public
export interface HttpHandler {
    // (undocumented)
    <TResponseBody = any>(path: string, options: HttpFetchOptions & {
        asResponse: true;
    }): Promise<HttpResponse<TResponseBody>>;
    // (undocumented)
    <TResponseBody = any>(options: HttpFetchOptionsWithPath & {
        asResponse: true;
    }): Promise<HttpResponse<TResponseBody>>;
    // (undocumented)
    <TResponseBody = any>(path: string, options?: HttpFetchOptions): Promise<TResponseBody>;
    // (undocumented)
    <TResponseBody = any>(options: HttpFetchOptionsWithPath): Promise<TResponseBody>;
}

// @public
export interface HttpHeadersInit {
    // (undocumented)
    [name: string]: any;
}

// @public
export interface HttpInterceptor {
    request?(fetchOptions: Readonly<HttpFetchOptionsWithPath>, controller: IHttpInterceptController): MaybePromise<Partial<HttpFetchOptionsWithPath>> | void;
    requestError?(httpErrorRequest: HttpInterceptorRequestError, controller: IHttpInterceptController): MaybePromise<Partial<HttpFetchOptionsWithPath>> | void;
    response?(httpResponse: HttpResponse, controller: IHttpInterceptController): MaybePromise<IHttpResponseInterceptorOverrides> | void;
    responseError?(httpErrorResponse: HttpInterceptorResponseError, controller: IHttpInterceptController): MaybePromise<IHttpResponseInterceptorOverrides> | void;
}

// @public (undocumented)
export interface HttpInterceptorRequestError {
    // (undocumented)
    error: Error;
    // (undocumented)
    fetchOptions: Readonly<HttpFetchOptionsWithPath>;
}

// @public (undocumented)
export interface HttpInterceptorResponseError extends HttpResponse {
    // (undocumented)
    error: Error | IHttpFetchError;
    // (undocumented)
    request: Readonly<Request>;
}

// @public
export interface HttpRequestInit {
    body?: BodyInit | null;
    cache?: RequestCache;
    credentials?: RequestCredentials;
    // (undocumented)
    headers?: HttpHeadersInit;
    integrity?: string;
    keepalive?: boolean;
    method?: string;
    mode?: RequestMode;
    redirect?: RequestRedirect;
    referrer?: string;
    referrerPolicy?: ReferrerPolicy;
    signal?: AbortSignal | null;
    window?: null;
}

// @public (undocumented)
export interface HttpResponse<TResponseBody = any> {
    readonly body?: TResponseBody;
    readonly fetchOptions: Readonly<HttpFetchOptionsWithPath>;
    readonly request: Readonly<Request>;
    readonly response?: Readonly<Response>;
}

// @public (undocumented)
export interface HttpSetup {
    addLoadingCountSource(countSource$: Observable<number>): void;
    anonymousPaths: IAnonymousPaths;
    basePath: IBasePath;
    delete: HttpHandler;
    fetch: HttpHandler;
    get: HttpHandler;
    getLoadingCount$(): Observable<number>;
    head: HttpHandler;
    intercept(interceptor: HttpInterceptor): () => void;
    options: HttpHandler;
    patch: HttpHandler;
    post: HttpHandler;
    put: HttpHandler;
}

// @public
export type HttpStart = HttpSetup;

// @public
export interface I18nStart {
    Context: ({ children }: {
        children: React.ReactNode;
    }) => JSX.Element;
}

// Warning: (ae-missing-release-tag) "IAnonymousPaths" is exported by the package, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public
export interface IAnonymousPaths {
    isAnonymous(path: string): boolean;
    register(path: string): void;
}

// @public
export interface IBasePath {
    get: () => string;
    prepend: (url: string) => string;
    remove: (url: string) => string;
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: The package "opensearch-dashboards" does not have an export "BasePath"
    readonly serverBasePath: string;
}

// @public
export interface IContextContainer<THandler extends HandlerFunction<any>> {
    createHandler(pluginOpaqueId: PluginOpaqueId, handler: THandler): (...rest: HandlerParameters<THandler>) => ShallowPromise<ReturnType<THandler>>;
    registerContext<TContextName extends keyof HandlerContextType<THandler>>(pluginOpaqueId: PluginOpaqueId, contextName: TContextName, provider: IContextProvider<THandler, TContextName>): this;
}

// Warning: (ae-forgotten-export) The symbol "PartialExceptFor" needs to be exported by the entry point index.d.ts
//
// @public
export type IContextProvider<THandler extends HandlerFunction<any>, TContextName extends keyof HandlerContextType<THandler>> = (context: PartialExceptFor<HandlerContextType<THandler>, 'core'>, ...rest: HandlerParameters<THandler>) => Promise<HandlerContextType<THandler>[TContextName]> | HandlerContextType<THandler>[TContextName];

// @public (undocumented)
export interface IHttpFetchError extends Error {
    // (undocumented)
    readonly body?: any;
    // (undocumented)
    readonly name: string;
    // @deprecated (undocumented)
    readonly req: Request;
    // (undocumented)
    readonly request: Request;
    // @deprecated (undocumented)
    readonly res?: Response;
    // (undocumented)
    readonly response?: Response;
}

// @public
export interface IHttpInterceptController {
    halt(): void;
    halted: boolean;
}

// @public
export interface IHttpResponseInterceptorOverrides<TResponseBody = any> {
    readonly body?: TResponseBody;
    readonly response?: Readonly<Response>;
}

// @public (undocumented)
export interface ImageValidation {
    // (undocumented)
    maxSize: {
        length: number;
        description: string;
    };
}

// @public
export type IToasts = Pick<ToastsApi, 'get$' | 'add' | 'remove' | 'addSuccess' | 'addWarning' | 'addDanger' | 'addError' | 'addInfo'>;

// @public
export interface IUiSettingsClient {
    get$: <T = any>(key: string, defaultOverride?: T) => Observable<T>;
    get: <T = any>(key: string, defaultOverride?: T) => T;
    getAll: () => Readonly<Record<string, PublicUiSettingsParams_2 & UserProvidedValues_2>>;
    getSaved$: <T = any>() => Observable<{
        key: string;
        newValue: T;
        oldValue: T;
    }>;
    getUpdate$: <T = any>() => Observable<{
        key: string;
        newValue: T;
        oldValue: T;
    }>;
    getUpdateErrors$: () => Observable<Error>;
    isCustom: (key: string) => boolean;
    isDeclared: (key: string) => boolean;
    isDefault: (key: string) => boolean;
    isOverridden: (key: string) => boolean;
    overrideLocalDefault: (key: string, newDefault: any) => void;
    remove: (key: string) => Promise<boolean>;
    set: (key: string, value: any) => Promise<boolean>;
}

// @public
export type MountPoint<T extends HTMLElement = HTMLElement> = (element: T) => UnmountCallback;

// Warning: (ae-missing-release-tag) "NavigateToAppOptions" is exported by the package, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public
export interface NavigateToAppOptions {
    path?: string;
    replace?: boolean;
    state?: unknown;
}

// Warning: (ae-missing-release-tag) "NavType" is exported by the package, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public (undocumented)
export type NavType = 'modern' | 'legacy';

// @public (undocumented)
export interface NotificationsSetup {
    // (undocumented)
    toasts: ToastsSetup;
}

// @public (undocumented)
export interface NotificationsStart {
    // (undocumented)
    toasts: ToastsStart;
}

// @public (undocumented)
export interface OverlayBannersStart {
    add(mount: MountPoint, priority?: number): string;
    // Warning: (ae-forgotten-export) The symbol "OverlayBanner" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    get$(): Observable<OverlayBanner[]>;
    // (undocumented)
    getComponent(): JSX.Element;
    remove(id: string): boolean;
    replace(id: string | undefined, mount: MountPoint, priority?: number): string;
}

// @public
export interface OverlayRef {
    close(): Promise<void>;
    onClose: Promise<void>;
}

// @public (undocumented)
export interface OverlayStart {
    // (undocumented)
    banners: OverlayBannersStart;
    // (undocumented)
    openConfirm: OverlayModalStart['openConfirm'];
    // Warning: (ae-forgotten-export) The symbol "OverlayFlyoutStart" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    openFlyout: OverlayFlyoutStart['open'];
    // Warning: (ae-forgotten-export) The symbol "OverlayModalStart" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    openModal: OverlayModalStart['open'];
    // (undocumented)
    sidecar: OverlaySidecarStart;
}

export { PackageInfo }

// @public
export interface Plugin<TSetup = void, TStart = void, TPluginsSetup extends object = object, TPluginsStart extends object = object> {
    // (undocumented)
    setup(core: CoreSetup<TPluginsStart, TStart>, plugins: TPluginsSetup): TSetup | Promise<TSetup>;
    // (undocumented)
    start(core: CoreStart, plugins: TPluginsStart): TStart | Promise<TStart>;
    // (undocumented)
    stop?(): void;
}

// @public
export type PluginInitializer<TSetup, TStart, TPluginsSetup extends object = object, TPluginsStart extends object = object> = (core: PluginInitializerContext) => Plugin<TSetup, TStart, TPluginsSetup, TPluginsStart>;

// @public
export interface PluginInitializerContext<ConfigSchema extends object = object> {
    // (undocumented)
    readonly config: {
        get: <T extends object = ConfigSchema>() => T;
    };
    // (undocumented)
    readonly env: {
        mode: Readonly<EnvironmentMode>;
        packageInfo: Readonly<PackageInfo>;
    };
    readonly opaqueId: PluginOpaqueId;
}

// @public (undocumented)
export type PluginOpaqueId = symbol;

// @public
export type PublicAppInfo = Omit<App, 'mount' | 'updater$'> & {
    status: AppStatus;
    navLinkStatus: AppNavLinkStatus;
    appRoute: string;
};

// @public
export type PublicUiSettingsParams = Omit<UiSettingsParams, 'schema'>;

// Warning: (ae-missing-release-tag) "SavedObject" is exported by the package, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public (undocumented)
export interface SavedObject<T = unknown> {
    attributes: T;
    // (undocumented)
    error?: SavedObjectError;
    id: string;
    migrationVersion?: SavedObjectsMigrationVersion;
    namespaces?: string[];
    originId?: string;
    references: SavedObjectReference[];
    type: string;
    updated_at?: string;
    version?: string;
}

// @public
export type SavedObjectAttribute = SavedObjectAttributeSingle | SavedObjectAttributeSingle[];

// @public
export interface SavedObjectAttributes {
    // (undocumented)
    [key: string]: SavedObjectAttribute;
}

// @public
export type SavedObjectAttributeSingle = string | number | boolean | null | undefined | SavedObjectAttributes;

// Warning: (ae-missing-release-tag) "SavedObjectError" is exported by the package, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public (undocumented)
export interface SavedObjectError {
    // (undocumented)
    error: string;
    // (undocumented)
    message: string;
    // (undocumented)
    metadata?: Record<string, unknown>;
    // (undocumented)
    statusCode: number;
}

// @public
export interface SavedObjectReference {
    // (undocumented)
    id: string;
    // (undocumented)
    name: string;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface SavedObjectsBaseOptions {
    namespace?: string;
}

// @public (undocumented)
export interface SavedObjectsBatchResponse<T = unknown> {
    // (undocumented)
    savedObjects: Array<SimpleSavedObject<T>>;
}

// @public (undocumented)
export interface SavedObjectsBulkCreateObject<T = unknown> extends SavedObjectsCreateOptions {
    // (undocumented)
    attributes: T;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface SavedObjectsBulkCreateOptions {
    overwrite?: boolean;
}

// @public (undocumented)
export interface SavedObjectsBulkUpdateObject<T = unknown> {
    // (undocumented)
    attributes: T;
    // (undocumented)
    id: string;
    // (undocumented)
    references?: SavedObjectReference[];
    // (undocumented)
    type: string;
    // (undocumented)
    version?: string;
}

// @public (undocumented)
export interface SavedObjectsBulkUpdateOptions {
    // (undocumented)
    namespace?: string;
}

// @public
export class SavedObjectsClient {
    // @internal
    constructor(http: HttpSetup);
    bulkCreate: (objects?: SavedObjectsBulkCreateObject[], options?: SavedObjectsBulkCreateOptions) => Promise<SavedObjectsBatchResponse<unknown>>;
    bulkGet: (objects?: Array<{
        id: string;
        type: string;
    }>) => Promise<SavedObjectsBatchResponse<unknown>>;
    bulkUpdate<T = unknown>(objects?: SavedObjectsBulkUpdateObject[]): Promise<SavedObjectsBatchResponse<unknown>>;
    create: <T = unknown>(type: string, attributes: T, options?: SavedObjectsCreateOptions) => Promise<SimpleSavedObject<T>>;
    // Warning: (ae-forgotten-export) The symbol "SavedObjectsDeleteOptions" needs to be exported by the entry point index.d.ts
    // Warning: (ae-forgotten-export) The symbol "SavedObjectsClientContract" needs to be exported by the entry point index.d.ts
    delete: (type: string, id: string, options?: SavedObjectsDeleteOptions | undefined) => ReturnType<SavedObjectsClientContract_2['delete']>;
    // Warning: (ae-forgotten-export) The symbol "SavedObjectsFindOptions" needs to be exported by the entry point index.d.ts
    find: <T = unknown>(options: SavedObjectsFindOptions_2) => Promise<SavedObjectsFindResponsePublic<T>>;
    get: <T = unknown>(type: string, id: string) => Promise<SimpleSavedObject<T>>;
    update<T = unknown>(type: string, id: string, attributes: T, { version, migrationVersion, references }?: SavedObjectsUpdateOptions): Promise<SimpleSavedObject<T>>;
}

// @public
export type SavedObjectsClientContract = PublicMethodsOf<SavedObjectsClient>;

// @public (undocumented)
export interface SavedObjectsCreateOptions {
    id?: string;
    migrationVersion?: SavedObjectsMigrationVersion;
    overwrite?: boolean;
    // (undocumented)
    references?: SavedObjectReference[];
}

// @public (undocumented)
export interface SavedObjectsFindOptions {
    // (undocumented)
    defaultSearchOperator?: 'AND' | 'OR';
    fields?: string[];
    // Warning: (ae-forgotten-export) The symbol "KueryNode" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    filter?: string | KueryNode;
    // (undocumented)
    hasReference?: {
        type: string;
        id: string;
    };
    // (undocumented)
    namespaces?: string[];
    // (undocumented)
    page?: number;
    // (undocumented)
    perPage?: number;
    preference?: string;
    rootSearchFields?: string[];
    search?: string;
    searchFields?: string[];
    // (undocumented)
    sortField?: string;
    // (undocumented)
    sortOrder?: string;
    // (undocumented)
    type: string | string[];
    typeToNamespacesMap?: Map<string, string[] | undefined>;
}

// @public
export interface SavedObjectsFindResponsePublic<T = unknown> extends SavedObjectsBatchResponse<T> {
    // (undocumented)
    page: number;
    // (undocumented)
    perPage: number;
    // (undocumented)
    total: number;
}

// @public
export interface SavedObjectsImportAmbiguousConflictError {
    // (undocumented)
    destinations: Array<{
        id: string;
        title?: string;
        updatedAt?: string;
    }>;
    // (undocumented)
    type: 'ambiguous_conflict';
}

// @public
export interface SavedObjectsImportConflictError {
    // (undocumented)
    destinationId?: string;
    // (undocumented)
    type: 'conflict';
}

// @public
export interface SavedObjectsImportError {
    // (undocumented)
    error: SavedObjectsImportConflictError | SavedObjectsImportAmbiguousConflictError | SavedObjectsImportUnsupportedTypeError | SavedObjectsImportMissingReferencesError | SavedObjectsImportUnknownError;
    // (undocumented)
    id: string;
    // (undocumented)
    meta: {
        title?: string;
        icon?: string;
    };
    overwrite?: boolean;
    // @deprecated (undocumented)
    title?: string;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectsImportMissingReferencesError {
    // (undocumented)
    references: Array<{
        type: string;
        id: string;
    }>;
    // (undocumented)
    type: 'missing_references';
}

// @public
export interface SavedObjectsImportResponse {
    // (undocumented)
    errors?: SavedObjectsImportError[];
    // (undocumented)
    success: boolean;
    // (undocumented)
    successCount: number;
    // (undocumented)
    successResults?: SavedObjectsImportSuccess[];
}

// @public
export interface SavedObjectsImportRetry {
    createNewCopy?: boolean;
    destinationId?: string;
    // (undocumented)
    id: string;
    ignoreMissingReferences?: boolean;
    // (undocumented)
    overwrite: boolean;
    // (undocumented)
    replaceReferences: Array<{
        type: string;
        from: string;
        to: string;
    }>;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectsImportSuccess {
    // @deprecated (undocumented)
    createNewCopy?: boolean;
    destinationId?: string;
    // (undocumented)
    id: string;
    // (undocumented)
    meta: {
        title?: string;
        icon?: string;
    };
    overwrite?: boolean;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectsImportUnknownError {
    // (undocumented)
    message: string;
    // (undocumented)
    statusCode: number;
    // (undocumented)
    type: 'unknown';
}

// @public
export interface SavedObjectsImportUnsupportedTypeError {
    // (undocumented)
    type: 'unsupported_type';
}

// @public
export interface SavedObjectsMigrationVersion {
    // (undocumented)
    [pluginName: string]: string;
}

// @public
export type SavedObjectsNamespaceType = 'single' | 'multiple' | 'agnostic';

// @public (undocumented)
export interface SavedObjectsStart {
    // (undocumented)
    client: SavedObjectsClientContract;
}

// @public (undocumented)
export interface SavedObjectsUpdateOptions {
    migrationVersion?: SavedObjectsMigrationVersion;
    // (undocumented)
    references?: SavedObjectReference[];
    // (undocumented)
    version?: string;
}

// @public
export class ScopedHistory<HistoryLocationState = unknown> implements History<HistoryLocationState> {
    constructor(parentHistory: History, basePath: string);
    get action(): Action;
    block: (prompt?: string | boolean | History.TransitionPromptHook<HistoryLocationState> | undefined) => UnregisterCallback;
    createHref: (location: LocationDescriptorObject<HistoryLocationState>, { prependBasePath }?: {
        prependBasePath?: boolean | undefined;
    }) => Href;
    createSubHistory: <SubHistoryLocationState = unknown>(basePath: string) => ScopedHistory<SubHistoryLocationState>;
    go: (n: number) => void;
    goBack: () => void;
    goForward: () => void;
    get length(): number;
    listen: (listener: (location: Location<HistoryLocationState>, action: Action) => void) => UnregisterCallback;
    get location(): Location<HistoryLocationState>;
    push: (pathOrLocation: Path | LocationDescriptorObject<HistoryLocationState>, state?: HistoryLocationState | undefined) => void;
    replace: (pathOrLocation: Path | LocationDescriptorObject<HistoryLocationState>, state?: HistoryLocationState | undefined) => void;
    }

// @public
export class SimpleSavedObject<T = unknown> {
    constructor(client: SavedObjectsClientContract, { id, type, version, attributes, error, references, migrationVersion }: SavedObject<T>);
    // (undocumented)
    attributes: T;
    // (undocumented)
    delete(): Promise<{}>;
    // (undocumented)
    error: SavedObject<T>['error'];
    // (undocumented)
    get(key: string): any;
    // (undocumented)
    has(key: string): boolean;
    // (undocumented)
    id: SavedObject<T>['id'];
    // (undocumented)
    migrationVersion: SavedObject<T>['migrationVersion'];
    // (undocumented)
    references: SavedObject<T>['references'];
    // (undocumented)
    save(): Promise<SimpleSavedObject<T>>;
    // (undocumented)
    set(key: string, value: any): T;
    // (undocumented)
    type: SavedObject<T>['type'];
    // (undocumented)
    _version?: SavedObject<T>['version'];
}

// @public
export type StartServicesAccessor<TPluginsStart extends object = object, TStart = unknown> = () => Promise<[CoreStart, TPluginsStart, TStart]>;

// @public
export type StringValidation = StringValidationRegex | StringValidationRegexString;

// @public
export interface StringValidationRegex {
    // (undocumented)
    message: string;
    // (undocumented)
    regex: RegExp;
}

// @public
export interface StringValidationRegexString {
    // (undocumented)
    message: string;
    // (undocumented)
    regexString: string;
}

// Warning: (ae-missing-release-tag) "Toast" is exported by the package, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public (undocumented)
export type Toast = ToastInputFields & {
    id: string;
};

// @public
export type ToastInput = string | ToastInputFields;

// @public
export type ToastInputFields = Pick<EuiGlobalToastListToast, Exclude<keyof EuiGlobalToastListToast, 'id' | 'text' | 'title'>> & {
    title?: string | MountPoint;
    text?: string | MountPoint;
};

// @public
export interface ToastOptions {
    toastLifeTimeMs?: number;
}

// @public
export class ToastsApi implements IToasts {
    constructor(deps: {
        uiSettings: IUiSettingsClient;
    });
    add(toastOrTitle: ToastInput): Toast;
    addDanger(toastOrTitle: ToastInput, options?: ToastOptions): Toast;
    addError(error: Error, options: ErrorToastOptions): Toast;
    addInfo(toastOrTitle: ToastInput, options?: ToastOptions): Toast;
    addSuccess(toastOrTitle: ToastInput, options?: ToastOptions): Toast;
    addWarning(toastOrTitle: ToastInput, options?: ToastOptions): Toast;
    get$(): Rx.Observable<Toast[]>;
    remove(toastOrId: Toast | string): void;
    // @internal (undocumented)
    start({ overlays, i18n }: {
        overlays: OverlayStart;
        i18n: I18nStart;
    }): void;
    }

// @public (undocumented)
export type ToastsSetup = IToasts;

// @public (undocumented)
export type ToastsStart = IToasts;

// @public
export interface UiSettingsParams<T = unknown> {
    category?: string[];
    // Warning: (ae-forgotten-export) The symbol "DeprecationSettings" needs to be exported by the entry point index.d.ts
    deprecation?: DeprecationSettings;
    description?: string;
    name?: string;
    optionLabels?: Record<string, string>;
    options?: string[];
    readonly?: boolean;
    requiresPageReload?: boolean;
    // (undocumented)
    schema: Type<T>;
    type?: UiSettingsType;
    // (undocumented)
    validation?: ImageValidation | StringValidation;
    value?: T;
}

// @public (undocumented)
export interface UiSettingsState {
    // (undocumented)
    [key: string]: PublicUiSettingsParams_2 & UserProvidedValues_2;
}

// @public
export type UiSettingsType = 'undefined' | 'json' | 'markdown' | 'number' | 'select' | 'boolean' | 'string' | 'array' | 'image';

// @public
export type UnmountCallback = () => void;

// @public
export const URL_MAX_LENGTH: number;

// @public
export interface UserProvidedValues<T = any> {
    // (undocumented)
    isOverridden?: boolean;
    // (undocumented)
    userValue?: T;
}


// Warnings were encountered during analysis:
//
// src/core/public/core_system.ts:185:21 - (ae-forgotten-export) The symbol "InternalApplicationStart" needs to be exported by the entry point index.d.ts

```
