"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataImporterPlugin = void 0;
var _operators = require("rxjs/operators");
var _import_file = require("./routes/import_file");
var _csv_processor = require("./processors/csv_processor");
var _import_text = require("./routes/import_text");
var _constants = require("../common/constants");
var _ndjson_processor = require("./processors/ndjson_processor");
var _json_processor = require("./processors/json_processor");
var _file_processor_service = require("./processors/file_processor_service");
var _util = require("./utils/util");
var _preview = require("./routes/preview");
var _cat_indices = require("./routes/cat_indices");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class DataImporterPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "fileProcessors", new _file_processor_service.FileProcessorService());
    _defineProperty(this, "config", void 0);
  }
  async setup(core, {
    dataSource
  }) {
    this.config = await this.initializerContext.config.create().pipe((0, _operators.first)()).toPromise();
    const router = core.http.createRouter();

    // Register default file processors
    this.fileProcessors.registerFileProcessor(_constants.CSV_FILE_TYPE, new _csv_processor.CSVProcessor());
    this.fileProcessors.registerFileProcessor(_constants.NDJSON_FILE_TYPE, new _ndjson_processor.NDJSONProcessor());
    this.fileProcessors.registerFileProcessor(_constants.JSON_FILE_TYPE, new _json_processor.JSONProcessor());

    // Register server side APIs
    (0, _import_file.importFileRoute)(router, this.config, this.fileProcessors, !!dataSource);
    (0, _import_text.importTextRoute)(router, this.config, this.fileProcessors, !!dataSource);
    (0, _preview.previewRoute)(router, this.config, this.fileProcessors, !!dataSource);
    (0, _cat_indices.catIndicesRoute)(router, !!dataSource);
    return {
      registerFileProcessor: (fileType, fileProcessor) => {
        this.fileProcessors.registerFileProcessor(fileType, fileProcessor);
      }
    };
  }
  start(_) {
    try {
      // Config values have to be validated at start() since file types can be registered in other plugins
      (0, _util.validateFileTypes)(this.config.enabledFileTypes, this.fileProcessors);
    } catch (e) {
      throw new Error(`Error when calling start() for ${_constants.PLUGIN_NAME}: `, e);
    }
    return {};
  }
  stop() {}
}
exports.DataImporterPlugin = DataImporterPlugin;