/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure;

import com.microsoft.windowsazure.core.Builder;
import com.microsoft.windowsazure.core.DefaultBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configuration {
    public static final String PROPERTY_CONNECT_TIMEOUT = "com.microsoft.windowsazure.Configuration.connectTimeout";
    public static final String PROPERTY_READ_TIMEOUT = "com.microsoft.windowsazure.Configuration.readTimeout";
    public static final String PROPERTY_LOG_HTTP_REQUESTS = "com.microsoft.windowsazure.Configuration.logHttpRequests";
    public static final String PROPERTY_HTTP_PROXY_HOST = "http.proxyHost";
    public static final String PROPERTY_HTTP_PROXY_PORT = "http.proxyPort";
    public static final String PROPERTY_HTTP_PROXY_SCHEME = "http.proxyScheme";
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Builder builder;
    private static Log log = LogFactory.getLog(Configuration.class);

    public Configuration() {
        this.builder = DefaultBuilder.create();
    }

    public Configuration(Builder builder) {
        this.builder = builder;
    }

    public static Configuration getInstance() {
        try {
            return Configuration.load();
        }
        catch (IOException e) {
            log.error((Object)"Unable to load META-INF/com.microsoft.windowsazure.properties", (Throwable)e);
            return new Configuration();
        }
    }

    public static Configuration load() throws IOException {
        Configuration config = new Configuration();
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/com.microsoft.windowsazure.properties");
        if (stream != null) {
            Properties properties = new Properties();
            properties.load(stream);
            for (Map.Entry<Object, Object> key : properties.entrySet()) {
                config.setProperty(key.getKey().toString(), key.getValue());
            }
        }
        return config;
    }

    public <T> T create(Class<T> service) {
        return this.builder.build("", service, service, this.properties);
    }

    public <T> T create(String profile, Class<T> service) {
        return this.builder.build(profile, service, service, this.properties);
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

