/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core;

import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestContext;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class UserAgentFilter
implements ServiceRequestFilter {
    private static String azureSDKProductToken;

    public UserAgentFilter() {
        if (azureSDKProductToken == null || azureSDKProductToken.isEmpty()) {
            azureSDKProductToken = this.createAzureSDKProductToken();
        }
    }

    @Override
    public void filter(ServiceRequestContext request) {
        String userAgent;
        if (request.getHeader("User-Agent") != null) {
            String currentUserAgent = request.getHeader("User-Agent");
            userAgent = azureSDKProductToken + " " + currentUserAgent;
            request.removeHeader("User-Agent");
        } else {
            userAgent = azureSDKProductToken;
        }
        request.setHeader("User-Agent", userAgent);
    }

    private String createAzureSDKProductToken() {
        String version = this.getVersionFromResources();
        String productToken = version != null && !version.isEmpty() ? "Azure-SDK-For-Java/" + version : "Azure-SDK-For-Java";
        return productToken;
    }

    private String getVersionFromResources() {
        String version = null;
        Properties properties = new Properties();
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/com.microsoft.azure/azure-core/pom.properties");
            if (inputStream != null) {
                properties.load(inputStream);
                version = properties.getProperty("version");
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version;
    }
}

