/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FleetEventType {
    INSTANCE_CHANGE("instance-change"),
    FLEET_CHANGE("fleet-change"),
    SERVICE_ERROR("service-error"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FleetEventType> VALUE_MAP;
    private final String value;

    private FleetEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FleetEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FleetEventType> knownValues() {
        EnumSet<FleetEventType> knownValues = EnumSet.allOf(FleetEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FleetEventType.class, FleetEventType::toString);
    }
}

