/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.StreamException;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.io.StreamIOException;
import org.bouncycastle.crypto.internal.io.Utils;
import org.bouncycastle.crypto.internal.modes.AEADCipher;

public class CipherOutputStreamImpl
extends CipherOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    private OutputStream out;
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADCipher aeadBlockCipher;
    private final byte[] oneByte = new byte[1];
    private byte[] buf;
    private static final int INPUT_LEN = 4096;

    public CipherOutputStreamImpl(OutputStream outputStream, BufferedBlockCipher bufferedBlockCipher) {
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = bufferedBlockCipher.getUnderlyingCipher().getAlgorithmName();
        this.out = outputStream;
        this.bufferedBlockCipher = bufferedBlockCipher;
    }

    public CipherOutputStreamImpl(OutputStream outputStream, StreamCipher streamCipher) {
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = streamCipher.getAlgorithmName();
        this.out = outputStream;
        this.streamCipher = streamCipher;
    }

    public CipherOutputStreamImpl(OutputStream outputStream, AEADCipher aEADCipher) {
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = aEADCipher.getAlgorithmName();
        this.out = outputStream;
        this.aeadBlockCipher = aEADCipher;
    }

    @Override
    public void write(int n) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.oneByte[0] = (byte)n;
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        if (this.bufferedBlockCipher != null) {
            while (n2 > 0) {
                this.ensureCapacity(4096, false);
                int n3 = this.bufferedBlockCipher.processBytes(byArray, n, n2 < 4096 ? n2 : 4096, this.buf, 0);
                if (n3 != 0) {
                    this.out.write(this.buf, 0, n3);
                }
                n += 4096;
                n2 -= 4096;
            }
        } else if (this.aeadBlockCipher != null) {
            while (n2 > 0) {
                this.ensureCapacity(4096, false);
                int n4 = this.aeadBlockCipher.processBytes(byArray, n, n2 < 4096 ? n2 : 4096, this.buf, 0);
                if (n4 != 0) {
                    this.out.write(this.buf, 0, n4);
                }
                n += 4096;
                n2 -= 4096;
            }
        } else {
            while (n2 > 0) {
                this.ensureCapacity(4096, false);
                int n5 = this.streamCipher.processBytes(byArray, n, n2 < 4096 ? n2 : 4096, this.buf, 0);
                if (n5 != 0) {
                    this.out.write(this.buf, 0, n5);
                }
                n += 4096;
                n2 -= 4096;
            }
        }
    }

    private void ensureCapacity(int n, boolean bl) {
        int n2 = n;
        if (bl) {
            if (this.bufferedBlockCipher != null) {
                n2 = this.bufferedBlockCipher.getOutputSize(n);
            } else if (this.aeadBlockCipher != null) {
                n2 = this.aeadBlockCipher.getOutputSize(n);
            }
        } else if (this.bufferedBlockCipher != null) {
            n2 = this.bufferedBlockCipher.getUpdateOutputSize(n);
        } else if (this.aeadBlockCipher != null) {
            n2 = this.aeadBlockCipher.getUpdateOutputSize(n);
        }
        if (this.buf == null || this.buf.length < n2) {
            this.buf = new byte[n2];
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        IOException iOException;
        block14: {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            this.ensureCapacity(0, true);
            iOException = null;
            try {
                int n;
                if (this.bufferedBlockCipher != null) {
                    n = this.bufferedBlockCipher.doFinal(this.buf, 0);
                    if (n != 0) {
                        this.out.write(this.buf, 0, n);
                    }
                } else if (this.aeadBlockCipher != null) {
                    n = this.aeadBlockCipher.doFinal(this.buf, 0);
                    if (n != 0) {
                        this.out.write(this.buf, 0, n);
                    }
                } else if (this.streamCipher != null) {
                    this.streamCipher.reset();
                }
            }
            catch (org.bouncycastle.crypto.internal.InvalidCipherTextException invalidCipherTextException) {
                iOException = new InvalidCipherTextException("Error finalising cipher data: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
            }
            catch (IllegalStateException illegalStateException) {
                iOException = new StreamException(illegalStateException.getMessage(), illegalStateException.getCause());
            }
            catch (Exception exception) {
                iOException = new StreamIOException("Error closing stream: ", exception);
            }
            try {
                this.flush();
            }
            catch (IOException iOException2) {
                if (iOException != null) break block14;
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }
}

