/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.CompletionHandler;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;

public final class AsynchronousByteChannelWriteSubscriber
implements Subscriber<ByteBuffer> {
    private static final ClientLogger LOGGER = new ClientLogger(AsynchronousByteChannelWriteSubscriber.class);
    private volatile boolean isWriting = false;
    private volatile boolean isCompleted = false;
    private final AsynchronousByteChannel channel;
    private final MonoSink<Void> emitter;
    private Subscription subscription;

    public AsynchronousByteChannelWriteSubscriber(AsynchronousByteChannel channel, MonoSink<Void> emitter) {
        this.channel = channel;
        this.emitter = emitter;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.subscription, (Subscription)s)) {
            this.subscription = s;
            s.request(1L);
        }
    }

    public void onNext(ByteBuffer bytes) {
        try {
            if (this.isWriting) {
                this.onError(new IllegalStateException("Received onNext while processing another write operation."));
            } else {
                this.write(bytes);
            }
        }
        catch (Exception ex) {
            this.onError(ex);
        }
    }

    private void write(final ByteBuffer bytes) {
        this.isWriting = true;
        this.channel.write(bytes, bytes, new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer result, ByteBuffer attachment) {
                if (bytes.hasRemaining()) {
                    AsynchronousByteChannelWriteSubscriber.this.write(bytes);
                } else {
                    AsynchronousByteChannelWriteSubscriber.this.isWriting = false;
                    if (AsynchronousByteChannelWriteSubscriber.this.isCompleted) {
                        AsynchronousByteChannelWriteSubscriber.this.emitter.success();
                    } else {
                        AsynchronousByteChannelWriteSubscriber.this.subscription.request(1L);
                    }
                }
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                AsynchronousByteChannelWriteSubscriber.this.onError(exc);
            }
        });
    }

    public void onError(Throwable throwable) {
        this.isWriting = false;
        this.subscription.cancel();
        this.emitter.error(LOGGER.logThrowableAsError(throwable));
    }

    public void onComplete() {
        this.isCompleted = true;
        if (!this.isWriting) {
            this.emitter.success();
        }
    }
}

