/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ECChunk;

@InterfaceAudience.Private
public final class CoderUtil {
    private static byte[] emptyChunk = new byte[4096];

    private CoderUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getEmptyChunk(int leastLength) {
        if (emptyChunk.length >= leastLength) {
            return emptyChunk;
        }
        Class<CoderUtil> clazz = CoderUtil.class;
        synchronized (CoderUtil.class) {
            emptyChunk = new byte[leastLength];
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return emptyChunk;
        }
    }

    static ByteBuffer resetBuffer(ByteBuffer buffer, int len) {
        int pos = buffer.position();
        buffer.put(CoderUtil.getEmptyChunk(len), 0, len);
        buffer.position(pos);
        return buffer;
    }

    static byte[] resetBuffer(byte[] buffer, int offset, int len) {
        byte[] empty = CoderUtil.getEmptyChunk(len);
        System.arraycopy(empty, 0, buffer, offset, len);
        return buffer;
    }

    static void resetOutputBuffers(ByteBuffer[] buffers, int dataLen) {
        for (ByteBuffer buffer : buffers) {
            CoderUtil.resetBuffer(buffer, dataLen);
        }
    }

    static void resetOutputBuffers(byte[][] buffers, int[] offsets, int dataLen) {
        for (int i = 0; i < buffers.length; ++i) {
            CoderUtil.resetBuffer(buffers[i], offsets[i], dataLen);
        }
    }

    static ByteBuffer[] toBuffers(ECChunk[] chunks) {
        ByteBuffer[] buffers = new ByteBuffer[chunks.length];
        for (int i = 0; i < chunks.length; ++i) {
            ECChunk chunk = chunks[i];
            if (chunk == null) {
                buffers[i] = null;
                continue;
            }
            buffers[i] = chunk.getBuffer();
            if (!chunk.isAllZero()) continue;
            CoderUtil.resetBuffer(buffers[i], buffers[i].remaining());
        }
        return buffers;
    }

    static ByteBuffer cloneAsDirectByteBuffer(byte[] input, int offset, int len) {
        if (input == null) {
            return null;
        }
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(len);
        directBuffer.put(input, offset, len);
        directBuffer.flip();
        return directBuffer;
    }

    static <T> int[] getNullIndexes(T[] inputs) {
        int[] nullIndexes = new int[inputs.length];
        int idx = 0;
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] != null) continue;
            nullIndexes[idx++] = i;
        }
        return Arrays.copyOf(nullIndexes, idx);
    }

    static <T> T findFirstValidInput(T[] inputs) {
        for (T input : inputs) {
            if (input == null) continue;
            return input;
        }
        throw new HadoopIllegalArgumentException("Invalid inputs are found, all being null");
    }

    static <T> int[] getValidIndexes(T[] inputs) {
        int[] validIndexes = new int[inputs.length];
        int idx = 0;
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) continue;
            validIndexes[idx++] = i;
        }
        return Arrays.copyOf(validIndexes, idx);
    }
}

