/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.functions.scan;

import java.io.IOException;
import java.security.AccessController;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.spark.client.SparkClient;
import org.opensearch.sql.spark.functions.response.DefaultSparkSqlFunctionResponseHandle;
import org.opensearch.sql.spark.functions.response.SparkSqlFunctionResponseHandle;
import org.opensearch.sql.spark.request.SparkQueryRequest;
import org.opensearch.sql.storage.TableScanOperator;

public class SparkSqlFunctionTableScanOperator
extends TableScanOperator {
    private final SparkClient sparkClient;
    private final SparkQueryRequest request;
    private SparkSqlFunctionResponseHandle sparkResponseHandle;
    private static final Logger LOG = LogManager.getLogger();

    public void open() {
        super.open();
        this.sparkResponseHandle = AccessController.doPrivileged(() -> {
            try {
                JSONObject responseObject = this.sparkClient.sql(this.request.getSql());
                return new DefaultSparkSqlFunctionResponseHandle(responseObject);
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
                throw new RuntimeException(String.format("Error fetching data from spark server: %s", e.getMessage()));
            }
        });
    }

    public boolean hasNext() {
        return this.sparkResponseHandle.hasNext();
    }

    public ExprValue next() {
        return this.sparkResponseHandle.next();
    }

    public String explain() {
        return String.format(Locale.ROOT, "sql(%s)", this.request.getSql());
    }

    public ExecutionEngine.Schema schema() {
        return this.sparkResponseHandle.schema();
    }

    @Generated
    public SparkSqlFunctionTableScanOperator(SparkClient sparkClient, SparkQueryRequest request) {
        this.sparkClient = sparkClient;
        this.request = request;
    }
}

